/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.benchmark;

import io.nats.client.Statistics;
import io.nats.examples.benchmark.Utils;
import java.text.DecimalFormat;

public class Sample {
    int jobMsgCnt;
    long msgCnt;
    long msgBytes;
    long ioBytes;
    long start;
    long end;
    static final double BILLION = 1.0E9;

    Sample() {
    }

    public Sample(int jobCount, int msgSize, long start, long end, Statistics stats) {
        this.jobMsgCnt = jobCount;
        this.start = start;
        this.end = end;
        this.msgBytes = (long)msgSize * (long)jobCount;
        this.msgCnt = stats.getOutMsgs() + stats.getInMsgs();
        this.ioBytes = stats.getOutBytes() + stats.getInBytes();
    }

    public long duration() {
        return this.end - this.start;
    }

    public double throughput() {
        if (this.duration() == 0L) {
            return 0.0;
        }
        return (double)this.msgBytes / ((double)this.duration() / 1.0E9);
    }

    public long rate() {
        if (this.duration() == 0L) {
            return 0L;
        }
        return (long)((double)this.jobMsgCnt / ((double)this.duration() / 1.0E9));
    }

    public double seconds() {
        return (double)this.duration() / 1.0E9;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat("#,###");
        String rate = formatter.format(this.rate());
        String throughput = Utils.humanBytes(this.throughput());
        return String.format("%s msgs/sec ~ %s/sec", rate, throughput);
    }

    final int getJobMsgCnt() {
        return this.jobMsgCnt;
    }

    final void setJobMsgCnt(int jobMsgCnt) {
        this.jobMsgCnt = jobMsgCnt;
    }

    final long getMsgCnt() {
        return this.msgCnt;
    }

    final void setMsgCnt(long msgCnt) {
        this.msgCnt = msgCnt;
    }

    final long getMsgBytes() {
        return this.msgBytes;
    }

    final void setMsgBytes(long msgBytes) {
        this.msgBytes = msgBytes;
    }

    final long getIoBytes() {
        return this.ioBytes;
    }

    final void setIoBytes(long ioBytes) {
        this.ioBytes = ioBytes;
    }

    final long getStart() {
        return this.start;
    }

    final void setStart(long start) {
        this.start = start;
    }

    final long getEnd() {
        return this.end;
    }

    final void setEnd(long end) {
        this.end = end;
    }
}

