/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.benchmark;

import io.nats.examples.benchmark.Sample;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

class SampleGroup
extends Sample {
    private final List<Sample> samples = new ArrayList<Sample>();

    SampleGroup(SampleGroup ... groups) {
        for (SampleGroup g : groups) {
            for (Sample stat : g.samples) {
                this.addSample(stat);
            }
        }
    }

    public final List<Sample> getSamples() {
        return this.samples;
    }

    public void addSample(Sample stat) {
        this.samples.add(stat);
        if (this.samples.size() == 1) {
            this.start = stat.start;
            this.end = stat.end;
        }
        this.ioBytes += stat.ioBytes;
        this.jobMsgCnt += stat.jobMsgCnt;
        this.msgCnt += stat.msgCnt;
        this.msgBytes += stat.msgBytes;
        this.start = Math.min(this.start, stat.start);
        this.end = Math.max(this.end, stat.end);
    }

    public long minRate() {
        long min = this.samples.isEmpty() ? 0L : this.samples.get(0).rate();
        for (Sample s : this.samples) {
            min = Math.min(min, s.rate());
        }
        return min;
    }

    public long maxRate() {
        long max = this.samples.isEmpty() ? 0L : this.samples.get(0).rate();
        for (Sample s : this.samples) {
            max = Math.max(max, s.rate());
        }
        return max;
    }

    public long avgRate() {
        long sum = 0L;
        for (Sample s : this.samples) {
            sum += s.rate();
        }
        return sum / (long)this.samples.size();
    }

    public double stdDev() {
        double avg = this.avgRate();
        double sum = 0.0;
        for (Sample s : this.samples) {
            sum += Math.pow((double)s.rate() - avg, 2.0);
        }
        double variance = sum / (double)this.samples.size();
        return Math.sqrt(variance);
    }

    public String statistics() {
        DecimalFormat formatter = new DecimalFormat("#,###");
        DecimalFormat floatFormatter = new DecimalFormat("#,###.00");
        return String.format("min %s | avg %s | max %s | stddev %s msgs", formatter.format(this.minRate()), formatter.format(this.avgRate()), formatter.format(this.maxRate()), floatFormatter.format(this.stdDev()));
    }

    boolean hasSamples() {
        return !this.samples.isEmpty();
    }
}

