/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.Connection;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.StreamInfo;
import io.nats.examples.chaosTestApp.ConnectableConsumer;
import io.nats.examples.chaosTestApp.Output;
import io.nats.examples.chaosTestApp.OutputErrorListener;
import io.nats.examples.chaosTestApp.Publisher;
import io.nats.examples.chaosTestApp.support.CommandLine;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class Monitor
implements Runnable,
Consumer<String> {
    static final String MONITOR_LABEL = "MONITOR";
    static final long REPORT_FREQUENCY = 5000L;
    static final int SHORT_REPORTS = 50;
    final CommandLine cmd;
    final Publisher publisher;
    final List<ConnectableConsumer> consumers;
    final AtomicBoolean reportFull;

    public Monitor(CommandLine cmd, Publisher publisher, List<ConnectableConsumer> consumers) {
        this.cmd = cmd;
        this.publisher = publisher;
        this.consumers = consumers;
        this.reportFull = new AtomicBoolean(true);
    }

    @Override
    public void accept(String s) {
        this.reportFull.set(true);
    }

    @Override
    public void run() {
        Options options = new Options.Builder().servers(this.cmd.servers).connectionListener((c, t) -> {
            this.reportFull.set(true);
            String s = "Connection: " + c.getServerInfo().getPort() + " " + (Object)((Object)t);
            Output.controlMessage(MONITOR_LABEL, s);
        }).errorListener(new OutputErrorListener(MONITOR_LABEL, this){}).maxReconnects(-1).build();
        long started = System.currentTimeMillis();
        int shortReportsOwed = 0;
        try {
            Connection nc = Nats.connect(options);
            Throwable throwable = null;
            try {
                try {
                    JetStreamManagement jsm = nc.jetStreamManagement();
                    while (true) {
                        Thread.sleep(5000L);
                        try {
                            StringBuilder conReport = new StringBuilder();
                            if (this.reportFull.get()) {
                                Iterator<ConnectableConsumer> si = jsm.getStreamInfo(this.cmd.stream);
                                String message = "Stream\n" + Output.formatted(((StreamInfo)((Object)si)).getConfiguration()) + "\n" + Output.formatted(((StreamInfo)((Object)si)).getClusterInfo());
                                Output.controlMessage(MONITOR_LABEL, message);
                                this.reportFull.set(false);
                                if (this.consumers != null) {
                                    for (ConnectableConsumer con : this.consumers) {
                                        con.refreshInfo();
                                    }
                                }
                            }
                            if (shortReportsOwed < 1) {
                                shortReportsOwed = 50;
                                if (this.consumers != null) {
                                    for (ConnectableConsumer con : this.consumers) {
                                        conReport.append("\n").append(con.label).append(" | Last Sequence: ").append(con.getLastReceivedSequence());
                                    }
                                }
                            } else {
                                --shortReportsOwed;
                                if (this.consumers != null) {
                                    for (ConnectableConsumer con : this.consumers) {
                                        conReport.append(" | ").append(con.name).append(": ").append(con.getLastReceivedSequence());
                                    }
                                }
                            }
                            String pubReport = "";
                            if (this.publisher != null) {
                                pubReport = " | Publisher: " + this.publisher.getLastSeqno() + (this.publisher.isInErrorState() ? " (Paused)" : " (Running)");
                            }
                            Output.controlMessage(MONITOR_LABEL, "Uptime: " + Monitor.uptime(started) + pubReport + conReport);
                        }
                        catch (Exception e) {
                            Output.controlMessage(MONITOR_LABEL, e.getMessage());
                            this.reportFull.set(true);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (nc != null) {
                    if (throwable != null) {
                        try {
                            nc.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        nc.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    private static String uptime(long started) {
        return Duration.ofMillis(System.currentTimeMillis() - started).toString().replace("PT", "");
    }
}

