/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.Mirror;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamInfo;
import io.nats.client.support.JsonUtils;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.time.Duration;
import java.util.List;

public class NatsJsMirrorSubUseCases {
    static final String usageString = "\nUsage: java -cp <classpath> NatsJsMirrorSubUseCases [-s server] [-strm stream] [-mir mirror] [-sub subject] [-dur durable]\n\nDefault Values:\n   [-strm] example-stream\n   [-mir]  example-mirror\n   [-sub]  example-subject\n   [-dur]  example-durable\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Mirror Subscription Use Cases", args, usageString).defaultStream("example-stream").defaultMirror("example-mirror").defaultSubject("example-subject").defaultDurable("example-durable").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server, true));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            JetStream js = nc.jetStream();
            StreamConfiguration sc = StreamConfiguration.builder().name(exArgs.stream).storageType(StorageType.Memory).subjects(exArgs.subject).build();
            jsm.addStream(sc);
            Mirror mirror = ((Mirror.Builder)Mirror.builder().sourceName(exArgs.stream)).build();
            sc = StreamConfiguration.builder().name(exArgs.mirror).storageType(StorageType.Memory).mirror(mirror).build();
            StreamInfo si = jsm.addStream(sc);
            System.out.println("The mirror configuration...");
            JsonUtils.printFormatted(si.getConfiguration());
            System.out.println("\nThe mirror info...");
            JsonUtils.printFormatted(si.getMirrorInfo());
            NatsJsUtils.publish(js, exArgs.subject, 5);
            System.out.println("\nMessages [pushed] from the stream, " + exArgs.stream + "...");
            JetStreamSubscription sub = js.subscribe(exArgs.subject);
            Message msg = sub.nextMessage(Duration.ofSeconds(1L));
            while (msg != null) {
                if (msg.isJetStream()) {
                    msg.ack();
                    System.out.println(msg + " [pushed] from " + msg.metaData().getStream());
                }
                msg = sub.nextMessage(Duration.ofSeconds(1L));
            }
            System.out.println("\nMessages [pushed] from the mirror, " + exArgs.mirror + "...");
            PushSubscribeOptions pushSo = PushSubscribeOptions.stream(exArgs.mirror);
            sub = js.subscribe(exArgs.subject, pushSo);
            msg = sub.nextMessage(Duration.ofSeconds(1L));
            while (msg != null) {
                if (msg.isJetStream()) {
                    msg.ack();
                    System.out.println(msg + " [pushed] from " + msg.metaData().getStream());
                }
                msg = sub.nextMessage(Duration.ofSeconds(1L));
            }
            System.out.println("\nMessages [pulled] from the mirror, " + exArgs.mirror + "...");
            PullSubscribeOptions pullSo = ((PullSubscribeOptions.Builder)((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().stream(exArgs.mirror)).durable(exArgs.durable)).build();
            sub = js.subscribe(exArgs.subject, pullSo);
            List<Message> messages = sub.fetch(5, Duration.ofSeconds(1L));
            for (Message pulled : messages) {
                pulled.ack();
                System.out.println(pulled + " [pulled] from " + pulled.metaData().getStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

