/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PullSubscribeOptions;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public class NatsJsPullSubExpiresIn {
    static final String usageString = "\nUsage: java -cp <classpath> NatsJsPullSubExpiresIn [-s server] [-strm stream] [-sub subject] [-dur durable] [-mcnt msgCount]\n\nDefault Values:\n   [-strm] expires-in-stream\n   [-sub]  expires-in-subject\n   [-dur]  expires-in-durable\n   [-mcnt] 15\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Pull Subscription using primitive Batch With Expire", args, usageString).defaultStream("expires-in-stream").defaultSubject("expires-in-subject").defaultDurable("expires-in-durable").defaultMsgCount(15).build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            NatsJsUtils.publishInBackground(js, exArgs.subject, "expires-in-message", exArgs.msgCount);
            PullSubscribeOptions pullOptions = ((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().durable(exArgs.durable)).build();
            JetStreamSubscription sub = js.subscribe(exArgs.subject, pullOptions);
            nc.flush(Duration.ofSeconds(1L));
            int red = 0;
            while (red < exArgs.msgCount) {
                sub.pullExpiresIn(10, Duration.ofSeconds(1L));
                Message m = sub.nextMessage(Duration.ofSeconds(1L));
                while (m != null) {
                    if (m.isJetStream()) {
                        System.out.println("" + ++red + ". " + m);
                        m.ack();
                    }
                    m = sub.nextMessage(Duration.ofMillis(100L));
                }
            }
            jsm.deleteStream(exArgs.stream);
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        catch (JetStreamApiException | IOException | InterruptedException | TimeoutException e) {
            System.err.println(e);
        }
    }
}

