/*
 * Decompiled with CFR 0.152.
 */
package io.nessus;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public class Config {
    private WalletConfig wallet;

    public static Config parseConfig(URL configURL) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Config)objectMapper.readValue(configURL, Config.class);
    }

    public WalletConfig getWallet() {
        return this.wallet;
    }

    void setWallet(WalletConfig wallet) {
        this.wallet = wallet;
    }

    public String toString() {
        return this.wallet.toString();
    }

    public static class Address {
        private String privKey;
        private String pubKey;
        private List<String> labels;

        public String getPrivKey() {
            return this.privKey;
        }

        void setPrivKey(String privKey) {
            this.privKey = privKey;
        }

        public String getPubKey() {
            return this.pubKey;
        }

        void setPubKey(String pubKey) {
            this.pubKey = pubKey;
        }

        public List<String> getLabels() {
            return Collections.unmodifiableList(this.labels);
        }

        void setLabels(List<String> labels) {
            this.labels = labels;
        }

        public String toString() {
            return String.format("privKey=%s, pubKey=%s, labels=%s", this.privKey, this.pubKey, this.labels);
        }
    }

    public static class WalletConfig {
        private List<Address> addresses;

        public List<Address> getAddresses() {
            return Collections.unmodifiableList(this.addresses);
        }

        void setAddresses(List<Address> address) {
            this.addresses = address;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.addresses.size(); ++i) {
                Address addr = this.addresses.get(i);
                sb.append(String.format("%02d: %s\n", i, addr));
            }
            return sb.toString();
        }
    }
}

