/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;

public class DelegatingDecompressorFrameListener
extends Http2FrameListenerDecorator {
    private final Http2Connection connection;
    private final boolean strict;
    private boolean flowControllerInitialized;
    final Http2Connection.PropertyKey propertyKey;

    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener) {
        this(connection, listener, true);
    }

    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener, boolean strict) {
        super(listener);
        this.connection = connection;
        this.strict = strict;
        this.propertyKey = connection.newKey();
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream stream) {
                Http2Decompressor decompressor = DelegatingDecompressorFrameListener.this.decompressor(stream);
                if (decompressor != null) {
                    DelegatingDecompressorFrameListener.this.cleanup(stream, decompressor);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null) {
            return this.listener.onDataRead(ctx, streamId, data, padding, endOfStream);
        }
        EmbeddedChannel channel = decompressor.decompressor();
        int compressedBytes = data.readableBytes() + padding;
        int processedBytes = 0;
        decompressor.incrementCompressedBytes(compressedBytes);
        try {
            channel.writeInbound(new Object[]{data.retain()});
            ByteBuf buf = DelegatingDecompressorFrameListener.nextReadableBuf(channel);
            if (buf == null && endOfStream && channel.finish()) {
                buf = DelegatingDecompressorFrameListener.nextReadableBuf(channel);
            }
            if (buf == null) {
                if (endOfStream) {
                    this.listener.onDataRead(ctx, streamId, Unpooled.EMPTY_BUFFER, padding, true);
                }
                decompressor.incrementDecompressedByes(compressedBytes);
                processedBytes = compressedBytes;
            } else {
                try {
                    decompressor.incrementDecompressedByes(padding);
                    while (true) {
                        ByteBuf nextBuf;
                        boolean decompressedEndOfStream;
                        boolean bl = decompressedEndOfStream = (nextBuf = DelegatingDecompressorFrameListener.nextReadableBuf(channel)) == null && endOfStream;
                        if (decompressedEndOfStream && channel.finish()) {
                            nextBuf = DelegatingDecompressorFrameListener.nextReadableBuf(channel);
                            decompressedEndOfStream = nextBuf == null;
                        }
                        decompressor.incrementDecompressedByes(buf.readableBytes());
                        processedBytes += this.listener.onDataRead(ctx, streamId, buf, padding, decompressedEndOfStream);
                        if (nextBuf == null) {
                            break;
                        }
                        padding = 0;
                        buf.release();
                        buf = nextBuf;
                    }
                }
                finally {
                    buf.release();
                }
            }
            decompressor.incrementProcessedBytes(processedBytes);
            return processedBytes;
        }
        catch (Http2Exception e) {
            decompressor.incrementProcessedBytes(compressedBytes);
            throw e;
        }
        catch (Throwable t) {
            decompressor.incrementProcessedBytes(compressedBytes);
            throw Http2Exception.streamError(stream.id(), Http2Error.INTERNAL_ERROR, t, "Decompressor error detected while delegating data read on streamId %d", stream.id());
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
    }

    protected EmbeddedChannel newContentDecompressor(ChannelHandlerContext ctx, CharSequence contentEncoding) throws Http2Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)wrapper)});
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence contentEncoding) throws Http2Exception {
        return HttpHeaderValues.IDENTITY;
    }

    private void initDecompressor(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            return;
        }
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null && !endOfStream) {
            EmbeddedChannel channel;
            CharSequence contentEncoding = (CharSequence)headers.get(HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding == null) {
                contentEncoding = HttpHeaderValues.IDENTITY;
            }
            if ((channel = this.newContentDecompressor(ctx, contentEncoding)) != null) {
                decompressor = new Http2Decompressor(channel);
                stream.setProperty(this.propertyKey, decompressor);
                CharSequence targetContentEncoding = this.getTargetContentEncoding(contentEncoding);
                if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(targetContentEncoding)) {
                    headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    headers.set(HttpHeaderNames.CONTENT_ENCODING, targetContentEncoding);
                }
            }
        }
        if (decompressor != null) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            if (!this.flowControllerInitialized) {
                this.flowControllerInitialized = true;
                this.connection.local().flowController(new ConsumedBytesConverter(this.connection.local().flowController()));
            }
        }
    }

    Http2Decompressor decompressor(Http2Stream stream) {
        return stream == null ? null : (Http2Decompressor)stream.getProperty(this.propertyKey);
    }

    private void cleanup(Http2Stream stream, Http2Decompressor decompressor) {
        EmbeddedChannel channel = decompressor.decompressor();
        if (channel.finish()) {
            ByteBuf buf;
            while ((buf = (ByteBuf)channel.readInbound()) != null) {
                buf.release();
            }
        }
        decompressor = (Http2Decompressor)stream.removeProperty(this.propertyKey);
    }

    private static ByteBuf nextReadableBuf(EmbeddedChannel decompressor) {
        ByteBuf buf;
        while (true) {
            if ((buf = (ByteBuf)decompressor.readInbound()) == null) {
                return null;
            }
            if (buf.isReadable()) break;
            buf.release();
        }
        return buf;
    }

    private static final class Http2Decompressor {
        private final EmbeddedChannel decompressor;
        private int processed;
        private int compressed;
        private int decompressed;

        Http2Decompressor(Http2Decompressor rhs) {
            this(rhs.decompressor);
            this.processed = rhs.processed;
            this.compressed = rhs.compressed;
            this.decompressed = rhs.decompressed;
        }

        Http2Decompressor(EmbeddedChannel decompressor) {
            this.decompressor = decompressor;
        }

        EmbeddedChannel decompressor() {
            return this.decompressor;
        }

        void incrementProcessedBytes(int delta) {
            if (this.processed + delta < 0) {
                throw new IllegalArgumentException("processed bytes cannot be negative");
            }
            this.processed += delta;
        }

        void incrementCompressedBytes(int delta) {
            if (this.compressed + delta < 0) {
                throw new IllegalArgumentException("compressed bytes cannot be negative");
            }
            this.compressed += delta;
        }

        void incrementDecompressedByes(int delta) {
            if (this.decompressed + delta < 0) {
                throw new IllegalArgumentException("decompressed bytes cannot be negative");
            }
            this.decompressed += delta;
        }

        int consumeProcessedBytes(int processedBytes) {
            this.incrementProcessedBytes(-processedBytes);
            double consumedRatio = (double)processedBytes / (double)this.decompressed;
            int consumedCompressed = Math.min(this.compressed, (int)Math.ceil((double)this.compressed * consumedRatio));
            this.incrementDecompressedByes(-Math.min(this.decompressed, (int)Math.ceil((double)this.decompressed * consumedRatio)));
            this.incrementCompressedBytes(-consumedCompressed);
            return consumedCompressed;
        }
    }

    private final class ConsumedBytesConverter
    implements Http2LocalFlowController {
        private final Http2LocalFlowController flowController;

        ConsumedBytesConverter(Http2LocalFlowController flowController) {
            this.flowController = (Http2LocalFlowController)ObjectUtil.checkNotNull((Object)flowController, (String)"flowController");
        }

        @Override
        public Http2LocalFlowController frameWriter(Http2FrameWriter frameWriter) {
            return this.flowController.frameWriter(frameWriter);
        }

        @Override
        public void channelHandlerContext(ChannelHandlerContext ctx) throws Http2Exception {
            this.flowController.channelHandlerContext(ctx);
        }

        @Override
        public void initialWindowSize(int newWindowSize) throws Http2Exception {
            this.flowController.initialWindowSize(newWindowSize);
        }

        @Override
        public int initialWindowSize() {
            return this.flowController.initialWindowSize();
        }

        @Override
        public int windowSize(Http2Stream stream) {
            return this.flowController.windowSize(stream);
        }

        @Override
        public void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
            this.flowController.incrementWindowSize(stream, delta);
        }

        @Override
        public void receiveFlowControlledFrame(Http2Stream stream, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            this.flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
        }

        @Override
        public boolean consumeBytes(Http2Stream stream, int numBytes) throws Http2Exception {
            Http2Decompressor decompressor = DelegatingDecompressorFrameListener.this.decompressor(stream);
            Http2Decompressor copy = null;
            try {
                if (decompressor != null) {
                    copy = new Http2Decompressor(decompressor);
                    numBytes = decompressor.consumeProcessedBytes(numBytes);
                }
                return this.flowController.consumeBytes(stream, numBytes);
            }
            catch (Http2Exception e) {
                if (copy != null) {
                    stream.setProperty(DelegatingDecompressorFrameListener.this.propertyKey, copy);
                }
                throw e;
            }
            catch (Throwable t) {
                if (copy != null) {
                    stream.setProperty(DelegatingDecompressorFrameListener.this.propertyKey, copy);
                }
                throw new Http2Exception(Http2Error.INTERNAL_ERROR, "Error while returning bytes to flow control window", t);
            }
        }

        @Override
        public int unconsumedBytes(Http2Stream stream) {
            return this.flowController.unconsumedBytes(stream);
        }

        @Override
        public int initialWindowSize(Http2Stream stream) {
            return this.flowController.initialWindowSize(stream);
        }
    }
}

