/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.SystemPropertyUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;

public final class DetectionUtil {
    private static final int JAVA_VERSION = DetectionUtil.javaVersion0();
    private static final boolean HAS_UNSAFE = DetectionUtil.hasUnsafe(AtomicInteger.class.getClassLoader());
    private static final boolean IS_WINDOWS;

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    private static boolean hasUnsafe(ClassLoader loader) {
        String value = SystemPropertyUtil.get("io.netty.noUnsafe");
        if (value != null) {
            return false;
        }
        value = SystemPropertyUtil.get("io.netty.tryUnsafe");
        if (value == null) {
            value = SystemPropertyUtil.get("org.jboss.netty.tryUnsafe", "true");
        }
        if (!"true".equalsIgnoreCase(value)) {
            return false;
        }
        try {
            Class<?> unsafeClazz = Class.forName("sun.misc.Unsafe", true, loader);
            return DetectionUtil.hasUnsafeField(unsafeClazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasUnsafeField(final Class<?> unsafeClass) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                unsafeClass.getDeclaredField("theUnsafe");
                return true;
            }
        });
    }

    private static int javaVersion0() {
        try {
            Class.forName("android.app.Application", false, ClassLoader.getSystemClassLoader());
            return 6;
        }
        catch (Exception e) {
            try {
                Deflater.class.getDeclaredField("SYNC_FLUSH");
                return 7;
            }
            catch (Exception exception) {
                return 6;
            }
        }
    }

    private DetectionUtil() {
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = os.contains("win");
    }
}

