/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.echo;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;

@ChannelHandler.Sharable
public class EchoServerHandler
extends ChannelInboundByteHandlerAdapter {
    private static final Logger logger = Logger.getLogger(EchoServerHandler.class.getName());

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) {
        ByteBuf out = ctx.nextOutboundByteBuffer();
        out.discardReadBytes();
        out.writeBytes(in);
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }
}

