/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.html5;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.http.websocketx.html5.CustomTextFrameHandler;
import io.netty.handler.codec.http.HttpChunkAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class WebSocketServer {
    private final int port;

    public WebSocketServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        ServerBootstrap sb = new ServerBootstrap();
        try {
            ((ServerBootstrap)sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class).localAddress((SocketAddress)new InetSocketAddress(this.port))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestDecoder(), new HttpChunkAggregator(65536), new HttpResponseEncoder(), new WebSocketServerProtocolHandler("/websocket"), new CustomTextFrameHandler()});
                }
            });
            Channel ch = sb.bind().sync().channel();
            System.out.println("Web socket server started at port " + this.port);
            ch.closeFuture().sync();
        }
        finally {
            sb.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new WebSocketServer(port).run();
    }
}

