/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.sslserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http.websocketx.sslserver.WebSocketSslServerHandler;
import io.netty.example.http.websocketx.sslserver.WebSocketSslServerSslContext;
import io.netty.handler.codec.http.HttpChunkAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class WebSocketSslServerInitializer
extends ChannelInitializer<SocketChannel> {
    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SSLEngine engine = WebSocketSslServerSslContext.getInstance().getServerContext().createSSLEngine();
        engine.setUseClientMode(false);
        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("handler", (ChannelHandler)new WebSocketSslServerHandler());
    }
}

