/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.codec.socks.SocksAuthResponse;
import io.netty.codec.socks.SocksCmdRequest;
import io.netty.codec.socks.SocksCmdRequestDecoder;
import io.netty.codec.socks.SocksInitResponse;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksRequest;
import io.netty.example.socksproxy.SocksServerConnectHandler;
import io.netty.example.socksproxy.SocksServerUtils;

@ChannelHandler.Sharable
public final class SocksServerHandler
extends ChannelInboundMessageHandlerAdapter<SocksRequest> {
    private static final String name = "SOCKS_SERVER_HANDLER";

    public static String getName() {
        return name;
    }

    public SocksServerHandler() {
        super(new Class[]{SocksRequest.class});
    }

    public void messageReceived(ChannelHandlerContext ctx, SocksRequest socksRequest) throws Exception {
        switch (socksRequest.getSocksRequestType()) {
            case INIT: {
                ctx.pipeline().addFirst(SocksCmdRequestDecoder.getName(), (ChannelHandler)new SocksCmdRequestDecoder());
                ctx.write((Object)new SocksInitResponse(SocksMessage.AuthScheme.NO_AUTH));
                break;
            }
            case AUTH: {
                ctx.pipeline().addFirst(SocksCmdRequestDecoder.getName(), (ChannelHandler)new SocksCmdRequestDecoder());
                ctx.write((Object)new SocksAuthResponse(SocksMessage.AuthStatus.SUCCESS));
                break;
            }
            case CMD: {
                SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                if (req.getCmdType() == SocksMessage.CmdType.CONNECT) {
                    ctx.pipeline().addLast(SocksServerConnectHandler.getName(), (ChannelHandler)new SocksServerConnectHandler());
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.nextInboundMessageBuffer().add((Object)socksRequest);
                    ctx.fireInboundBufferUpdated();
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) throws Exception {
        throwable.printStackTrace();
        SocksServerUtils.closeOnFlush(ctx.channel());
    }
}

