/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpUploadServerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger logger = Logger.getLogger(HttpUploadServerHandler.class.getName());
    private HttpRequest request;
    private boolean readingChunks;
    private final StringBuilder responseContent = new StringBuilder();
    private static final HttpDataFactory factory = new DefaultHttpDataFactory(16384L);
    private HttpPostRequestDecoder decoder;

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.decoder != null) {
            this.decoder.cleanFiles();
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.request = (HttpRequest)msg;
            HttpRequest request = this.request;
            URI uri = new URI(request.getUri());
            if (!uri.getPath().startsWith("/form")) {
                this.writeMenu(ctx);
                return;
            }
            this.responseContent.setLength(0);
            this.responseContent.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.responseContent.append("===================================\r\n");
            this.responseContent.append("VERSION: " + request.getProtocolVersion().text() + "\r\n");
            this.responseContent.append("REQUEST_URI: " + request.getUri() + "\r\n\r\n");
            this.responseContent.append("\r\n\r\n");
            List headers = request.headers().entries();
            for (Map.Entry entry : headers) {
                this.responseContent.append("HEADER: " + (String)entry.getKey() + '=' + (String)entry.getValue() + "\r\n");
            }
            this.responseContent.append("\r\n\r\n");
            String value = request.headers().get("Cookie");
            Set cookies = value == null ? Collections.emptySet() : CookieDecoder.decode((String)value);
            for (Cookie cookie : cookies) {
                this.responseContent.append("COOKIE: " + cookie.toString() + "\r\n");
            }
            this.responseContent.append("\r\n\r\n");
            QueryStringDecoder decoderQuery = new QueryStringDecoder(request.getUri());
            Map uriAttributes = decoderQuery.parameters();
            for (Map.Entry attr : uriAttributes.entrySet()) {
                for (String attrVal : (List)attr.getValue()) {
                    this.responseContent.append("URI: " + (String)attr.getKey() + '=' + attrVal + "\r\n");
                }
            }
            this.responseContent.append("\r\n\r\n");
            try {
                this.decoder = new HttpPostRequestDecoder(factory, request);
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                e1.printStackTrace();
                this.responseContent.append(e1.getMessage());
                this.writeResponse(ctx.channel());
                ctx.channel().close();
                return;
            }
            catch (HttpPostRequestDecoder.IncompatibleDataDecoderException e1) {
                this.responseContent.append(e1.getMessage());
                this.responseContent.append("\r\n\r\nEND OF GET CONTENT\r\n");
                this.writeResponse(ctx.channel());
                return;
            }
            this.readingChunks = HttpHeaders.isTransferEncodingChunked((HttpMessage)request);
            this.responseContent.append("Is Chunked: " + this.readingChunks + "\r\n");
            this.responseContent.append("IsMultipart: " + this.decoder.isMultipart() + "\r\n");
            if (this.readingChunks) {
                this.responseContent.append("Chunks: ");
                this.readingChunks = true;
            }
        }
        if (this.decoder != null && msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            try {
                this.decoder.offer(chunk);
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                e1.printStackTrace();
                this.responseContent.append(e1.getMessage());
                this.writeResponse(ctx.channel());
                ctx.channel().close();
                return;
            }
            this.responseContent.append('o');
            this.readHttpDataChunkByChunk();
            if (chunk instanceof LastHttpContent) {
                this.writeResponse(ctx.channel());
                this.readingChunks = false;
                this.reset();
            }
        }
    }

    private void reset() {
        this.request = null;
        this.decoder.destroy();
        this.decoder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHttpDataChunkByChunk() {
        try {
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (data == null) continue;
                try {
                    this.writeHttpData(data);
                }
                finally {
                    data.release();
                }
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException e1) {
            this.responseContent.append("\r\n\r\nEND OF CONTENT CHUNK BY CHUNK\r\n\r\n");
        }
    }

    private void writeHttpData(InterfaceHttpData data) {
        if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.Attribute) {
            String value;
            Attribute attribute = (Attribute)data;
            try {
                value = attribute.getValue();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.getName() + " Error while reading value: " + e1.getMessage() + "\r\n");
                return;
            }
            if (value.length() > 100) {
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.getName() + " data too long\r\n");
            } else {
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.toString() + "\r\n");
            }
        } else {
            this.responseContent.append("\r\nBODY FileUpload: " + data.getHttpDataType().name() + ": " + data.toString() + "\r\n");
            if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                FileUpload fileUpload = (FileUpload)data;
                if (fileUpload.isCompleted()) {
                    if (fileUpload.length() < 10000L) {
                        this.responseContent.append("\tContent of file\r\n");
                        try {
                            this.responseContent.append(fileUpload.getString(fileUpload.getCharset()));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        this.responseContent.append("\r\n");
                    } else {
                        this.responseContent.append("\tFile too long to be printed out:" + fileUpload.length() + "\r\n");
                    }
                } else {
                    this.responseContent.append("\tFile to be continued but should not!\r\n");
                }
            }
        }
    }

    private void writeResponse(Channel channel) {
        String value;
        Set cookies;
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)this.responseContent.toString(), (Charset)CharsetUtil.UTF_8);
        this.responseContent.setLength(0);
        boolean close = "close".equalsIgnoreCase(this.request.headers().get("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.headers().get("Connection"));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf);
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        if (!close) {
            response.headers().set("Content-Length", (Object)buf.readableBytes());
        }
        if (!(cookies = (value = this.request.headers().get("Cookie")) == null ? Collections.emptySet() : CookieDecoder.decode((String)value)).isEmpty()) {
            for (Cookie cookie : cookies) {
                response.headers().add("Set-Cookie", (Object)ServerCookieEncoder.encode((Cookie)cookie));
            }
        }
        ChannelFuture future = channel.writeAndFlush((Object)response);
        if (close) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void writeMenu(ChannelHandlerContext ctx) {
        this.responseContent.setLength(0);
        this.responseContent.append("<html>");
        this.responseContent.append("<head>");
        this.responseContent.append("<title>Netty Test Form</title>\r\n");
        this.responseContent.append("</head>\r\n");
        this.responseContent.append("<body bgcolor=white><style>td{font-size: 12pt;}</style>");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr>");
        this.responseContent.append("<td>");
        this.responseContent.append("<h1>Netty Test Form</h1>");
        this.responseContent.append("Choose one FORM");
        this.responseContent.append("</td>");
        this.responseContent.append("</tr>");
        this.responseContent.append("</table>\r\n");
        this.responseContent.append("<CENTER>GET FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formget\" METHOD=\"GET\">");
        this.responseContent.append("<input type=hidden name=getform value=\"GET\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<CENTER>POST FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formpost\" METHOD=\"POST\">");
        this.responseContent.append("<input type=hidden name=getform value=\"POST\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("<tr><td>Fill with file (only file name will be transmitted): <br> <input type=file name=\"myfile\">");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<CENTER>POST MULTIPART FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formpostmultipart\" ENCTYPE=\"multipart/form-data\" METHOD=\"POST\">");
        this.responseContent.append("<input type=hidden name=getform value=\"POST\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("<tr><td>Fill with file: <br> <input type=file name=\"myfile\">");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("</body>");
        this.responseContent.append("</html>");
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)this.responseContent.toString(), (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf);
        response.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        response.headers().set("Content-Length", (Object)buf.readableBytes());
        ctx.channel().writeAndFlush((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, this.responseContent.toString(), cause);
        ctx.channel().close();
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
    }
}

