/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.objectecho;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.example.objectecho.ObjectEchoClient;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;

public class ObjectEchoClientHandler
extends ChannelInboundHandlerAdapter {
    private final List<Integer> firstMessage = new ArrayList<Integer>(ObjectEchoClient.SIZE);

    public ObjectEchoClientHandler() {
        for (int i = 0; i < ObjectEchoClient.SIZE; ++i) {
            this.firstMessage.add(i);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ChannelFuture future = ctx.writeAndFlush(this.firstMessage);
        future.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ctx.write(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

