/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http.upload.HttpUploadClientHandler;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;

public class HttpUploadClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;

    public HttpUploadClientInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("handler", (ChannelHandler)new HttpUploadClientHandler());
    }
}

