/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.mqtt.heartBeat;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.mqtt.heartBeat.MqttHeartBeatClientHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public final class MqttHeartBeatClient {
    private static final String HOST = System.getProperty("host", "127.0.0.1");
    private static final int PORT = Integer.parseInt(System.getProperty("port", "1883"));
    private static final String CLIENT_ID = System.getProperty("clientId", "guestClient");
    private static final String USER_NAME = System.getProperty("userName", "guest");
    private static final String PASSWORD = System.getProperty("password", "guest");

    private MqttHeartBeatClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)workerGroup);
            b.channel(NioSocketChannel.class);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE);
                    ch.pipeline().addLast("decoder", (ChannelHandler)new MqttDecoder());
                    ch.pipeline().addLast("heartBeatHandler", (ChannelHandler)new IdleStateHandler(0L, 20L, 0L, TimeUnit.SECONDS));
                    ch.pipeline().addLast("handler", (ChannelHandler)new MqttHeartBeatClientHandler(CLIENT_ID, USER_NAME, PASSWORD));
                }
            });
            ChannelFuture f = b.connect(HOST, PORT).sync();
            System.out.println("Client connected");
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
        }
    }
}

