/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Selector;

final class SelectorUtil {
    private static final InternalLogger logger;

    static void select(Selector selector) throws IOException {
        block2: {
            try {
                selector.select(10L);
            }
            catch (CancelledKeyException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector - JDK bug?", (Throwable)e);
            }
        }
    }

    static void cleanupKeys(Selector selector) {
        try {
            selector.selectNow();
        }
        catch (Throwable t) {
            logger.warn("Failed to update SelectionKeys.", t);
        }
    }

    private SelectorUtil() {
    }

    static {
        block3: {
            logger = InternalLoggerFactory.getInstance(SelectorUtil.class);
            String key = "sun.nio.ch.bugLevel";
            try {
                String buglevel = System.getProperty(key);
                if (buglevel == null) {
                    System.setProperty(key, "");
                }
            }
            catch (SecurityException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Unable to get/set System Property '" + key + "'", (Throwable)e);
            }
        }
    }
}

