/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;

public enum OutputFormat {
    JSON(new JSONWriter()),
    YAML(new YAMLWriter());

    private final SwaggerWriter writer;

    private OutputFormat(SwaggerWriter writer) {
        this.writer = writer;
    }

    public void write(OpenAPI swagger, File file) throws IOException {
        this.writer.write(swagger, file);
    }

    static class YAMLWriter
    implements SwaggerWriter {
        YAMLWriter() {
        }

        @Override
        public void write(OpenAPI swagger, File file) throws IOException {
            Yaml.mapper().writeValue(file, (Object)swagger);
        }
    }

    static class JSONWriter
    implements SwaggerWriter {
        JSONWriter() {
        }

        @Override
        public void write(OpenAPI swagger, File file) throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.writeValue(file, (Object)swagger);
        }
    }

    @FunctionalInterface
    static interface SwaggerWriter {
        public void write(OpenAPI var1, File var2) throws IOException;
    }
}

