/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http;

import com.google.common.base.Preconditions;
import io.opencensus.contrib.http.AbstractHttpHandler;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.propagation.TextFormat;
import javax.annotation.Nullable;

class HttpClientHandler<Q, P, C>
extends AbstractHttpHandler<Q, P> {
    private final TextFormat.Setter<C> setter;
    private final TextFormat textFormat;
    private final Tracer tracer;

    public HttpClientHandler(Tracer tracer, HttpExtractor<Q, P> extractor, TextFormat textFormat, TextFormat.Setter<C> setter) {
        super(extractor);
        Preconditions.checkNotNull(setter, (Object)"setter");
        Preconditions.checkNotNull((Object)textFormat, (Object)"textFormat");
        Preconditions.checkNotNull((Object)tracer, (Object)"tracer");
        this.setter = setter;
        this.textFormat = textFormat;
        this.tracer = tracer;
    }

    public Span handleStart(@Nullable Span parent, C carrier, Q request) {
        SpanContext spanContext;
        String spanName;
        SpanBuilder builder;
        Span span;
        Preconditions.checkNotNull(carrier, (Object)"carrier");
        Preconditions.checkNotNull(request, (Object)"request");
        if (parent == null) {
            parent = this.tracer.getCurrentSpan();
        }
        if ((span = (builder = this.tracer.spanBuilderWithExplicitParent(spanName = this.getSpanName(request, this.extractor), parent)).startSpan()).getOptions().contains(Span.Options.RECORD_EVENTS)) {
            this.addSpanRequestAttributes(span, request, this.extractor);
        }
        if (!(spanContext = span.getContext()).equals((Object)SpanContext.INVALID)) {
            this.textFormat.inject(spanContext, carrier, this.setter);
        }
        return span;
    }

    public void handleEnd(Span span, @Nullable P response, @Nullable Throwable error) {
        this.spanEnd(span, response, error);
    }
}

