/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class ServiceFingerprint {
    private static volatile File fingerPrintFile;
    private static Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasServiceBeenApplied(File installDir, File workarea) {
        boolean result = true;
        fingerPrintFile = new File(workarea, "platform/service.fingerprint");
        if (fingerPrintFile.exists()) {
            props = new Properties();
            FileReader reader = null;
            try {
                reader = new FileReader(fingerPrintFile);
                props.load(reader);
                MessageDigest digest = null;
                byte[] buffer = new byte[4096];
                boolean doClean = false;
                boolean foundCore = false;
                for (Map.Entry<Object, Object> entries : props.entrySet()) {
                    String entryName = entries.getKey().toString();
                    if (entryName.indexOf(File.separatorChar) != -1) {
                        File file = new File(entryName);
                        if (file.exists()) {
                            long len = file.length();
                            if (len <= 256L) {
                                String content = ServiceFingerprint.readBytes(file, (int)len);
                                if (!content.equals(entries.getValue())) {
                                    doClean = true;
                                }
                            } else {
                                if (digest == null) {
                                    digest = MessageDigest.getInstance("SHA-256");
                                }
                                if (!ServiceFingerprint.calculateFileHash(digest, buffer, file).equals(entries.getValue())) {
                                    doClean = true;
                                }
                            }
                        } else if (!"".equals(entries.getValue())) {
                            doClean = true;
                        }
                    } else if ("core".equals(entryName)) {
                        if (!installDir.getCanonicalPath().equals(entries.getValue())) {
                            doClean = true;
                        }
                        foundCore = true;
                    }
                    if (!doClean) continue;
                    break;
                }
                result = doClean || !foundCore;
            }
            catch (IOException iOException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public static void clear() {
        props.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calculateFileHash(MessageDigest digest, byte[] buffer, File file) throws IOException {
        FileInputStream fIn = null;
        StringBuilder builder = new StringBuilder();
        try {
            byte[] digestBytes;
            int len;
            fIn = new FileInputStream(file);
            while ((len = fIn.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            for (byte b : digestBytes = digest.digest()) {
                builder.append(ServiceFingerprint.toHexString(b));
            }
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return builder.toString();
    }

    private static String toHexString(byte b) {
        String hex = Integer.toHexString(b);
        if (hex.length() == 0) {
            hex = "00";
        } else if (hex.length() == 1) {
            hex = "0" + hex;
        } else if (hex.length() > 2) {
            int len = hex.length();
            hex = hex.substring(len - 2);
        }
        return hex;
    }

    private static void internalPut(File file) {
        try {
            String hash = "";
            if (file.exists()) {
                long len = file.length();
                if (len <= 256L) {
                    hash = ServiceFingerprint.readBytes(file, (int)len);
                } else {
                    MessageDigest digest = MessageDigest.getInstance("SHA-256");
                    byte[] buffer = new byte[4096];
                    hash = ServiceFingerprint.calculateFileHash(digest, buffer, file);
                }
            }
            props.setProperty(file.getCanonicalPath(), hash);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readBytes(File file, int bytesToRead) throws IOException {
        FileInputStream fIn = null;
        StringBuilder builder = new StringBuilder();
        try {
            int len;
            fIn = new FileInputStream(file);
            byte[] buffer = new byte[bytesToRead];
            int offset = 0;
            while (bytesToRead > 0 && (len = fIn.read(buffer, offset, bytesToRead)) != -1) {
                offset += len;
                bytesToRead -= len;
            }
            for (byte b : buffer) {
                builder.append(ServiceFingerprint.toHexString(b));
            }
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return builder.toString();
    }

    public static void put(File file) {
        ServiceFingerprint.internalPut(file);
        ServiceFingerprint.flush();
    }

    private static void flush() {
        if (fingerPrintFile != null) {
            OutputStreamWriter writer = null;
            try {
                File fingerPrintParent = fingerPrintFile.getParentFile();
                if (fingerPrintParent != null && !fingerPrintParent.exists() && !fingerPrintParent.mkdirs()) {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.fingerprintUnableToMkDirs"), fingerPrintParent.getAbsolutePath(), fingerPrintFile.getAbsolutePath()));
                }
                writer = new FileWriter(fingerPrintFile);
                props.store(writer, null);
            }
            catch (IOException iOException) {
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void putInstallDir(String name, File installDir) {
        if (name == null) {
            name = "core";
        }
        ServiceFingerprint.internalPut(new File(installDir, "lib/versions/service.fingerprint"));
        try {
            props.setProperty(name, installDir.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ServiceFingerprint.flush();
    }

    static {
        props = new Properties();
    }
}

