/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import java.io.File;
import java.io.IOException;

public class FileDataCache<T> {
    private long fileLastModified = 0L;
    private long fileSize = 0L;
    private T cachedData;
    private final File file;
    private final Object lock;

    public FileDataCache(File file, Object lock) {
        this.file = file;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(FileSupplier<T> dataSupplier) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.file == null || !this.file.canRead()) {
                return dataSupplier.get();
            }
            if (this.cachedData == null || this.file.lastModified() != this.fileLastModified || this.file.length() != this.fileSize) {
                this.cachedData = null;
                this.fileLastModified = this.file.lastModified();
                this.fileSize = this.file.length();
                this.cachedData = dataSupplier.get();
            }
            return this.cachedData;
        }
    }

    @FunctionalInterface
    public static interface FileSupplier<T> {
        public T get() throws IOException;
    }
}

