/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ArtifactDownloaderUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.MavenRepository;
import com.ibm.ws.install.internal.ProgressBar;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ArtifactDownloader
implements AutoCloseable {
    private final int PROGRESS_CHUNK = 500000;
    private final int BUFFER_SIZE = 10000;
    private final String appName = "artifactDownloader";
    private final String appVersion = "1.0.0";
    private final List<File> downloadedFiles = Collections.synchronizedList(new ArrayList());
    private static final Logger logger = InstallLogUtils.getInstallLogger();
    private final ProgressBar progressBar = ProgressBar.getInstance();
    private static Map<String, Object> envMap = null;
    private final ExecutorService executor = Executors.newFixedThreadPool(ArtifactDownloaderUtils.getNumThreads());
    private Map<String, File> mavenCoordMap = new Hashtable<String, File>();

    ArtifactDownloader() {
    }

    private Future<String> submitDownloadRequest(String coords, String fileType, String dLocation, MavenRepository repository) {
        return this.executor.submit(() -> {
            this.synthesizeAndDownload(coords, fileType, dLocation, repository, false);
            return coords + "." + fileType;
        });
    }

    public Set<String> getMissingFeaturesFromRepo(List<String> mavenCoords, List<String> userFeatures, MavenRepository repository, InstallConstants.VerifyOption verifyOption, boolean downloadSignaturesOnly) throws InstallException {
        List<String> missingFeaturesURLs;
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CONTACTING_MAVEN_REPO", new Object[0]));
        String repo = this.FormatUrlSuffix(repository.getRepositoryUrl());
        HashMap<String, String> URLtoMavenCoordMap = new HashMap<String, String>();
        ArtifactDownloaderUtils.acquireFeatureURLs(mavenCoords, repo, URLtoMavenCoordMap, verifyOption, downloadSignaturesOnly);
        HashSet<String> missingCoords = new HashSet<String>();
        if (!this.testConnection(repository)) {
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_CONNECT_MAVEN", new Object[0]);
        }
        this.updateProgress(this.progressBar.getMethodIncrement("establishConnection"));
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_MAVEN_REPO_CONNECTION_SUCCESSFUL", new Object[0]));
        try {
            missingFeaturesURLs = ArtifactDownloaderUtils.getMissingFiles(URLtoMavenCoordMap.keySet(), envMap, repository);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InstallException(e.getMessage());
        }
        if (!missingFeaturesURLs.isEmpty()) {
            ArrayList<String> missingFeatureList = new ArrayList<String>();
            for (String f : missingFeaturesURLs) {
                String featureName = ArtifactDownloaderUtils.getFileNameFromURL(f);
                String featureCoord = (String)URLtoMavenCoordMap.get(f);
                missingFeatureList.add(featureName);
                if (userFeatures.contains(featureCoord)) {
                    if (verifyOption != InstallConstants.VerifyOption.all) continue;
                }
                missingCoords.add(featureCoord);
            }
            this.fine("The remote repository \"" + repo.toString() + "\" is missing the following artifacts: " + ((Object)missingFeatureList).toString());
        }
        return missingCoords;
    }

    public void synthesizeAndDownloadFeatures(List<String> mavenCoords, List<String> usrFeatures, String dLocation, MavenRepository repository, InstallConstants.VerifyOption verifyOption, boolean downloadSignaturesOnly) throws InstallException {
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        double individualSize = 0.0;
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_BEGINNING_DOWNLOAD_FEATURES", new Object[0]));
        for (String coord : mavenCoords) {
            List<String> fileExtensions = this.getFileExt(coord, usrFeatures, verifyOption, downloadSignaturesOnly);
            for (String fileExt : fileExtensions) {
                Future<String> future = this.submitDownloadRequest(coord, fileExt, dLocation, repository);
                futures.add(future);
            }
        }
        individualSize = this.progressBar.getMethodIncrement("downloadArtifacts") / (double)futures.size();
        while (!futures.isEmpty()) {
            Iterator iter = futures.iterator();
            try {
                while (iter.hasNext()) {
                    Future future = (Future)iter.next();
                    if (!future.isDone()) continue;
                    String downloadedCoords = (String)future.get();
                    this.updateProgress(individualSize);
                    this.fine("Finished downloading artifact: " + downloadedCoords);
                    iter.remove();
                }
                this.fine("Remaining artifacts: " + futures.size());
                Thread.sleep(300L);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new InstallException(e.getMessage());
            }
        }
        this.progressBar.manuallyUpdate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getFileExt(String mavenCoord, List<String> usrFeatures, InstallConstants.VerifyOption verifyOption, boolean downloadSignaturesOnly) {
        if (downloadSignaturesOnly) {
            return Arrays.asList("esa.asc", "pom.asc");
        }
        if (verifyOption == null || verifyOption == InstallConstants.VerifyOption.skip) {
            return Arrays.asList("esa", "pom");
        }
        if (!usrFeatures.contains(mavenCoord)) return Arrays.asList("esa", "pom", "esa.asc", "pom.asc");
        if (verifyOption == InstallConstants.VerifyOption.all) return Arrays.asList("esa", "pom", "esa.asc", "pom.asc");
        return Arrays.asList("esa", "pom");
    }

    private String FormatPathSuffix(String path) {
        String result = path;
        if (!path.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    private String FormatUrlSuffix(String url) {
        String result = url;
        if (!url.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public void synthesizeAndDownload(String mavenCoords, String filetype, String dLocation, MavenRepository repository, boolean individualDownload) throws InstallException {
        String[] checksumFormats = new String[]{"MD5", "SHA1", "SHA256"};
        dLocation = this.FormatPathSuffix(dLocation);
        String repo = this.FormatUrlSuffix(repository.getRepositoryUrl());
        String urlLocation = ArtifactDownloaderUtils.getUrlLocation(repo, mavenCoords) + "." + filetype;
        try {
            if (individualDownload) {
                if (!this.testConnection(repository)) {
                    throw ExceptionUtils.createByKey("ERROR_FAILED_TO_CONNECT_MAVEN", new Object[0]);
                }
                if (ArtifactDownloaderUtils.fileIsMissing(urlLocation, envMap, repository)) {
                    throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", ArtifactDownloaderUtils.getfilename(mavenCoords), filetype + " file", repository.toString());
                }
            }
            this.download(mavenCoords, filetype, urlLocation, dLocation, checksumFormats, repository);
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private void download(String mavenCoords, String filetype, String urlLocation, String dLocation, String[] checksumFormats, MavenRepository mavenRepository) throws IOException, InstallException {
        try {
            URI uriLoc = new URI(urlLocation);
            File fileLoc = new File(urlLocation.replace(mavenRepository.toString(), dLocation));
            String filename = ArtifactDownloaderUtils.getFileNameFromURL(urlLocation);
            this.downloadInternal(uriLoc, fileLoc, mavenRepository);
            this.downloadedFiles.add(fileLoc);
            if (filetype.equals("esa")) {
                this.mavenCoordMap.put(mavenCoords, fileLoc);
            }
            boolean someChecksumExists = false;
            boolean checksumFail = false;
            boolean checksumSuccess = false;
            ConcurrentHashMap<String, String> checkSumCache = new ConcurrentHashMap<String, String>();
            for (String checksumFormat : checksumFormats) {
                if (checksumSuccess) continue;
                if (this.checksumIsAvailable(urlLocation, checksumFormat, checkSumCache)) {
                    someChecksumExists = true;
                    if (this.isIncorrectChecksum(fileLoc.getAbsolutePath(), urlLocation, checksumFormat, checkSumCache)) {
                        this.fine("Failed to validate " + checksumFormat + " checksum for file: " + filename);
                        checksumFail = true;
                        continue;
                    }
                    checksumSuccess = true;
                    this.fine("Successfully validated " + checksumFormat + " checksum for file: " + filename);
                    continue;
                }
                this.fine("Failed to find " + checksumFormat + " checksum for file: " + filename);
            }
            if (someChecksumExists) {
                if (checksumFail) {
                    ArtifactDownloaderUtils.deleteFiles(this.downloadedFiles, dLocation, fileLoc);
                    this.downloadedFiles.clear();
                    this.mavenCoordMap.clear();
                    throw ExceptionUtils.createByKey("ERROR_CHECKSUM_FAILED_MAVEN", filename);
                }
            } else {
                this.fine("No checksums found for file in remote repository");
            }
        }
        catch (URISyntaxException e) {
            throw new InstallException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private boolean checksumIsAvailable(String urlLocation, String checksumFormat, ConcurrentHashMap<String, String> checkSumCache) {
        boolean result = true;
        try {
            if (checkSumCache.containsKey(checksumFormat)) {
                return true;
            }
            String checkSum = ArtifactDownloaderUtils.getPrimaryChecksum(urlLocation, checksumFormat);
            checkSumCache.put(checksumFormat, checkSum);
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    private boolean isIncorrectChecksum(String localFile, String urlLocation, String checksumFormat, ConcurrentHashMap<String, String> checkSumCache) throws NoSuchAlgorithmException {
        String checksumLocal;
        boolean result = false;
        try {
            checksumLocal = ArtifactDownloaderUtils.getChecksum(localFile, checksumFormat);
        }
        catch (IOException e) {
            return true;
        }
        String checksumOrigin = checkSumCache.get(checksumFormat);
        if (checksumOrigin == null || !checksumLocal.equals(checksumOrigin)) {
            result = true;
        }
        return result;
    }

    protected boolean testConnection(MavenRepository repository) {
        try {
            ArtifactDownloaderUtils.verifyPassword(repository.getPassword());
            int responseCode = ArtifactDownloaderUtils.exists(repository.getRepositoryUrl(), envMap, repository);
            logger.fine("Response code - " + repository.getRepositoryUrl() + ":" + responseCode);
            return ArtifactDownloaderUtils.checkResponseCode(responseCode);
        }
        catch (InstallException | IOException e) {
            logger.warning(repository.getRepositoryUrl() + " cannot be connected");
            logger.fine(e.getMessage());
            return false;
        }
    }

    private void downloadInternal(URI address, File destination, MavenRepository repository) throws IOException, InstallException {
        URL url = address.toURL();
        if (System.getProperty("featureUtility.beta") != null && System.getProperty("featureUtility.beta").equals("true")) {
            logger.fine("non Proxy Hosts: " + System.getProperty("http.nonProxyHosts"));
        }
        logger.fine("downloadInternal url host: " + url.getHost());
        String proxyEncodedAuth = "";
        if (url.getProtocol().equals("https") && envMap.get("https.proxyHost") != null) {
            proxyEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication((String)envMap.get("https.proxyUser"), (String)envMap.get("https.proxyPassword"));
        } else if (envMap.get("http.proxyHost") != null) {
            proxyEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication((String)envMap.get("http.proxyUser"), (String)envMap.get("http.proxyPassword"));
        }
        URLConnection conn = url.openConnection();
        String userAgentValue = this.calculateUserAgent();
        String repoEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication(repository.getUserId(), repository.getPassword());
        conn.setRequestProperty("User-Agent", userAgentValue);
        if (!repoEncodedAuth.isEmpty()) {
            conn.setRequestProperty("Authorization", repoEncodedAuth);
        }
        if (!proxyEncodedAuth.isEmpty()) {
            conn.setRequestProperty("Proxy-Authorization", proxyEncodedAuth);
        }
        conn.connect();
        destination.getParentFile().mkdirs();
        File tempFile = File.createTempFile(destination.getName(), null, destination.getParentFile());
        try (InputStream in = conn.getInputStream();
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int numRead;
            byte[] buffer = new byte[10000];
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if ((progressCounter += (long)numRead) / 500000L > 0L) {
                    progressCounter -= 500000L;
                }
                ((OutputStream)out).write(buffer, 0, numRead);
            }
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_FEATURE", ArtifactDownloaderUtils.getFileNameFromURL(address.toString()), destination.toString());
        }
        if (destination.exists() || !tempFile.renameTo(destination)) {
            logger.fine("Could not rename " + tempFile.getName() + " to: " + destination.getName());
            tempFile.delete();
        }
    }

    private String calculateUserAgent() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", "artifactDownloader", "1.0.0", osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    public List<File> getDownloadedEsas(List<String> featureList) {
        ArrayList<File> esaFiles = new ArrayList<File>();
        for (String coord : featureList) {
            File artifactPath = this.mavenCoordMap.get(coord);
            if (artifactPath == null) continue;
            esaFiles.add(artifactPath);
        }
        return esaFiles;
    }

    public List<File> getDownloadedAscs() {
        return this.downloadedFiles.stream().filter(item -> item.getName().toLowerCase().endsWith(".asc")).collect(Collectors.toList());
    }

    public List<File> getDownloadedPoms() {
        ArrayList<File> pomFiles = new ArrayList<File>();
        for (File f : this.downloadedFiles) {
            if (!f.getName().endsWith(".pom")) continue;
            pomFiles.add(f);
        }
        return pomFiles;
    }

    public List<File> getDownloadedFiles() {
        return this.downloadedFiles;
    }

    private void updateProgress(double increment) {
        this.progressBar.updateProgress(increment);
    }

    public void setEnvMap(Map<String, Object> envMap) {
        ArtifactDownloader.envMap = envMap;
    }

    public Map<String, Object> getEnvMap() {
        return envMap;
    }

    private void info(String msg) {
        logger.info(msg);
    }

    private void fine(String msg) {
        logger.fine(msg);
    }

    private void severe(String msg) {
        logger.severe(msg);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private static class SystemPropertiesProxyHttpAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyHttpAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication((String)envMap.get("http.proxyUser"), PasswordUtil.passwordDecode((String)((String)envMap.get("http.proxyPassword"))).toCharArray());
        }
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication((String)envMap.get("https.proxyUser"), PasswordUtil.passwordDecode((String)((String)envMap.get("https.proxyPassword"))).toCharArray());
        }
    }
}

