/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int TIGER = 3;
    public static final int SHA256 = 4;
    public static final int MD2 = 5;
    public static final int GOST3411 = 6;
    public static final int SHA224 = 7;
    public static final int SHA384 = 8;
    public static final int SHA512 = 9;
    public static final int SHA3_224 = 10;
    public static final int SHA3_256 = 11;
    public static final int SHA3_384 = 12;
    public static final int SHA3_512 = 13;
    public static final int SM3 = 14;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;
    public static final int PKCS5S1_UTF8 = 4;
    public static final int PKCS5S2_UTF8 = 5;

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int n, int n2) {
            PKCS5S1ParametersGenerator pKCS5S1ParametersGenerator;
            block35: {
                block37: {
                    block36: {
                        block34: {
                            if (n != 0 && n != 4) break block34;
                            switch (n2) {
                                case 5: {
                                    pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator((Digest)new MD2Digest());
                                    break block35;
                                }
                                case 0: {
                                    pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createMD5());
                                    break block35;
                                }
                                case 1: {
                                    pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createSHA1());
                                    break block35;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (n != 1 && n != 5) break block36;
                        switch (n2) {
                            case 5: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator((Digest)new MD2Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 0: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createMD5PRF());
                                break block35;
                            }
                            case 1: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA1PRF());
                                break block35;
                            }
                            case 2: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator((Digest)new RIPEMD160Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 3: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator((Digest)new TigerDigest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 4: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA256PRF());
                                break block35;
                            }
                            case 6: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator((Digest)new GOST3411Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            case 7: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA224PRF());
                                break block35;
                            }
                            case 8: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA384PRF());
                                break block35;
                            }
                            case 9: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA512PRF());
                                break block35;
                            }
                            case 10: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_224PRF());
                                break block35;
                            }
                            case 11: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_256PRF());
                                break block35;
                            }
                            case 12: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_384PRF());
                                break block35;
                            }
                            case 13: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_512PRF());
                                break block35;
                            }
                            case 14: {
                                pKCS5S1ParametersGenerator = new PKCS5S2ParametersGenerator((Digest)new SM3Digest(CryptoServicePurpose.PRF));
                                break block35;
                            }
                            default: {
                                throw new IllegalStateException("unknown digest scheme for PBE PKCS5S2 encryption.");
                            }
                        }
                    }
                    if (n != 2) break block37;
                    switch (n2) {
                        case 5: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator((Digest)new MD2Digest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 0: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createMD5PRF());
                            break block35;
                        }
                        case 1: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA1PRF());
                            break block35;
                        }
                        case 2: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator((Digest)new RIPEMD160Digest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 3: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator((Digest)new TigerDigest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 4: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA256PRF());
                            break block35;
                        }
                        case 6: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator((Digest)new GOST3411Digest(CryptoServicePurpose.PRF));
                            break block35;
                        }
                        case 7: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA224PRF());
                            break block35;
                        }
                        case 8: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA384PRF());
                            break block35;
                        }
                        case 9: {
                            pKCS5S1ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA512PRF());
                            break block35;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                pKCS5S1ParametersGenerator = new OpenSSLPBEParametersGenerator();
            }
            return pKCS5S1ParametersGenerator;
        }

        public static CipherParameters makePBEParameters(byte[] byArray, int n, int n2, int n3, int n4, AlgorithmParameterSpec algorithmParameterSpec, String string) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray2 = byArray;
            pBEParametersGenerator.init(byArray2, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = n4 != 0 ? pBEParametersGenerator.generateDerivedParameters(n3, n4) : pBEParametersGenerator.generateDerivedParameters(n3);
            if (string.startsWith("DES")) {
                if (cipherParameters instanceof ParametersWithIV) {
                    KeyParameter keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity((byte[])keyParameter.getKey());
                } else {
                    KeyParameter keyParameter = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity((byte[])keyParameter.getKey());
                }
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEParameters(BCPBEKey bCPBEKey, AlgorithmParameterSpec algorithmParameterSpec, String string) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), bCPBEKey.getDigest());
            byte[] byArray = bCPBEKey.getEncoded();
            if (bCPBEKey.shouldTryWrongPKCS12()) {
                byArray = new byte[2];
            }
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = bCPBEKey.getIvSize() != 0 ? pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize(), bCPBEKey.getIvSize()) : pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize());
            if (string.startsWith("DES")) {
                if (cipherParameters instanceof ParametersWithIV) {
                    KeyParameter keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity((byte[])keyParameter.getKey());
                } else {
                    KeyParameter keyParameter = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity((byte[])keyParameter.getKey());
                }
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(BCPBEKey bCPBEKey, AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), bCPBEKey.getDigest());
            byte[] byArray = bCPBEKey.getEncoded();
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(bCPBEKey.getKeySize());
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(PBEKeySpec pBEKeySpec, int n, int n2, int n3) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray = Util.convertPassword(n, pBEKeySpec);
            pBEParametersGenerator.init(byArray, pBEKeySpec.getSalt(), pBEKeySpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(n3);
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEParameters(PBEKeySpec pBEKeySpec, int n, int n2, int n3, int n4) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray = Util.convertPassword(n, pBEKeySpec);
            pBEParametersGenerator.init(byArray, pBEKeySpec.getSalt(), pBEKeySpec.getIterationCount());
            CipherParameters cipherParameters = n4 != 0 ? pBEParametersGenerator.generateDerivedParameters(n3, n4) : pBEParametersGenerator.generateDerivedParameters(n3);
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(SecretKey secretKey, int n, int n2, int n3, PBEParameterSpec pBEParameterSpec) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray = secretKey.getEncoded();
            pBEParametersGenerator.init(secretKey.getEncoded(), pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(n3);
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            return cipherParameters;
        }

        private static byte[] convertPassword(int n, PBEKeySpec pBEKeySpec) {
            byte[] byArray = n == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(pBEKeySpec.getPassword()) : (n == 5 || n == 4 ? PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(pBEKeySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(pBEKeySpec.getPassword()));
            return byArray;
        }
    }
}

