/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline;
import com.ibm.ws.kernel.feature.internal.FeatureResolverResultImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureResolverImpl
implements FeatureResolver {
    private static final Object tc;
    private static Map<String, String[]> parsedNAV;
    public static final String PREFERRED_PLATFORM_VERSIONS_ENV_VAR = "PREFERRED_PLATFORM_VERSIONS";
    private static String preferredPlatformVersions;
    private static HashMap<String, ProvisioningFeatureDefinition> allCompatibilityFeatures;
    static Map<String, String> linkingFeatureBaseNameToCompatibility;
    static final long serialVersionUID = 8036412349350895560L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    protected static void trace(String message) {
        if (tc != null && TraceComponent.isAnyTracingEnabled() && ((TraceComponent)tc).isDebugEnabled()) {
            Tr.debug((TraceComponent)((TraceComponent)tc), (String)message, (Object[])new Object[0]);
        }
    }

    @Trivial
    protected static void error(String message, Object ... parms) {
        if (tc != null) {
            Tr.error((TraceComponent)((TraceComponent)tc), (String)message, (Object[])parms);
        }
    }

    @Trivial
    protected static void info(String message, Object ... parms) {
        if (tc != null) {
            Tr.info((TraceComponent)((TraceComponent)tc), (String)message, (Object[])parms);
        }
    }

    protected static StringBuilder append(StringBuilder builder, String value) {
        if (builder != null) {
            builder.append(',');
        } else {
            builder = new StringBuilder(1 + value.length() + 1);
        }
        builder.append('\"');
        builder.append(value);
        builder.append('\"');
        return builder;
    }

    public static String parseName(String feature) {
        return FeatureResolverImpl.parseNameAndVersion(feature)[0];
    }

    public static String parseVersion(String feature) {
        return FeatureResolverImpl.parseNameAndVersion(feature)[1];
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static String[] parseNameAndVersion(String feature) {
        String[] result = parsedNAV.get(feature);
        if (result != null) {
            return result;
        }
        String baseName = feature;
        String version = null;
        int lastDash = feature.lastIndexOf(45);
        if (lastDash >= 0) {
            version = feature.substring(lastDash + 1);
            try {
                Version.parseVersion((String)version);
                baseName = feature.substring(0, lastDash);
            }
            catch (IllegalArgumentException e) {
                version = null;
            }
        }
        result = new String[]{baseName, version};
        parsedNAV.put(feature, result);
        return result;
    }

    public static void setPreferredPlatforms(String preferredPlatformVersions) {
        FeatureResolverImpl.preferredPlatformVersions = preferredPlatformVersions;
    }

    private Collection<String> collectConfiguredPlatforms(FeatureResolver.Repository repo, Collection<String> rootPlatforms, SelectionContext selectionContext) {
        if (rootPlatforms == null) {
            return null;
        }
        ArrayList<String> compatibilityFeatures = new ArrayList<String>();
        HashMap duplicates = new HashMap();
        for (String string : rootPlatforms) {
            String string2 = string.trim();
            ProvisioningFeatureDefinition platformFeature = allCompatibilityFeatures.get(string2.toLowerCase());
            if (platformFeature == null) {
                selectionContext.getResult().addMissingPlatform(string2);
                continue;
            }
            String parsedPlatformName = FeatureResolverImpl.parseName(platformFeature.getSymbolicName());
            if (duplicates.containsKey(parsedPlatformName)) {
                ((Set)duplicates.get(parsedPlatformName)).add(string2);
                continue;
            }
            if (this.featureListContainsFeatureBaseName(compatibilityFeatures, parsedPlatformName)) {
                HashSet<String> dupes = new HashSet<String>();
                dupes.add(string2);
                String removeDuplicate = "";
                for (String compatibility : compatibilityFeatures) {
                    if (!compatibility.startsWith(parsedPlatformName)) continue;
                    removeDuplicate = compatibility;
                    break;
                }
                compatibilityFeatures.remove(removeDuplicate);
                dupes.add(repo.getFeature(removeDuplicate).getPlatformName());
                duplicates.put(parsedPlatformName, dupes);
                continue;
            }
            compatibilityFeatures.add(platformFeature.getSymbolicName());
        }
        for (Map.Entry entry : duplicates.entrySet()) {
            selectionContext.getResult().addDuplicatePlatforms((String)entry.getKey(), (Set)entry.getValue());
        }
        return compatibilityFeatures;
    }

    private List<String> collectEnvironmentPlatforms(FeatureResolver.Repository repo, Collection<String> rootPlatforms, SelectionContext selectionContext) {
        if (preferredPlatformVersions == null) {
            return Collections.emptyList();
        }
        Set<String> allPlatformBaseNames = selectionContext.compatibilityFeaturesBaseNames();
        if (allPlatformBaseNames.size() == rootPlatforms.size()) {
            return Collections.emptyList();
        }
        String[] preferredPlatforms = preferredPlatformVersions.split(",");
        ArrayList<String> compatibilityFeatures = new ArrayList<String>();
        for (String plat : preferredPlatforms) {
            ProvisioningFeatureDefinition platformFeature = allCompatibilityFeatures.get((plat = plat.trim()).toLowerCase());
            if (platformFeature != null) {
                String baseName = FeatureResolverImpl.parseName(platformFeature.getSymbolicName());
                if (this.featureListContainsFeatureBaseName(rootPlatforms, baseName)) continue;
                compatibilityFeatures.add(platformFeature.getSymbolicName());
                continue;
            }
            selectionContext.getResult().addMissingPlatform(plat);
        }
        return compatibilityFeatures;
    }

    private List<String> collectFeaturePlatforms(FeatureResolver.Repository repo, Collection<String> rootPlatforms, Collection<String> rootFeatures, SelectionContext selectionContext) {
        HashMap map = new HashMap();
        for (String feature : rootFeatures) {
            List<String> wlpPlatform;
            ProvisioningFeatureDefinition rootFeatureDef = repo.getFeature(feature);
            if (rootFeatureDef == null || (wlpPlatform = rootFeatureDef.getPlatformNames()) == null || wlpPlatform.size() <= 0) continue;
            String[] nav = FeatureResolverImpl.parseNameAndVersion(wlpPlatform.get(0));
            String compatibilityFeature = selectionContext.getCompatibilityBaseName(nav[0]);
            ArrayList<String> featuresPlatforms = new ArrayList<String>();
            for (String platform : wlpPlatform) {
                ProvisioningFeatureDefinition featureDef = allCompatibilityFeatures.get(platform.toLowerCase());
                if (featureDef == null) continue;
                featuresPlatforms.add(featureDef.getSymbolicName());
            }
            if (map.containsKey(compatibilityFeature)) {
                ((Set)map.get(compatibilityFeature)).retainAll(featuresPlatforms);
                continue;
            }
            map.put(compatibilityFeature, new HashSet(featuresPlatforms));
        }
        ArrayList<String> featurePlatforms = new ArrayList<String>();
        for (String key : map.keySet()) {
            Set current;
            if (this.featureListContainsFeatureBaseName(rootPlatforms, key) || (current = (Set)map.get(key)).size() != 1) continue;
            String compatibilitySymbolicName = current.toArray()[0].toString();
            featurePlatforms.add(compatibilitySymbolicName);
        }
        return featurePlatforms;
    }

    private boolean featureListContainsFeatureBaseName(Collection<String> featureList, String containsFeature) {
        for (String feature : featureList) {
            if (!feature.startsWith(containsFeature)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions) {
        return this.resolve(repository, Collections.emptySet(), rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), null);
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), null);
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, supportedProcessTypes, null);
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, Set<String> allowedMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowedMultipleVersions, supportedProcessTypes, null);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, Collection<String> rootPlatforms) {
        return this.resolve(repository, Collections.emptySet(), rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), rootPlatforms);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, Collection<String> rootPlatforms) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), rootPlatforms);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, EnumSet<ProcessType> supportedProcessTypes, Collection<String> rootPlatforms) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, supportedProcessTypes, rootPlatforms);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, Set<String> allowedMultiple, EnumSet<ProcessType> supportedProcessTypes, Collection<String> rootPlatforms) {
        FeatureResolverBaseline.generate(this, repository, allowedMultiple, kernelFeatures);
        return this.doResolve(repository, kernelFeatures, rootFeatures, preResolved, allowedMultiple, supportedProcessTypes, rootPlatforms);
    }

    public FeatureResolver.Result doResolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, Set<String> allowedMultipleVersions, EnumSet<ProcessType> supportedProcessTypes, Collection<String> rootPlatforms) {
        SelectionContext selectionContext = new SelectionContext(repository, allowedMultipleVersions, supportedProcessTypes);
        if (this.hasRootVersionlessFeatures(repository, rootFeatures)) {
            selectionContext.setHasVersionlessFeatures();
            this.processCompatibilityFeatures(repository.getFeatures());
            rootPlatforms = this.collectConfiguredPlatforms(repository, rootPlatforms, selectionContext);
            rootPlatforms.addAll(this.collectEnvironmentPlatforms(repository, rootPlatforms, selectionContext));
            rootPlatforms.addAll(this.collectFeaturePlatforms(repository, rootPlatforms, rootFeatures, selectionContext));
            for (String platform : rootPlatforms) {
                selectionContext.getResult().addResolvedPlatform(repository.getFeature(platform).getPlatformName());
            }
        }
        preResolved = this.checkPreResolvedExistAndSetFullName(preResolved, selectionContext);
        rootFeatures = this.checkRootsAreAccessibleAndSetFullName(new ArrayList<String>(rootFeatures), selectionContext, preResolved, rootPlatforms);
        Collection<String> rootFeaturesList = new ArrayList<String>(rootFeatures);
        if (rootPlatforms != null && selectionContext.getHasVersionlessFeatures()) {
            rootFeaturesList.addAll(rootPlatforms);
        }
        ArrayList<String> filteredVersionless = new ArrayList();
        if (allowedMultipleVersions != null && selectionContext.getHasVersionlessFeatures()) {
            filteredVersionless = this.filterVersionless(rootFeaturesList, selectionContext);
        } else if (selectionContext.getHasVersionlessFeatures()) {
            this.preresolveVersionless(rootFeaturesList, selectionContext, rootPlatforms, filteredVersionless);
        }
        selectionContext.primeSelected(preResolved);
        selectionContext.primeSelected(rootFeaturesList);
        Set<String> autoFeaturesToInstall = Collections.emptySet();
        HashSet<String> seenAutoFeatures = new HashSet<String>();
        Set<String> resolved = Collections.emptySet();
        do {
            if (autoFeaturesToInstall.isEmpty()) continue;
            rootFeaturesList = autoFeaturesToInstall;
            selectionContext.primeSelected(autoFeaturesToInstall);
            preResolved = resolved;
            selectionContext.saveCurrentPreResolvedConflicts();
        } while (!(autoFeaturesToInstall = this.processAutoFeatures(kernelFeatures, resolved = this.doResolveFeatures(rootFeaturesList, preResolved, selectionContext), seenAutoFeatures, selectionContext)).isEmpty());
        if (!filteredVersionless.isEmpty() && allowedMultipleVersions != null) {
            this.addBackVersionless(filteredVersionless, selectionContext);
        } else if (selectionContext.getHasVersionlessFeatures()) {
            this.finalizeVersionlessResults(selectionContext, filteredVersionless);
        }
        return selectionContext.getResult();
    }

    private boolean hasRootVersionlessFeatures(FeatureResolver.Repository repo, Collection<String> featureList) {
        for (String s : featureList) {
            ProvisioningFeatureDefinition feature = repo.getFeature(s);
            if (feature == null || !feature.isVersionless()) continue;
            return true;
        }
        return false;
    }

    private List<String> checkRootsAreAccessibleAndSetFullName(List<String> rootFeatures, SelectionContext selectionContext, Set<String> preResolved, Collection<String> rootPlatforms) {
        ListIterator<String> iRootFeatures = rootFeatures.listIterator();
        while (iRootFeatures.hasNext()) {
            String rootFeatureName = iRootFeatures.next();
            ProvisioningFeatureDefinition rootFeatureDef = selectionContext.getRepository().getFeature(rootFeatureName);
            if (rootFeatureDef == null) {
                selectionContext.getResult().addMissingRoot(rootFeatureName);
                iRootFeatures.remove();
                continue;
            }
            String symbolicName = rootFeatureDef.getSymbolicName();
            if (rootFeatureDef.getVisibility() != Visibility.PUBLIC) {
                selectionContext.getResult().addNonPublicRoot(rootFeatureName);
                iRootFeatures.remove();
                continue;
            }
            if (!FeatureResolverImpl.supportedProcessType(selectionContext._supportedProcessTypes, rootFeatureDef)) {
                selectionContext.getResult().addWrongRootFeatureType(symbolicName);
                iRootFeatures.remove();
                continue;
            }
            if (preResolved.contains(symbolicName)) {
                iRootFeatures.remove();
                continue;
            }
            iRootFeatures.set(symbolicName);
        }
        return rootFeatures;
    }

    private List<String> getCompatibilityCandidates(String baseName, Collection<String> rootPlatforms) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String plat : rootPlatforms) {
            if (!plat.startsWith(baseName)) continue;
            candidates.add(plat);
        }
        return candidates;
    }

    private void preresolveVersionless(Collection<String> rootFeatures, SelectionContext selectionContext, Collection<String> rootPlatforms, List<String> filteredVersionless) {
        HashSet<String> addedRootFeatures = new HashSet<String>();
        HashSet<String> removedVersionlessFeatures = new HashSet<String>();
        HashSet<String> multiplePlatforms = new HashSet<String>();
        HashMap noPlatformFeatures = new HashMap();
        HashSet<String> usedPlatforms = new HashSet<String>();
        for (String string : rootPlatforms) {
            String baseCompatibilityName = FeatureResolverImpl.parseName(string);
            if (usedPlatforms.contains(baseCompatibilityName)) {
                multiplePlatforms.add(baseCompatibilityName);
            }
            usedPlatforms.add(baseCompatibilityName);
        }
        for (String string : multiplePlatforms) {
            List<String> candidates = this.getCompatibilityCandidates(string, rootPlatforms);
            rootFeatures.removeAll(candidates);
            rootPlatforms.removeAll(candidates);
            selectionContext.compatibilityFeaturesToPostpone.put(string, new FeatureResolver.Chain(candidates, FeatureResolverImpl.parseVersion(candidates.get(0)), candidates.get(0)));
        }
        for (String string : rootFeatures) {
            ProvisioningFeatureDefinition rootFeatureDef = selectionContext.getRepository().getFeature(string);
            if (!rootFeatureDef.isVersionless()) continue;
            Collection<FeatureResource> versionlessDeps = rootFeatureDef.getConstituents(SubsystemContentType.FEATURE_TYPE);
            ArrayList<String> versionlessLinkingFeatures = new ArrayList<String>();
            for (FeatureResource privateVersionless : versionlessDeps) {
                String[] nav = FeatureResolverImpl.parseNameAndVersion(privateVersionless.getSymbolicName());
                versionlessLinkingFeatures.add(nav[0] + "-" + nav[1]);
                if (privateVersionless.getTolerates() == null) continue;
                for (String string2 : privateVersionless.getTolerates()) {
                    versionlessLinkingFeatures.add(nav[0] + "-" + string2);
                }
            }
            boolean addFeature = false;
            boolean hasMultiplePlatforms = false;
            String compatibilityBase = null;
            String linkingFeatureBase = null;
            block5: for (String linkingFeature : versionlessLinkingFeatures) {
                ProvisioningFeatureDefinition linkingDef = selectionContext.getRepository().getFeature(linkingFeature);
                if (linkingDef == null) continue;
                linkingFeatureBase = FeatureResolverImpl.parseName(linkingDef.getSymbolicName());
                Collection<FeatureResource> featureDeps = linkingDef.getConstituents(SubsystemContentType.FEATURE_TYPE);
                block6: for (FeatureResource featureDep : featureDeps) {
                    ProvisioningFeatureDefinition versionedFeature = selectionContext.getRepository().getFeature(featureDep.getSymbolicName());
                    if (versionedFeature == null || versionedFeature.getVisibility() != Visibility.PUBLIC || versionedFeature.getPlatformName() == null) continue;
                    compatibilityBase = selectionContext.getCompatibilityBaseName(FeatureResolverImpl.parseName(versionedFeature.getPlatformName()));
                    if (multiplePlatforms.contains(compatibilityBase)) {
                        hasMultiplePlatforms = true;
                        continue block5;
                    }
                    for (String platform : versionedFeature.getPlatformNames()) {
                        ProvisioningFeatureDefinition featureDef = allCompatibilityFeatures.get(platform.toLowerCase());
                        if (featureDef == null || !rootPlatforms.contains(featureDef.getSymbolicName())) continue;
                        addFeature = true;
                        filteredVersionless.add(linkingDef.getFeatureName());
                        if (rootFeatures.contains(versionedFeature.getSymbolicName())) continue block6;
                        addedRootFeatures.add(versionedFeature.getSymbolicName());
                        continue block6;
                    }
                }
            }
            if (!addFeature && !usedPlatforms.contains(compatibilityBase)) {
                if (noPlatformFeatures.containsKey(compatibilityBase)) {
                    ((Set)noPlatformFeatures.get(compatibilityBase)).add(rootFeatureDef.getFeatureName());
                } else {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add(rootFeatureDef.getFeatureName());
                    noPlatformFeatures.put(compatibilityBase, hashSet);
                }
            }
            if (!hasMultiplePlatforms) {
                filteredVersionless.add(rootFeatureDef.getFeatureName());
                removedVersionlessFeatures.add(rootFeatureDef.getSymbolicName());
                continue;
            }
            linkingFeatureBaseNameToCompatibility.put(linkingFeatureBase, compatibilityBase);
        }
        for (Map.Entry entry : noPlatformFeatures.entrySet()) {
            selectionContext.getResult().addNoPlatformVersionless((String)entry.getKey(), (Set)entry.getValue());
        }
        rootFeatures.addAll(addedRootFeatures);
        rootFeatures.removeAll(removedVersionlessFeatures);
    }

    private static boolean isLinkingFeature(String basename) {
        return linkingFeatureBaseNameToCompatibility.keySet().contains(basename);
    }

    private static String getLinkingFeaturesCompatibility(String basename) {
        return linkingFeatureBaseNameToCompatibility.get(basename);
    }

    private List<String> filterVersionless(Collection<String> rootFeatures, SelectionContext selectionContext) {
        ArrayList<String> versionless = new ArrayList<String>();
        for (String feature : rootFeatures) {
            ProvisioningFeatureDefinition featureDef = selectionContext.getRepository().getFeature(feature);
            if (!featureDef.isVersionless()) continue;
            versionless.add(feature);
        }
        rootFeatures.removeAll(versionless);
        return versionless;
    }

    private void addBackVersionless(List<String> versionlessFeatures, SelectionContext selectionContext) {
        FeatureResolverResultImpl result = selectionContext.getResult();
        HashSet<String> addingFeatures = new HashSet<String>();
        for (String versionlessFeature : versionlessFeatures) {
            ProvisioningFeatureDefinition versionlessDef = selectionContext.getRepository().getFeature(versionlessFeature);
            Collection<FeatureResource> versionlessDeps = versionlessDef.getConstituents(SubsystemContentType.FEATURE_TYPE);
            ArrayList<String> features = new ArrayList<String>();
            for (FeatureResource privateVersionless : versionlessDeps) {
                String[] nav = FeatureResolverImpl.parseNameAndVersion(privateVersionless.getSymbolicName());
                features.add(nav[0] + "-" + nav[1]);
                if (privateVersionless.getTolerates() == null) continue;
                for (String version : privateVersionless.getTolerates()) {
                    features.add(nav[0] + "-" + version);
                }
            }
            for (String feature : features) {
                ProvisioningFeatureDefinition featureDef = selectionContext.getRepository().getFeature(feature);
                if (featureDef == null) continue;
                boolean addFeature = false;
                HeaderElementDefinition compatibleFeature = null;
                Collection<FeatureResource> featureDeps = featureDef.getConstituents(SubsystemContentType.FEATURE_TYPE);
                for (FeatureResource featureDep : featureDeps) {
                    ProvisioningFeatureDefinition versionedFeature = selectionContext.getRepository().getFeature(featureDep.getSymbolicName());
                    if (versionedFeature == null) continue;
                    if (versionedFeature.isCompatibility()) {
                        compatibleFeature = featureDep;
                    }
                    if (versionedFeature.getIbmShortName() == null || !result._resolved.contains(versionedFeature.getIbmShortName())) continue;
                    addFeature = true;
                }
                if (!addFeature) continue;
                addingFeatures.add(feature);
                if (compatibleFeature == null) continue;
                String[] nav = FeatureResolverImpl.parseNameAndVersion(compatibleFeature.getSymbolicName());
                String compatibleFeatureName = compatibleFeature.getSymbolicName();
                if (this.shouldAddCompatibleFeature(result, compatibleFeatureName, selectionContext)) {
                    addingFeatures.add(compatibleFeatureName);
                }
                if (compatibleFeature.getTolerates() == null) continue;
                for (String version : compatibleFeature.getTolerates()) {
                    compatibleFeatureName = nav[0] + "-" + version;
                    if (!this.shouldAddCompatibleFeature(result, compatibleFeatureName, selectionContext)) continue;
                    addingFeatures.add(compatibleFeatureName);
                }
            }
            addingFeatures.add(versionlessFeature);
        }
        result._resolved.addAll(addingFeatures);
    }

    private boolean shouldAddCompatibleFeature(FeatureResolverResultImpl result, String featureName, SelectionContext selectionContext) {
        ProvisioningFeatureDefinition feature = selectionContext.getRepository().getFeature(featureName);
        if (feature == null) {
            return false;
        }
        Collection<FeatureResource> featureDeps = feature.getConstituents(SubsystemContentType.FEATURE_TYPE);
        for (FeatureResource featureDep : featureDeps) {
            ProvisioningFeatureDefinition versionedFeature = selectionContext.getRepository().getFeature(featureDep.getSymbolicName());
            if (versionedFeature == null || !result.getResolvedFeatures().contains(versionedFeature.getFeatureName())) continue;
            return true;
        }
        return false;
    }

    private void finalizeVersionlessResults(SelectionContext selectionContext, List<String> filteredVersionless) {
        FeatureResolverResultImpl result = selectionContext.getResult();
        result._resolved.addAll(filteredVersionless);
        HashSet existingPlatforms = new HashSet();
        existingPlatforms.addAll(result.getResolvedPlatforms());
        result.emptyResolvedPlatforms();
        for (String feature : result.getResolvedFeatures()) {
            ProvisioningFeatureDefinition featureDef = selectionContext.getRepository().getFeature(feature);
            if (!featureDef.isCompatibility() || !existingPlatforms.contains(featureDef.getPlatformName())) continue;
            result.addResolvedPlatform(featureDef.getPlatformName());
        }
        for (String versionless : filteredVersionless) {
            boolean added = false;
            ProvisioningFeatureDefinition versionlessFD = selectionContext.getRepository().getFeature(versionless);
            if (!versionlessFD.isVersionless()) continue;
            String linkingBaseName = "";
            for (FeatureResource dependency : versionlessFD.getConstituents(null)) {
                linkingBaseName = FeatureResolverImpl.parseName(dependency.getSymbolicName());
            }
            for (String linking : filteredVersionless) {
                if (!linkingBaseName.equals(FeatureResolverImpl.parseName(linking))) continue;
                for (FeatureResource versionedFeature : selectionContext.getRepository().getFeature(linking).getConstituents(null)) {
                    ProvisioningFeatureDefinition versionedFeatureDef = selectionContext.getRepository().getFeature(versionedFeature.getSymbolicName());
                    if (versionedFeatureDef.getVisibility() != Visibility.PUBLIC) continue;
                    result.addVersionlessFeature(versionless, versionedFeatureDef.getFeatureName());
                    added = true;
                }
            }
            if (added) continue;
            result.addVersionlessFeature(versionless, null);
        }
        ArrayList<String> unresolvedVersionless = new ArrayList<String>();
        for (Map.Entry entry : ((HashMap)result.getVersionlessFeatures()).entrySet()) {
            if (entry.getValue() == null) {
                unresolvedVersionless.add((String)entry.getKey());
                continue;
            }
            if (result._resolved.contains(entry.getValue()) || result._resolved.contains(selectionContext.getRepository().getFeature((String)entry.getValue()).getFeatureName())) continue;
            unresolvedVersionless.add((String)entry.getKey());
        }
        for (String unresolved : unresolvedVersionless) {
            result.addVersionlessFeature(unresolved, null);
        }
    }

    private void processCompatibilityFeatures(List<ProvisioningFeatureDefinition> features) {
        allCompatibilityFeatures = new HashMap();
        for (ProvisioningFeatureDefinition feature : features) {
            if (!feature.isCompatibility()) continue;
            allCompatibilityFeatures.put(feature.getPlatformName().toLowerCase(), feature);
        }
    }

    static final boolean supportedProcessType(EnumSet<ProcessType> supportedTypes, ProvisioningFeatureDefinition fd) {
        for (ProcessType processType : fd.getProcessTypes()) {
            if (!supportedTypes.contains((Object)processType)) continue;
            return true;
        }
        return false;
    }

    private Set<String> checkPreResolvedExistAndSetFullName(Set<String> preResolved, SelectionContext selectionContext) {
        LinkedHashSet<String> preResolvedSymbolicNames = new LinkedHashSet<String>(preResolved.size());
        for (String preResolvedFeatureName : preResolved) {
            ProvisioningFeatureDefinition preResolvedDef = selectionContext.getRepository().getFeature(preResolvedFeatureName);
            if (preResolvedDef == null) {
                return Collections.emptySet();
            }
            preResolvedSymbolicNames.add(preResolvedDef.getSymbolicName());
        }
        return preResolvedSymbolicNames;
    }

    private Set<String> doResolveFeatures(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        selectionContext.resetInitialBlockedCount();
        Set<String> result = this.processCurrentPermutation(rootFeatures, preResolved, selectionContext);
        if (selectionContext.getResult().getConflicts().isEmpty()) {
            selectionContext.selectCurrentPermutation();
            return result;
        }
        while (selectionContext.currentHasMoreThanInitialBlockedCount() && selectionContext.popPermutation()) {
            result = this.processCurrentPermutation(rootFeatures, preResolved, selectionContext);
        }
        selectionContext.restoreBestSolution();
        Set<String> resolvedFeatures = selectionContext.getResult().getResolvedFeatures();
        return new LinkedHashSet<String>(resolvedFeatures);
    }

    Set<String> processCurrentPermutation(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        Set<String> result;
        int numBlocked;
        do {
            selectionContext.processPostponed();
            numBlocked = selectionContext.getBlockedCount();
            result = this.processRoots(rootFeatures, preResolved, selectionContext);
        } while (selectionContext.hasPostponed() || numBlocked != selectionContext.getBlockedCount() || selectionContext.hasTriedVersionlessResolution());
        if (selectionContext.hasPostponedVersionless()) {
            selectionContext.addVersionlessConflicts();
        }
        ((SelectionContext)selectionContext)._current._result.setResolvedFeatures(result);
        selectionContext.checkForBestSolution();
        return result;
    }

    private Set<String> processRoots(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        ArrayDeque<String> chain = new ArrayDeque<String>();
        LinkedHashSet<String> result = new LinkedHashSet<String>(preResolved.size());
        for (String key : selectionContext.compatibilityFeaturesToPostpone.keySet()) {
            if (selectionContext.getSelected(key) != null || ((SelectionContext)selectionContext)._current._postponed.containsKey(key)) continue;
            FeatureResolver.Chain compatibilityChain = selectionContext.compatibilityFeaturesToPostpone.get(key);
            selectionContext.processCandidates(compatibilityChain.getChain(), compatibilityChain.getCandidates(), compatibilityChain.getFeatureRequirement(), key, compatibilityChain.getPreferredVersion().toString(), true);
        }
        for (String featureSymbolicName : preResolved) {
            ProvisioningFeatureDefinition featureDef = selectionContext._repository.getFeature(featureSymbolicName);
            result.add(featureDef.getFeatureName());
        }
        for (String rootFeatureName : rootFeatures) {
            ProvisioningFeatureDefinition rootFeatureDef = selectionContext.getRepository().getFeature(rootFeatureName);
            if (rootFeatureDef == null) {
                selectionContext.getResult().addMissingReference(rootFeatureName);
                continue;
            }
            this.processSelected(rootFeatureDef, null, chain, result, selectionContext);
        }
        selectionContext.setInitialRootBlockedCount();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSelected(ProvisioningFeatureDefinition selectedFeature, Set<String> allowedTolerations, Deque<String> chain, Set<String> result, SelectionContext selectionContext) {
        if (selectedFeature == null) {
            return;
        }
        String featureName = selectedFeature.getSymbolicName();
        String baseFeatureName = FeatureResolverImpl.parseNameAndVersion(featureName)[0];
        if (selectionContext.isBlocked(baseFeatureName)) {
            return;
        }
        if (selectedFeature.isSingleton() && !selectionContext.allowMultipleVersions(baseFeatureName)) {
            String selectedFeatureName;
            FeatureResolver.Chain existingSelection = selectionContext.getSelected(baseFeatureName);
            String string = selectedFeatureName = existingSelection == null ? null : existingSelection.getCandidates().get(0);
            if (existingSelection == null || !featureName.equals(selectedFeatureName)) {
                throw new IllegalStateException("Expected feature \"" + featureName + "\" to be selected instead feature of \"" + selectedFeatureName);
            }
        }
        if (chain.contains(featureName)) {
            return;
        }
        chain.addLast(featureName);
        try {
            Collection<FeatureResource> includes = selectedFeature.getConstituents(SubsystemContentType.FEATURE_TYPE);
            boolean isRoot = chain.size() == 1;
            HashSet<String> includedBaseFeatureNames = new HashSet<String>();
            for (FeatureResource included : includes) {
                String symbolicName = included.getSymbolicName();
                if (symbolicName == null) continue;
                String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(included.getSymbolicName());
                String baseName = nameAndVersion[0];
                includedBaseFeatureNames.add(baseName);
            }
            if (allowedTolerations == null) {
                if (!isRoot) {
                    throw new IllegalStateException("A null allowTolerations is only valid for root features.");
                }
            } else {
                includedBaseFeatureNames.retainAll(allowedTolerations);
            }
            allowedTolerations = includedBaseFeatureNames;
            for (FeatureResource included : includes) {
                this.processIncluded(selectedFeature, included, allowedTolerations, chain, result, selectionContext);
            }
        }
        finally {
            chain.removeLast();
            String name = selectedFeature.getFeatureName();
            result.add(name);
        }
    }

    private void processIncluded(ProvisioningFeatureDefinition includingFeature, FeatureResource included, Set<String> allowedTolerations, Deque<String> chain, Set<String> result, SelectionContext selectionContext) {
        String symbolicName = included.getSymbolicName();
        if (symbolicName == null) {
            if (!chain.isEmpty()) {
                selectionContext.getResult().addUnlabelledResource(included, chain);
            }
            return;
        }
        String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(symbolicName);
        String baseSymbolicName = nameAndVersion[0];
        String preferredVersion = nameAndVersion[1];
        boolean isSingleton = false;
        if (selectionContext.isBlocked(baseSymbolicName)) {
            return;
        }
        List<String> tolerates = included.getTolerates();
        List<String> overrideTolerates = selectionContext.getRepository().getConfiguredTolerates(baseSymbolicName);
        if (!overrideTolerates.isEmpty()) {
            tolerates = tolerates == null ? new ArrayList<String>() : new ArrayList<String>(tolerates);
            tolerates.addAll(overrideTolerates);
        }
        ArrayList<String> candidateNames = new ArrayList<String>(1 + (tolerates == null ? 0 : tolerates.size()));
        ProvisioningFeatureDefinition preferredCandidateDef = selectionContext.getRepository().getFeature(symbolicName);
        if (preferredCandidateDef != null && this.isAccessible(includingFeature, preferredCandidateDef)) {
            this.checkForFullSymbolicName(preferredCandidateDef, symbolicName, chain.getLast());
            isSingleton = preferredCandidateDef.isSingleton();
            candidateNames.add(symbolicName);
        }
        if (tolerates != null && (candidateNames.isEmpty() || isSingleton)) {
            for (String tolerate : tolerates) {
                if (selectionContext.allowMultipleVersions(baseSymbolicName) && !candidateNames.isEmpty()) break;
                String toleratedSymbolicName = baseSymbolicName + '-' + tolerate;
                ProvisioningFeatureDefinition toleratedCandidateDef = selectionContext.getRepository().getFeature(toleratedSymbolicName);
                if (toleratedCandidateDef == null || candidateNames.contains(toleratedCandidateDef.getSymbolicName()) || !this.isAccessible(includingFeature, toleratedCandidateDef)) continue;
                this.checkForFullSymbolicName(toleratedCandidateDef, toleratedSymbolicName, chain.getLast());
                isSingleton |= toleratedCandidateDef.isSingleton();
                if (!this.isAllowedToleration(selectionContext, toleratedCandidateDef, allowedTolerations, overrideTolerates, baseSymbolicName, tolerate, chain)) continue;
                candidateNames.add(toleratedCandidateDef.getSymbolicName());
            }
        }
        if (!isSingleton && candidateNames.size() > 1) {
            candidateNames.retainAll(Collections.singleton((String)candidateNames.get(0)));
        }
        selectionContext.processCandidates(chain, candidateNames, symbolicName, baseSymbolicName, preferredVersion, isSingleton);
        if (candidateNames.size() == 1 && (!FeatureResolverImpl.isLinkingFeature(baseSymbolicName) || FeatureResolverImpl.isLinkingFeature(baseSymbolicName) && selectionContext.getSelected(baseSymbolicName) != null)) {
            String selectedName = (String)candidateNames.get(0);
            this.processSelected(selectionContext.getRepository().getFeature(selectedName), allowedTolerations, chain, result, selectionContext);
        }
    }

    private boolean isAccessible(ProvisioningFeatureDefinition includingFeature, ProvisioningFeatureDefinition candidateDef) {
        return !candidateDef.isVersionless() && (candidateDef.getVisibility() != Visibility.PRIVATE || includingFeature.getBundleRepositoryType().equals(candidateDef.getBundleRepositoryType()));
    }

    private boolean isAllowedToleration(SelectionContext selectionContext, ProvisioningFeatureDefinition toleratedCandidateDef, Set<String> allowedTolerations, List<String> overrideTolerates, String baseSymbolicName, String tolerate, Deque<String> chain) {
        if (selectionContext.allowMultipleVersions(baseSymbolicName)) {
            return true;
        }
        if (Visibility.PRIVATE == toleratedCandidateDef.getVisibility()) {
            return true;
        }
        if (allowedTolerations.contains(baseSymbolicName)) {
            return true;
        }
        if (overrideTolerates.contains(tolerate)) {
            return true;
        }
        return selectionContext.getRepository().getFeature(chain.peekFirst()).isVersionless();
    }

    private void checkForFullSymbolicName(ProvisioningFeatureDefinition candidateDef, String symbolicName, String includingFeature) {
        if (!symbolicName.equals(candidateDef.getSymbolicName())) {
            throw new IllegalArgumentException("A feature is not allowed to use short feature names when including other features. Detected short name \"" + symbolicName + "\" being used instead of \"" + candidateDef.getSymbolicName() + "\" by feature \"" + includingFeature + "\".");
        }
    }

    private Set<String> processAutoFeatures(Collection<ProvisioningFeatureDefinition> kernelFeatures, Set<String> result, Set<String> seenAutoFeatures, SelectionContext selectionContext) {
        HashSet<String> autoFeaturesToProcess = new HashSet<String>();
        HashSet<ProvisioningFeatureDefinition> filteredFeatureDefs = new HashSet<ProvisioningFeatureDefinition>(kernelFeatures);
        for (String feature : result) {
            filteredFeatureDefs.add(selectionContext.getRepository().getFeature(feature));
        }
        for (ProvisioningFeatureDefinition autoFeatureDef : selectionContext.getRepository().getAutoFeatures()) {
            String featureSymbolicName = autoFeatureDef.getSymbolicName();
            if (seenAutoFeatures.contains(featureSymbolicName) || !autoFeatureDef.isCapabilitySatisfied(filteredFeatureDefs)) continue;
            seenAutoFeatures.add(featureSymbolicName);
            if (!FeatureResolverImpl.supportedProcessType(selectionContext._supportedProcessTypes, autoFeatureDef)) continue;
            autoFeaturesToProcess.add(featureSymbolicName);
        }
        return autoFeaturesToProcess;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl", FeatureResolverImpl.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        TraceComponent temp = null;
        try {
            temp = Tr.register(FeatureResolverImpl.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl", (String)"79", null, (Object[])new Object[0]);
        }
        tc = temp;
        parsedNAV = new HashMap<String, String[]>();
        preferredPlatformVersions = System.getenv(PREFERRED_PLATFORM_VERSIONS_ENV_VAR);
        allCompatibilityFeatures = new HashMap();
        linkingFeatureBaseNameToCompatibility = new HashMap<String, String>();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SelectionContext {
        final Map<String, FeatureResolver.Chain> compatibilityFeaturesToPostpone = new HashMap<String, FeatureResolver.Chain>();
        private final FeatureResolver.Repository _repository;
        private final Deque<Permutation> _permutations = new ArrayDeque<Permutation>(Arrays.asList(new Permutation()));
        private final Set<String> _allowedMultipleVersions;
        private final EnumSet<ProcessType> _supportedProcessTypes;
        private final AtomicInteger _initialBlockedCount = new AtomicInteger(-1);
        private final Map<String, Collection<FeatureResolver.Chain>> _preResolveConflicts = new HashMap<String, Collection<FeatureResolver.Chain>>();
        private Permutation _current = this._permutations.getFirst();
        private boolean triedVersionless = false;
        private boolean hasVersionlessFeatures = false;
        private Map<String, String> platToCompat;
        static final long serialVersionUID = 1093055206082116067L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        void setHasVersionlessFeatures() {
            this.hasVersionlessFeatures = true;
        }

        boolean getHasVersionlessFeatures() {
            return this.hasVersionlessFeatures;
        }

        SelectionContext(FeatureResolver.Repository repository, Set<String> allowedMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
            this._repository = repository;
            this._allowedMultipleVersions = allowedMultipleVersions;
            this._supportedProcessTypes = supportedProcessTypes;
        }

        void saveCurrentPreResolvedConflicts() {
            this._preResolveConflicts.clear();
            this._preResolveConflicts.putAll(this._current._result.getConflicts());
        }

        void resetInitialBlockedCount() {
            this._initialBlockedCount.set(-1);
        }

        boolean currentHasMoreThanInitialBlockedCount() {
            return this.getBlockedCount() > this._initialBlockedCount.get();
        }

        void setInitialRootBlockedCount() {
            this._initialBlockedCount.compareAndSet(-1, this.getBlockedCount());
        }

        void restoreBestSolution() {
            while (this.popPermutation()) {
            }
            this._current = this._permutations.getFirst();
        }

        void selectCurrentPermutation() {
            this._permutations.clear();
            this._permutations.addFirst(this._current);
        }

        void checkForBestSolution() {
            if (this._permutations.getLast()._result.getConflicts().size() > this._current._result.getConflicts().size()) {
                this._permutations.pollLast();
                this._permutations.addLast(this._current);
            }
        }

        boolean popPermutation() {
            Permutation popped;
            Permutation permutation = popped = this._permutations.size() > 1 ? this._permutations.pollFirst() : null;
            if (popped != null) {
                this.triedVersionless = false;
                this._current = popped;
                return true;
            }
            return false;
        }

        @FFDCIgnore(value={DeadEndChain.class})
        void pushPermutation() {
            if (this._initialBlockedCount.get() == this.getBlockedCount()) {
                try {
                    this._permutations.addFirst(this._current.copy(this._preResolveConflicts));
                }
                catch (DeadEndChain deadEndChain) {
                    // empty catch block
                }
            }
        }

        FeatureResolver.Repository getRepository() {
            return this._repository;
        }

        boolean isBlocked(String baseSymbolicName) {
            return this._current._blockedFeatures.contains(baseSymbolicName);
        }

        boolean allowMultipleVersions(String baseSymbolicName) {
            return this._allowedMultipleVersions != null && (this._allowedMultipleVersions.size() == 0 || this._allowedMultipleVersions.contains(baseSymbolicName));
        }

        int getBlockedCount() {
            return this._current._blockedFeatures.size();
        }

        FeatureResolverResultImpl getResult() {
            return this._current._result;
        }

        Set<String> compatibilityFeaturesBaseNames() {
            Collection values = allCompatibilityFeatures.values();
            HashSet<String> baseNames = new HashSet<String>();
            for (ProvisioningFeatureDefinition value : values) {
                baseNames.add(FeatureResolverImpl.parseNameAndVersion(value.getSymbolicName())[0]);
            }
            return baseNames;
        }

        Map<String, String> platformToCompatibilityBaseName() {
            if (this.platToCompat == null) {
                Set keys = allCompatibilityFeatures.keySet();
                HashMap<String, String> usePlatToCompat = new HashMap<String, String>();
                for (String key : keys) {
                    String baseKey = FeatureResolverImpl.parseName(key);
                    if (usePlatToCompat.containsKey(baseKey)) continue;
                    usePlatToCompat.put(baseKey, FeatureResolverImpl.parseName(((ProvisioningFeatureDefinition)allCompatibilityFeatures.get(key)).getSymbolicName()));
                }
                this.platToCompat = usePlatToCompat;
            }
            return this.platToCompat;
        }

        String getCompatibilityBaseName(String plat) {
            Map<String, String> baseNames = this.platformToCompatibilityBaseName();
            return baseNames == null ? null : baseNames.get(plat.toLowerCase());
        }

        void processCandidates(Collection<String> chain, List<String> candidateNames, String symbolicName, String baseSymbolicName, String preferredVersion, boolean isSingleton) {
            FeatureResolver.Chain conflict;
            if (FeatureResolverImpl.isLinkingFeature(baseSymbolicName) && this.getSelected(FeatureResolverImpl.getLinkingFeaturesCompatibility(baseSymbolicName)) == null) {
                this.addPostponed(baseSymbolicName, new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName));
                return;
            }
            ArrayList<String> origCandidateNames = new ArrayList<String>(candidateNames);
            Iterator<String> iCandidateNames = candidateNames.iterator();
            while (iCandidateNames.hasNext()) {
                ProvisioningFeatureDefinition fd = this._repository.getFeature(iCandidateNames.next());
                if (FeatureResolverImpl.supportedProcessType(this._supportedProcessTypes, fd)) continue;
                FeatureResolver.Chain c = new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName);
                this._current._result.addWrongResolvedFeatureType(symbolicName, c);
                iCandidateNames.remove();
            }
            if (candidateNames.isEmpty()) {
                this._current._result.addIncomplete(symbolicName, origCandidateNames, chain);
                return;
            }
            if (!isSingleton || this.allowMultipleVersions(baseSymbolicName)) {
                return;
            }
            ArrayList<String> copyCandidates = new ArrayList<String>(candidateNames);
            FeatureResolver.Chain selectedChain = this.getSelected(baseSymbolicName);
            if (selectedChain != null) {
                candidateNames.retainAll(selectedChain.getCandidates());
                if (candidateNames.isEmpty()) {
                    this.addConflict(baseSymbolicName, this.asList(selectedChain, new FeatureResolver.Chain(chain, copyCandidates, preferredVersion, symbolicName)));
                    return;
                }
            }
            if (candidateNames.size() > 1) {
                this.addPostponed(baseSymbolicName, new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName));
                return;
            }
            String selectedName = candidateNames.get(0);
            if (FeatureResolverImpl.isLinkingFeature(baseSymbolicName)) {
                for (FeatureResource versionedFeature : this._repository.getFeature(selectedName).getConstituents(null)) {
                    ProvisioningFeatureDefinition versionedFeatureDef = this._repository.getFeature(versionedFeature.getSymbolicName());
                    if (versionedFeatureDef.getVisibility() != Visibility.PUBLIC) continue;
                    this.getResult().addVersionlessFeature(chain.toArray()[0].toString(), versionedFeature.getSymbolicName());
                }
            }
            if ((conflict = this.getPostponedConflict(baseSymbolicName, selectedName)) != null) {
                this.addConflict(baseSymbolicName, this.asList(conflict, new FeatureResolver.Chain(chain, copyCandidates, preferredVersion, symbolicName)));
            }
            if (selectedChain == null) {
                this._current._selected.put(baseSymbolicName, new FeatureResolver.Chain(chain, Collections.singletonList(selectedName), preferredVersion, symbolicName));
            }
            this._current._postponed.remove(baseSymbolicName);
        }

        List<FeatureResolver.Chain> asList(FeatureResolver.Chain chain1, FeatureResolver.Chain chain2) {
            ArrayList<FeatureResolver.Chain> result = new ArrayList<FeatureResolver.Chain>(2);
            result.add(chain1);
            result.add(chain2);
            return result;
        }

        FeatureResolver.Chain getSelected(String baseName) {
            return this._current._selected.get(baseName);
        }

        boolean hasPostponed() {
            return !this._current._postponed.isEmpty();
        }

        boolean hasPostponedVersionless() {
            return !this._current._postponedVersionless.isEmpty();
        }

        void addVersionlessConflicts() {
            for (String s : this._current._postponedVersionless.keySet()) {
                this._current._result.addVersionlessFeature(this._current._postponedVersionless.get(s).getChains().get(0).getChain().get(0), null);
            }
        }

        boolean hasTriedVersionlessResolution() {
            if (!this.triedVersionless) {
                this.triedVersionless = true;
                return !this._current._postponedVersionless.isEmpty();
            }
            return false;
        }

        boolean hasAtLeastOneSelected(Set<String> baseNames) {
            for (String feature : baseNames) {
                if (this.getSelected(feature) == null) continue;
                return true;
            }
            return false;
        }

        void processPostponed() {
            if (this._current._postponed.isEmpty() && this._current._postponedVersionless.isEmpty()) {
                return;
            }
            if (!this._current._postponedVersionless.isEmpty() && this.hasAtLeastOneSelected(this.compatibilityFeaturesBaseNames())) {
                Set<String> entries = this._current._postponedVersionless.keySet();
                Iterator<Map.Entry<String, Chains>> postponedVersionlessIterator = this._current._postponedVersionless.entrySet().iterator();
                Map.Entry<String, Chains> firstPostponedVersionless = null;
                while (postponedVersionlessIterator.hasNext() && this.getSelected(FeatureResolverImpl.getLinkingFeaturesCompatibility((firstPostponedVersionless = postponedVersionlessIterator.next()).getKey())) == null) {
                    firstPostponedVersionless = null;
                }
                if (firstPostponedVersionless != null) {
                    FeatureResolver.Chain selected = firstPostponedVersionless.getValue().select(firstPostponedVersionless.getKey(), this);
                    if (selected != null) {
                        this._current._selected.put(firstPostponedVersionless.getKey(), selected);
                    }
                    this._current._postponed.clear();
                    this._current._postponedVersionless.clear();
                    return;
                }
            }
            if (!this._current._postponed.isEmpty()) {
                Map.Entry<String, Chains> firstPostponed = this._current._postponed.entrySet().iterator().next();
                FeatureResolver.Chain selected = null;
                String postponedBaseName = firstPostponed.getKey();
                if (this.hasVersionlessFeatures && !this._current._postponedFeaturesTried.contains(postponedBaseName)) {
                    this._current._postponedFeaturesTried.add(postponedBaseName);
                    selected = firstPostponed.getValue().selectTryFirst(postponedBaseName, this);
                } else {
                    selected = firstPostponed.getValue().select(postponedBaseName, this);
                }
                if (selected != null) {
                    this._current._selected.put(postponedBaseName, selected);
                }
                this._current._postponed.clear();
                this._current._postponedVersionless.clear();
            }
        }

        void primeSelected(Collection<String> features) {
            if (this._allowedMultipleVersions != null && this._allowedMultipleVersions.size() == 0) {
                return;
            }
            HashMap<String, String> conflicts = new HashMap<String, String>();
            Iterator<String> iFeatures = features.iterator();
            while (iFeatures.hasNext()) {
                String featureName = iFeatures.next();
                ProvisioningFeatureDefinition featureDef = this._repository.getFeature(featureName);
                if (featureDef == null || !featureDef.isSingleton()) continue;
                String featureSymbolicName = featureDef.getSymbolicName();
                String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(featureSymbolicName);
                String base = nameAndVersion[0];
                String preferredVersion = nameAndVersion[1];
                if (this.allowMultipleVersions(base)) continue;
                FeatureResolver.Chain selectedChain = this._current._selected.get(base);
                if (selectedChain != null) {
                    iFeatures.remove();
                    String selectedFeature = selectedChain.getCandidates().get(0);
                    if (!features.contains(selectedFeature)) continue;
                    FeatureResolver.Chain conflictedFeatureChain = new FeatureResolver.Chain(featureSymbolicName, preferredVersion, featureSymbolicName);
                    this.addConflict(base, this.asList(selectedChain, conflictedFeatureChain));
                    conflicts.put(selectedFeature, base);
                    continue;
                }
                this._current._selected.put(base, new FeatureResolver.Chain(featureSymbolicName, preferredVersion, featureSymbolicName));
            }
            for (Map.Entry conflict : conflicts.entrySet()) {
                features.remove(conflict.getKey());
                this._current._selected.remove(conflict.getValue());
            }
        }

        void addPostponed(String baseName, FeatureResolver.Chain chain) {
            Map<String, Chains> usePostponed = FeatureResolverImpl.isLinkingFeature(baseName) ? this._current._postponedVersionless : this._current._postponed;
            Chains existing = usePostponed.get(baseName);
            if (existing == null) {
                existing = new Chains();
                usePostponed.put(baseName, existing);
            }
            existing.add(chain);
        }

        FeatureResolver.Chain getPostponedConflict(String baseName, String selectedName) {
            Chains postponedChains = this._current._postponed.get(baseName);
            return postponedChains == null ? null : postponedChains.findConflict(selectedName);
        }

        void addConflict(String baseFeatureName, List<FeatureResolver.Chain> conflicts) {
            this._current._blockedFeatures.add(baseFeatureName);
            this._current._result.addConflict(baseFeatureName, conflicts);
        }

        Permutation getCurrent() {
            try {
                return this._current.copy(this._preResolveConflicts);
            }
            catch (DeadEndChain deadEndChain) {
                FFDCFilter.processException((Throwable)deadEndChain, (String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$SelectionContext", (String)"1893", (Object)this, (Object[])new Object[0]);
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$SelectionContext", SelectionContext.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        @TraceOptions
        static class Permutation {
            final Map<String, FeatureResolver.Chain> _selected = new HashMap<String, FeatureResolver.Chain>();
            final Map<String, Chains> _postponed = new LinkedHashMap<String, Chains>();
            final Map<String, Chains> _postponedVersionless = new LinkedHashMap<String, Chains>();
            final Set<String> _blockedFeatures = new HashSet<String>();
            final Set<String> _postponedFeaturesTried = new HashSet<String>();
            final FeatureResolverResultImpl _result = new FeatureResolverResultImpl();
            static final long serialVersionUID = -5270991110311826003L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            Permutation() {
            }

            Permutation copy(Map<String, Collection<FeatureResolver.Chain>> preResolveConflicts) throws DeadEndChain {
                Permutation copy = new Permutation();
                copy._selected.putAll(this._selected);
                copy._result._conflicts.putAll(preResolveConflicts);
                copy._result._missing.addAll(this._result.getMissing());
                copy._result._nonPublicRoots.addAll(this._result.getNonPublicRoots());
                copy._result._missingPlatforms.addAll(this._result._missingPlatforms);
                copy._result._resolvedPlatforms.addAll(this._result._resolvedPlatforms);
                copy._result._noPlatformVersionless.putAll(this._result._noPlatformVersionless);
                copy._result._duplicatePlatforms.putAll(this._result._duplicatePlatforms);
                for (Map.Entry<String, Chains> chainsEntry : this._postponed.entrySet()) {
                    copy._postponed.put(chainsEntry.getKey(), chainsEntry.getValue().copy());
                }
                for (Map.Entry<String, Chains> chainsEntry : this._postponedVersionless.entrySet()) {
                    copy._postponedVersionless.put(chainsEntry.getKey(), chainsEntry.getValue().copy());
                }
                copy._postponedFeaturesTried.addAll(this._postponedFeaturesTried);
                return copy;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$SelectionContext$Permutation", Permutation.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class Chains
    implements Comparator<FeatureResolver.Chain> {
        private final Set<String> _attempted = new HashSet<String>();
        private final List<FeatureResolver.Chain> _chains = new ArrayList<FeatureResolver.Chain>();
        static final long serialVersionUID = 1435514827570230535L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Chains() {
        }

        void add(FeatureResolver.Chain chain) {
            int insertion = Collections.binarySearch(this._chains, chain, this);
            if (insertion < 0) {
                insertion = -insertion - 1;
            } else {
                FeatureResolver.Chain existing;
                while (insertion < this._chains.size() && (existing = this._chains.get(insertion)) != null && this.compare(existing, chain) == 0) {
                    ++insertion;
                }
            }
            this._chains.add(insertion, chain);
        }

        public Chains copy() throws DeadEndChain {
            if (this.noMoreCandidatesToTry()) {
                throw new DeadEndChain();
            }
            Chains copy = new Chains();
            copy._chains.addAll(this._chains);
            copy._attempted.addAll(this._attempted);
            return copy;
        }

        private boolean noMoreCandidatesToTry() {
            for (FeatureResolver.Chain chain : this._chains) {
                boolean allAttempted = true;
                for (String candidate : chain.getCandidates()) {
                    if (!(allAttempted &= this._attempted.contains(candidate))) break;
                }
                if (!allAttempted) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(FeatureResolver.Chain o1, FeatureResolver.Chain o2) {
            return o1.getPreferredVersion().compareTo(o2.getPreferredVersion());
        }

        FeatureResolver.Chain selectTryFirst(String baseFeatureName, SelectionContext selectionContext) {
            for (FeatureResolver.Chain selectedChain : this._chains) {
                for (String candidate : selectedChain.getCandidates()) {
                    ProvisioningFeatureDefinition feature = selectionContext.getRepository().getFeature(candidate);
                    if (feature.getVisibility() != Visibility.PUBLIC || feature.getPlatformNames() == null) continue;
                    for (String plat : feature.getPlatformNames()) {
                        FeatureResolver.Chain match;
                        FeatureResolver.Chain c = selectionContext.getSelected(selectionContext.getCompatibilityBaseName(FeatureResolverImpl.parseName(plat)));
                        if (c == null || c.getCandidates().size() != 1 || !c.getCandidates().get(0).equals(((ProvisioningFeatureDefinition)allCompatibilityFeatures.get(plat.toLowerCase())).getSymbolicName()) || (match = this.match(candidate, selectedChain, selectionContext)) == null) continue;
                        return new FeatureResolver.Chain(selectedChain.getChain(), Collections.singletonList(candidate), feature.getVersion().toString(), selectedChain.getFeatureRequirement());
                    }
                }
            }
            return this.select(baseFeatureName, selectionContext);
        }

        FeatureResolver.Chain select(String baseFeatureName, SelectionContext selectionContext) {
            for (FeatureResolver.Chain selectedChain : this._chains) {
                FeatureResolver.Chain match;
                String preferredCandidate = selectedChain.getCandidates().get(0);
                if (!this._attempted.add(preferredCandidate) || (match = this.match(preferredCandidate, selectedChain, selectionContext)) == null) continue;
                return match;
            }
            for (FeatureResolver.Chain selectedChain : this._chains) {
                for (String candidate : selectedChain.getCandidates()) {
                    FeatureResolver.Chain match;
                    if (!this._attempted.add(candidate) || (match = this.match(candidate, selectedChain, selectionContext)) == null) continue;
                    return match;
                }
            }
            selectionContext.addConflict(baseFeatureName, this._chains);
            return null;
        }

        private FeatureResolver.Chain match(String candidate, FeatureResolver.Chain selectedChain, SelectionContext selectionContext) {
            for (FeatureResolver.Chain checkChain : this._chains) {
                if (selectedChain == checkChain || checkChain.getCandidates().contains(candidate)) continue;
                return null;
            }
            selectionContext.pushPermutation();
            return new FeatureResolver.Chain(selectedChain.getChain(), Collections.singletonList(candidate), selectedChain.getPreferredVersion().toString(), selectedChain.getFeatureRequirement());
        }

        List<FeatureResolver.Chain> getChains() {
            return this._chains;
        }

        FeatureResolver.Chain findConflict(String candidate) {
            for (FeatureResolver.Chain chain : this._chains) {
                if (chain.getCandidates().contains(candidate)) continue;
                return chain;
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$Chains", Chains.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class DeadEndChain
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DeadEndChain() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$DeadEndChain", DeadEndChain.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

