/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.internal.util.ImageInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Images {
    private final Map<String, ImageInfo> images;
    public Map<String, Map<String, ImageInfo>> cohorts;
    static final long serialVersionUID = 6425346995351680363L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Images() {
        this.images = new HashMap<String, ImageInfo>();
        this.cohorts = new HashMap<String, Map<String, ImageInfo>>();
    }

    public Images(int capacity) {
        this.images = new HashMap<String, ImageInfo>(capacity);
        this.cohorts = new HashMap<String, Map<String, ImageInfo>>();
    }

    protected void put(ImageInfo image) {
        String name = image.getName();
        String cohortName = image.getBaseName();
        String version = image.getVersion();
        this.images.put(name, image);
        Map<String, ImageInfo> cohort = this.cohorts.get(cohortName);
        if (cohort == null) {
            cohort = new HashMap<String, ImageInfo>();
            this.cohorts.put(cohortName, cohort);
        }
        cohort.put(version, image);
    }

    public Map<String, ImageInfo> getImages() {
        return this.images;
    }

    public ImageInfo getImage(String name) {
        return this.images.get(name);
    }

    public Map<String, Map<String, ImageInfo>> getCohorts() {
        return this.cohorts;
    }

    public Set<String> getCohortNames() {
        return this.cohorts.keySet();
    }

    public Map<String, ImageInfo> getCohort(String baseName) {
        return this.cohorts.get(baseName);
    }

    public ImageInfo getImage(String baseName, String version) {
        Map<String, ImageInfo> cohort = this.getCohort(baseName);
        return cohort == null ? null : cohort.get(version);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.Images", Images.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }
}

