/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.config;

import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.util.VariableUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.comparator.NameFileComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerConfigDocument {
    private CommonLoggerI log;
    private File configDirectory;
    private File serverXMLFile;
    private Set<String> names;
    private Set<String> namelessLocations;
    private Set<String> locations;
    private HashMap<String, String> locationsAndNames;
    private Properties props;
    private Properties defaultProps;
    private Map<String, File> libertyDirectoryPropertyToFile = null;
    private static final XPathExpression XPATH_SERVER_APPLICATION;
    private static final XPathExpression XPATH_SERVER_WEB_APPLICATION;
    private static final XPathExpression XPATH_SERVER_ENTERPRISE_APPLICATION;
    private static final XPathExpression XPATH_SERVER_INCLUDE;
    private static final XPathExpression XPATH_SERVER_VARIABLE;

    public Set<String> getLocations() {
        return this.locations;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Set<String> getNamelessLocations() {
        return this.namelessLocations;
    }

    public Properties getProperties() {
        return this.props;
    }

    public Map<String, File> getLibertyDirPropertyFiles() {
        return this.libertyDirectoryPropertyToFile;
    }

    public Properties getDefaultProperties() {
        return this.defaultProps;
    }

    public File getServerXML() {
        return this.serverXMLFile;
    }

    public ServerConfigDocument(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence, Map<String, File> libertyDirPropertyFiles) {
        this.initializeAppsLocation(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, giveConfigDirPrecedence, libertyDirPropertyFiles);
    }

    public ServerConfigDocument(CommonLoggerI log) {
        this.log = log;
        this.props = new Properties();
        this.defaultProps = new Properties();
        this.libertyDirectoryPropertyToFile = new HashMap<String, File>();
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setCoalescing(true);
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        docBuilderFactory.setValidating(false);
        try {
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return docBuilder;
    }

    private void initializeAppsLocation(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence, Map<String, File> libertyDirPropertyFiles) {
        try {
            this.log = log;
            this.serverXMLFile = serverXML;
            this.configDirectory = configDir;
            if (libertyDirPropertyFiles != null) {
                this.libertyDirectoryPropertyToFile = new HashMap<String, File>(libertyDirPropertyFiles);
            } else {
                log.warn("The properties for directories are null and could lead to application locations not being resolved correctly.");
                this.libertyDirectoryPropertyToFile = new HashMap<String, File>();
            }
            this.locations = new HashSet<String>();
            this.names = new HashSet<String>();
            this.namelessLocations = new HashSet<String>();
            this.locationsAndNames = new HashMap();
            this.props = new Properties();
            this.defaultProps = new Properties();
            Document doc = this.parseDocument(this.serverXMLFile);
            this.parseVariablesForDefaultValues(doc);
            File cfgFile = this.findConfigFile("server.env", serverEnvFile, giveConfigDirPrecedence);
            if (cfgFile != null) {
                this.parseProperties(new FileInputStream(cfgFile));
            }
            File cfgDirFile = this.getFileFromConfigDirectory("bootstrap.properties");
            if (giveConfigDirPrecedence && cfgDirFile != null) {
                this.parseProperties(new FileInputStream(cfgDirFile));
            } else if (bootstrapProp != null && !bootstrapProp.isEmpty()) {
                for (Map.Entry<String, String> entry : bootstrapProp.entrySet()) {
                    if (entry.getValue() == null) continue;
                    this.props.setProperty(entry.getKey(), entry.getValue());
                }
            } else if (bootstrapFile != null && bootstrapFile.exists()) {
                this.parseProperties(new FileInputStream(bootstrapFile));
            } else if (cfgDirFile != null) {
                this.parseProperties(new FileInputStream(cfgDirFile));
            }
            this.parseIncludeVariables(doc);
            this.parseConfigDropinsDirVariables("defaults");
            this.parseVariablesForValues(doc);
            this.parseConfigDropinsDirVariables("overrides");
            this.parseApplication(doc, XPATH_SERVER_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            this.parseNames(doc, "/server/application | /server/webApplication | /server/enterpriseApplication");
            this.parseInclude(doc);
            this.parseConfigDropinsDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseNames(Document doc, String expression) throws XPathExpressionException, IOException, SAXException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getAttributes().getNamedItem("name") != null) {
                String nameValue = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String locationValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
                if (nameValue.isEmpty()) continue;
                String resolvedName = VariableUtility.resolveVariables(this.log, nameValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
                String resolvedLocation = VariableUtility.resolveVariables(this.log, locationValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
                if (resolvedName == null) {
                    if (!this.names.contains(nameValue)) {
                        this.names.add(nameValue);
                    }
                } else if (!this.names.contains(resolvedName)) {
                    this.names.add(resolvedName);
                }
                if (resolvedLocation == null) continue;
                if (resolvedName == null) {
                    this.locationsAndNames.put(resolvedLocation, nameValue);
                    continue;
                }
                this.locationsAndNames.put(resolvedLocation, resolvedName);
                continue;
            }
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty()) continue;
            String resolved = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (resolved == null) {
                if (this.namelessLocations.contains(nodeValue)) continue;
                this.namelessLocations.add(nodeValue);
                continue;
            }
            if (this.namelessLocations.contains(resolved)) continue;
            this.namelessLocations.add(resolved);
        }
    }

    public String findNameForLocation(String location) {
        String appName = this.locationsAndNames.get(location);
        if (appName == null || appName.isEmpty()) {
            appName = location.substring(0, location.lastIndexOf(46));
        }
        return appName;
    }

    private void parseApplication(Document doc, XPathExpression expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty()) continue;
            String resolved = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (resolved == null) {
                this.log.info("The variables referenced by location " + nodeValue + " cannot be resolved.");
                if (this.locations.contains(nodeValue)) continue;
                this.locations.add(nodeValue);
                continue;
            }
            if (this.locations.contains(resolved)) continue;
            this.log.debug("Adding resolved app location: " + resolved + " for specified location: " + nodeValue);
            this.locations.add(resolved);
        }
    }

    private void parseInclude(Document doc) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element child = (Element)nodeList.item(i);
            String nodeValue = child.getAttribute("location");
            String includeFileName = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (includeFileName == null || includeFileName.trim().isEmpty()) {
                this.log.warn("Unable to resolve include file location " + nodeValue + ". Skipping the included file during application location processing.");
                continue;
            }
            ArrayList<Document> inclDocs = this.getIncludeDocs(includeFileName);
            for (Document inclDoc : inclDocs) {
                this.parseApplication(inclDoc, XPATH_SERVER_APPLICATION);
                this.parseApplication(inclDoc, XPATH_SERVER_WEB_APPLICATION);
                this.parseApplication(inclDoc, XPATH_SERVER_ENTERPRISE_APPLICATION);
                this.parseInclude(inclDoc);
            }
        }
    }

    private void parseConfigDropinsDir() throws XPathExpressionException, IOException, SAXException {
        File defaults;
        File configDropins = this.getConfigDropinsDir();
        if (configDropins == null || !configDropins.exists()) {
            return;
        }
        File overrides = new File(configDropins, "overrides");
        if (overrides.exists()) {
            this.parseDropinsFiles(overrides.listFiles());
        }
        if ((defaults = new File(configDropins, "defaults")).exists()) {
            this.parseDropinsFiles(defaults.listFiles());
        }
    }

    private void parseDropinsFiles(File[] files) throws XPathExpressionException, IOException, SAXException {
        Arrays.sort(files, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        for (File file : files) {
            if (!file.isFile()) continue;
            this.parseDropinsFile(file);
        }
    }

    private void parseDropinsFile(File file) throws IOException, XPathExpressionException, SAXException {
        Document doc = this.parseDocument(file);
        if (doc != null) {
            this.parseApplication(doc, XPATH_SERVER_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            this.parseInclude(doc);
        }
    }

    private ArrayList<Document> getIncludeDocs(String loc) throws IOException, SAXException {
        ArrayList<Document> docs = new ArrayList<Document>();
        Document doc = null;
        File locFile = null;
        if (loc.startsWith("http:") || loc.startsWith("https:")) {
            if (this.isValidURL(loc)) {
                URL url = new URL(loc);
                doc = this.parseDocument(url);
                docs.add(doc);
            }
        } else if (loc.startsWith("file:")) {
            if (this.isValidURL(loc)) {
                locFile = new File(loc);
                doc = this.parseDocument(locFile);
                docs.add(doc);
            }
        } else if (!loc.startsWith("ftp:")) {
            locFile = new File(loc);
            if (!locFile.isAbsolute()) {
                if (this.configDirectory != null && this.configDirectory.exists()) {
                    locFile = new File(this.configDirectory, loc);
                }
                if (locFile == null || !locFile.exists()) {
                    locFile = new File(this.getServerXML().getParentFile(), loc);
                }
            }
            this.parseDocumentFromFileOrDirectory(locFile, loc, docs);
        }
        if (docs.isEmpty()) {
            this.log.warn("Did not parse any file(s) from include location: " + loc);
        }
        return docs;
    }

    private void parseDocumentFromFileOrDirectory(File f, String locationString, ArrayList<Document> docs) throws FileNotFoundException, IOException, SAXException {
        Document doc = null;
        boolean isLibertyDirectory = locationString.endsWith("/");
        if (f == null || !f.exists()) {
            this.log.warn("Unable to parse from file: " + f.getCanonicalPath());
            return;
        }
        if (f.isFile() && isLibertyDirectory) {
            this.log.error("Path specified a directory, but resource exists as a file (path=" + locationString + ")");
            return;
        }
        if (f.isDirectory() && !isLibertyDirectory) {
            this.log.error("Path specified a file, but resource exists as a directory (path=" + locationString + ")");
            return;
        }
        if (f.isDirectory()) {
            this.parseDocumentsInDirectory(f, docs);
        } else {
            doc = this.parseDocument(f);
            docs.add(doc);
        }
    }

    private void parseDocumentsInDirectory(File directory, ArrayList<Document> docs) {
        File[] files = directory.listFiles();
        Arrays.sort(files, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        for (File file : files) {
            try {
                docs.add(this.parseDocument(file));
            }
            catch (Exception e) {
                this.log.warn("Unable to parse from file " + file.getPath() + " from specified include directory: " + directory.getPath());
            }
        }
    }

    public Document parseDocument(File file) throws FileNotFoundException, IOException {
        Document document;
        FileInputStream is = new FileInputStream(file);
        try {
            document = this.parseDocument(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXException ex) {
                this.log.info("Skipping parsing " + file.getAbsolutePath() + " because it was not recognized as XML.");
                return null;
            }
        }
        is.close();
        return document;
    }

    private Document parseDocument(URL url) throws IOException, SAXException {
        URLConnection connection = url.openConnection();
        try (InputStream is = connection.getInputStream();){
            Document document = this.parseDocument(is);
            return document;
        }
    }

    private Document parseDocument(InputStream in) throws SAXException, IOException {
        try (InputStream ins = in;){
            Document document = this.getDocumentBuilder().parse(ins);
            return document;
        }
    }

    private void parseProperties(InputStream ins) throws Exception {
        try {
            this.props.load(ins);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
    }

    private boolean isValidURL(String url) {
        try {
            URL testURL = new URL(url);
            testURL.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void parseVariablesForDefaultValues(Document doc) throws XPathExpressionException {
        this.parseVariables(doc, true, false, false);
    }

    private void parseVariablesForValues(Document doc) throws XPathExpressionException {
        this.parseVariables(doc, false, true, false);
    }

    public void parseVariablesForBothValues(Document doc) throws XPathExpressionException {
        this.parseVariables(doc, false, false, true);
    }

    private void parseVariables(Document doc, boolean defaultValues, boolean values, boolean both) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPATH_SERVER_VARIABLE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap attr = nodeList.item(i).getAttributes();
            String varName = attr.getNamedItem("name").getNodeValue();
            if (varName.isEmpty()) continue;
            String varValue = this.getValue(attr, "value");
            String varDefaultValue = this.getValue(attr, "defaultValue");
            if ((values || both) && varValue != null && !varValue.isEmpty()) {
                this.props.setProperty(varName, varValue);
            }
            if (!defaultValues && !both || varDefaultValue == null || varDefaultValue.isEmpty()) continue;
            this.defaultProps.setProperty(varName, varDefaultValue);
        }
    }

    private String getValue(NamedNodeMap attr, String nodeName) {
        String value = null;
        Node valueNode = attr.getNamedItem(nodeName);
        if (valueNode != null) {
            value = valueNode.getNodeValue();
        }
        return value;
    }

    public void parseIncludeVariables(Document doc) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element child = (Element)nodeList.item(i);
            String nodeValue = child.getAttribute("location");
            String includeFileName = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (includeFileName == null || includeFileName.trim().isEmpty()) {
                this.log.warn("Unable to resolve include file location " + nodeValue + ". Skipping the included file during application location processing.");
                continue;
            }
            ArrayList<Document> inclDocs = this.getIncludeDocs(includeFileName);
            for (Document inclDoc : inclDocs) {
                this.parseVariablesForBothValues(inclDoc);
                this.parseIncludeVariables(inclDoc);
            }
        }
    }

    private File getConfigDropinsDir() {
        File configDropins = null;
        if (this.configDirectory != null && this.configDirectory.exists()) {
            configDropins = new File(this.configDirectory, "configDropins");
        }
        if (configDropins == null || !configDropins.exists()) {
            configDropins = new File(this.getServerXML().getParent(), "configDropins");
        }
        return configDropins;
    }

    private void parseConfigDropinsDirVariables(String inDir) throws XPathExpressionException, SAXException, IOException {
        File configDropins = this.getConfigDropinsDir();
        if (configDropins == null || !configDropins.exists()) {
            return;
        }
        File dir = new File(configDropins, inDir);
        if (!dir.exists()) {
            return;
        }
        File[] cfgFiles = dir.listFiles();
        Arrays.sort(cfgFiles, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        for (File file : cfgFiles) {
            if (!file.isFile()) continue;
            this.parseDropinsFilesVariables(file);
        }
    }

    private void parseDropinsFilesVariables(File file) throws SAXException, IOException, XPathExpressionException {
        Document doc = this.parseDocument(file);
        if (doc != null) {
            this.parseVariablesForBothValues(doc);
            this.parseIncludeVariables(doc);
        }
    }

    private File findConfigFile(String fileName, File specificFile, boolean giveConfigDirPrecedence) {
        File f = new File(this.configDirectory, fileName);
        if (giveConfigDirPrecedence) {
            if (this.configDirectory != null && f.exists()) {
                return f;
            }
            if (specificFile != null && specificFile.exists()) {
                return specificFile;
            }
        } else {
            if (specificFile != null && specificFile.exists()) {
                return specificFile;
            }
            if (this.configDirectory != null && f.exists()) {
                return f;
            }
        }
        return null;
    }

    private File getFileFromConfigDirectory(String file) {
        File f = new File(this.configDirectory, file);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    static {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPATH_SERVER_APPLICATION = xPath.compile("/server/application");
            XPATH_SERVER_WEB_APPLICATION = xPath.compile("/server/webApplication");
            XPATH_SERVER_ENTERPRISE_APPLICATION = xPath.compile("/server/enterpriseApplication");
            XPATH_SERVER_INCLUDE = xPath.compile("/server/include");
            XPATH_SERVER_VARIABLE = xPath.compile("/server/variable");
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

