/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.VersionUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public abstract class AbstractContainerSupportUtil {
    private static final String CONTAINER_DOCKER_PREFIX = "docker ";
    private static final String CONTAINER_PODMAN_PREFIX = "podman ";
    protected static final int CONTAINER_TIMEOUT = 20;
    private boolean checkedContainerType = false;
    protected boolean isDocker = true;
    private static final String MIN_DOCKER_VERSION = "18.03.0";
    private static final String MIN_PODMAN_VERSION = "4.4.4";

    public abstract void debug(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract void info(String var1);

    public void setIsDocker(boolean isDocker) throws PluginExecutionException {
        this.isDocker = isDocker;
        this.checkedContainerType = true;
        if (this.isDocker) {
            this.checkDockerVersion();
        } else {
            this.checkPodmanVersion();
        }
    }

    protected String getContainerCommandPrefix() throws PluginExecutionException {
        if (!this.checkedContainerType) {
            this.checkDockerVersion();
        }
        return this.isDocker ? CONTAINER_DOCKER_PREFIX : CONTAINER_PODMAN_PREFIX;
    }

    protected boolean checkDockerVersion() throws PluginExecutionException {
        String versionCmd = "docker version --format {{.Client.Version}}";
        String dockerVersion = this.execContainerCmd(versionCmd, 20);
        if (dockerVersion == null) {
            return this.checkPodmanVersion();
        }
        this.debug("Detected Docker version: " + dockerVersion);
        if (VersionUtility.compareArtifactVersion(dockerVersion, MIN_DOCKER_VERSION, false) < 0 && !this.checkPodmanVersion()) {
            throw new PluginExecutionException("The detected Docker client version number is not supported:" + dockerVersion.trim() + ". Docker version must be " + MIN_DOCKER_VERSION + " or higher.");
        }
        if (!this.checkedContainerType) {
            this.isDocker = true;
            this.checkedContainerType = true;
        }
        return true;
    }

    private boolean checkPodmanVersion() throws PluginExecutionException {
        String versionCmd = "podman version --format {{.Client.Version}}";
        String podmanVersion = this.execContainerCmd(versionCmd, 20);
        if (podmanVersion == null) {
            return false;
        }
        this.debug("Detected Podman version: " + podmanVersion);
        if (VersionUtility.compareArtifactVersion(podmanVersion, MIN_PODMAN_VERSION, false) < 0) {
            throw new PluginExecutionException("The detected Podman client version number is not supported:" + podmanVersion.trim() + ". Podman version must be " + MIN_PODMAN_VERSION + " or higher.");
        }
        this.isDocker = false;
        this.checkedContainerType = true;
        return true;
    }

    protected String execContainerCmd(String command, int timeout, boolean throwExceptionOnError) {
        String result = null;
        try {
            this.debug("execContainer, timeout=" + timeout + ", cmd=" + command);
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor(timeout, TimeUnit.SECONDS);
            if (p.exitValue() != 0) {
                this.debug("Error running container command, return value=" + p.exitValue());
                char[] d = new char[1023];
                new InputStreamReader(p.getErrorStream()).read(d);
                String errorMessage = new String(d).trim() + " RC=" + p.exitValue();
                if (throwExceptionOnError) {
                    throw new RuntimeException(errorMessage);
                }
                return errorMessage;
            }
            result = this.readStdOut(p);
        }
        catch (IllegalThreadStateException e) {
            this.debug("IllegalThreadStateException, message=" + e.getMessage());
            this.error("The container command did not complete within the timeout period: " + timeout + " seconds.", e);
            throw new RuntimeException("The container command did not complete within the timeout period: " + timeout + " seconds. ");
        }
        catch (InterruptedException e) {
            this.error("An interruption error occurred while running a container command: " + e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            this.debug("An error occurred while running a container command: " + e.getMessage());
            this.debug("This message will occur when Docker or Podman are not installed.");
        }
        return result;
    }

    protected String execContainerCmd(String command, int timeout) {
        return this.execContainerCmd(command, timeout, true);
    }

    protected String execContainerCmdWithPrefix(String command, int timeout) {
        return this.execContainerCmdWithPrefix(command, timeout, true);
    }

    protected String execContainerCmdWithPrefix(String command, int timeout, boolean throwExceptionOnError) {
        try {
            String containerCommand = this.getContainerCommandPrefix() + " " + command;
            return this.execContainerCmd(containerCommand, timeout, throwExceptionOnError);
        }
        catch (PluginExecutionException pe) {
            this.error("Error while determining container command prefix.", pe);
            return pe.getMessage();
        }
    }

    protected String readStdOut(Process p) throws IOException, InterruptedException {
        String line;
        String result = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        StringBuffer allLines = new StringBuffer();
        while ((line = in.readLine()) != null) {
            allLines.append(line).append(" ");
        }
        if (allLines.length() > 0) {
            result = allLines.toString();
        }
        return result;
    }
}

