/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.CommonLoggerI;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableUtility {
    private static final String VARIABLE_NAME_PATTERN = "\\$\\{(.*?)\\}";
    private static final Pattern varNamePattern = Pattern.compile("\\$\\{(.*?)\\}");

    public static String resolveVariables(CommonLoggerI log, String nodeValue, Collection<String> variableChain, Properties props, Properties defaultProps, Map<String, File> libDirPropFiles) {
        String resolved = nodeValue.replace("\\", "/");
        Matcher varNameMatcher = varNamePattern.matcher(nodeValue);
        HashSet<String> variablesToResolve = new HashSet<String>();
        while (varNameMatcher.find()) {
            String varName = varNameMatcher.group(1);
            if (variableChain != null && variableChain.contains(varName)) {
                log.debug("Found a recursive variable reference when resolving ${" + varName + "}");
                return null;
            }
            variablesToResolve.add(varName);
        }
        for (String nextVariable : variablesToResolve) {
            String value = VariableUtility.getPropertyValue(nextVariable, props, defaultProps, libDirPropFiles);
            if (value != null && !value.isEmpty()) {
                String resolvedValue;
                HashSet<String> thisVariableChain = new HashSet<String>();
                thisVariableChain.add(nextVariable);
                if (variableChain != null && !variableChain.isEmpty()) {
                    thisVariableChain.addAll(variableChain);
                }
                if ((resolvedValue = VariableUtility.resolveVariables(log, value, thisVariableChain, props, defaultProps, libDirPropFiles)) != null) {
                    String escapedVariable = Matcher.quoteReplacement(nextVariable);
                    resolvedValue = resolvedValue.replace("\\", "/");
                    resolved = resolved.replaceAll("\\$\\{" + escapedVariable + "\\}", resolvedValue);
                    continue;
                }
                log.debug("Could not resolve the value " + value + " for variable ${" + nextVariable + "}");
                return null;
            }
            log.debug("Variable " + nextVariable + " cannot be resolved.");
            return null;
        }
        log.debug("Expression " + nodeValue + " evaluated and replaced with " + resolved);
        return resolved;
    }

    public static String getPropertyValue(String propertyName, Properties props, Properties defaultProps, Map<String, File> libDirPropFiles) {
        String value = null;
        if (!libDirPropFiles.containsKey(propertyName)) {
            String newPropName;
            value = props.getProperty(propertyName);
            if (value == null) {
                value = defaultProps.getProperty(propertyName);
            }
            if (value == null && propertyName.startsWith("env.") && propertyName.length() > 4 && (value = props.getProperty(newPropName = propertyName.substring(4))) == null) {
                value = defaultProps.getProperty(newPropName);
            }
        } else {
            File envDirectory = libDirPropFiles.get(propertyName);
            value = envDirectory.toString();
        }
        if (value != null && value.startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

