/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.util.AbstractContainerSupportUtil;
import io.openliberty.tools.common.plugins.util.HotKey;
import io.openliberty.tools.common.plugins.util.JavaCompilerOptions;
import io.openliberty.tools.common.plugins.util.OSUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.ProjectModule;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class DevUtil
extends AbstractContainerSupportUtil {
    private static final String START_SERVER_MESSAGE_PREFIX = "CWWKF0011I:";
    private static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I:";
    private static final String UPDATED_APP_MESSAGE_REGEXP = "CWWKZ0003I:";
    private static final String STOPPED_APP_MESSAGE_REGEXP = "CWWKZ0009I:";
    private static final String PORT_IN_USE_MESSAGE_PREFIX = "CWWKO0221E:";
    private static final String WEB_APP_AVAILABLE_MESSAGE_PREFIX = "CWWKT0016I:";
    private static final String LISTENING_ON_PORT_MESSAGE_PREFIX = "CWWKO0219I:";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTP_PREFIX_ESCAPED = "http:\\/\\/";
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTPS_PREFIX_ESCAPED = "https:\\/\\/";
    private static final String DEVMODE_DIR_NAME = "/devmode";
    public static final String DEVMODE_PROJECT_ROOT = "io.openliberty.tools.projectRoot";
    private static final String GENERATED_HEADER_REGEX = "# Generated by liberty-.*-plugin";
    private static final String DEVMODE_CONTAINER_BASE_NAME = "liberty-dev";
    private static final String DEVC_CONTAINER_DOCKER = "docker";
    private static final String DEVC_CONTAINER_PODMAN = "podman";
    private static final String DEVMODE_IMAGE_SUFFIX = "-dev-mode";
    public static final String SKIP_BETA_INSTALL_WARNING = "skipBetaInstallFeatureWarning";
    public static final String DEVC_HIDDEN_FOLDER = ".libertyDevc";
    private static final String[] IGNORE_DIRECTORY_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_POSTFIXES = new String[]{".dmp", "~", "___jb_tmp___", "___jb_old___"};
    private static final String[] DEFAULT_COMPILER_OPTIONS = new String[]{"-g", "-parameters"};
    private static final int LIBERTY_DEFAULT_HTTP_PORT = 9080;
    private static final int LIBERTY_DEFAULT_HTTPS_PORT = 9443;
    private File serverDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File configDirectory;
    private File projectDirectory;
    private File multiModuleProjectDirectory;
    protected List<File> resourceDirs;
    protected List<Path> monitoredWebResourceDirs;
    private boolean hotTests;
    private Path tempConfigPath;
    private boolean skipTests;
    private boolean skipUTs;
    private boolean skipITs;
    private String applicationId;
    private int appStartupTimeout;
    private int appUpdateTimeout;
    private Thread serverThread;
    private PluginExecutionException serverThreadException;
    private AtomicBoolean devStop;
    private String hostName;
    private String httpPort;
    private String httpsPort;
    private String containerHttpPort;
    private String containerHttpsPort;
    private final long compileWaitMillis;
    private AtomicBoolean inputUnavailable;
    private int alternativeDebugPort = -1;
    private boolean libertyDebug;
    private int libertyDebugPort;
    private AtomicBoolean detectedAppStarted;
    private long serverStartTimeout;
    private boolean useBuildRecompile;
    private Map<File, Properties> propertyFilesMap;
    private final Set<FileAlterationObserver> fileObservers;
    private final Set<FileAlterationObserver> newFileObservers;
    private final Set<FileAlterationObserver> cancelledFileObservers;
    private AtomicBoolean calledShutdownHook;
    private boolean gradle;
    private long pollingInterval;
    private FileTrackMode trackingMode;
    private final boolean container;
    private String imageName;
    private String containerName;
    private File containerfile;
    private File containerBuildContext;
    private Path tempContainerfilePath = null;
    private String containerRunOpts;
    private volatile Process containerRunProcess;
    private File defaultContainerfile;
    private int containerBuildTimeout;
    private boolean skipDefaultPorts;
    private boolean keepTempContainerfile;
    protected List<String> srcMount = new ArrayList<String>();
    protected List<String> destMount = new ArrayList<String>();
    private boolean firstStartup = true;
    private Set<Path> containerfileDirectoriesToWatch = new HashSet<Path>();
    private Set<Path> containerfileDirectoriesTracked = new HashSet<Path>();
    private Set<WatchKey> containerfileDirectoriesWatchKeys = new HashSet<WatchKey>();
    private Set<FileAlterationObserver> containerfileDirectoriesFileObservers = new HashSet<FileAlterationObserver>();
    private JavaCompilerOptions compilerOptions;
    private final String mavenCacheLocation;
    private AtomicBoolean externalContainerShutdown;
    private AtomicBoolean shownFeaturesShWarning;
    protected AtomicBoolean hasFeaturesSh;
    protected AtomicBoolean serverFullyStarted;
    private final File buildDirectory;
    private List<ProjectModule> upstreamProjects;
    private boolean recompileDependencies;
    private String packagingType;
    protected File buildFile;
    protected Map<String, List<String>> parentBuildFiles;
    private boolean generateFeatures;
    private Set<String> generatedFeaturesSet;
    private boolean generatedFeaturesModified;
    private Set<String> compileArtifactPaths;
    private Set<String> testArtifactPaths;
    protected final File generatedFeaturesFile;
    private File modifiedSrcBuildFile;
    protected boolean skipInstallFeature;
    private static final long DOCKER_BUILD_SOFT_TIMEOUT = 30000L;
    private HotkeyReader hotkeyReader = null;
    Collection<File> recompileJavaSources;
    Collection<File> recompileJavaTests;
    Collection<File> deleteJavaSources;
    Collection<File> deleteJavaTests;
    Collection<File> failedCompilationJavaSources;
    Collection<File> failedCompilationJavaTests;
    Collection<File> modifiedClasses;
    Collection<File> failedToGenerateClasses;
    Collection<File> omitWatchingFiles;
    long lastJavaSourceChange;
    long lastJavaTestChange;
    Map<File, Long> lastBuildFileChange;
    boolean triggerJavaSourceRecompile;
    boolean triggerJavaTestRecompile;
    File outputDirectory;
    File testOutputDirectory;
    File serverXmlFile;
    File serverXmlFileParent;
    File bootstrapPropertiesFile;
    File bootstrapPropertiesFileParent;
    File jvmOptionsFile;
    File jvmOptionsFileParent;
    File containerfileUsed;
    File looseAppFile;
    WatchService watcher;
    boolean lastChangeCompiled;
    boolean triggerUpstreamJavaSourceRecompile;
    boolean initialCompile;
    boolean disableDependencyCompile;

    @Override
    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    @Override
    public abstract void info(String var1);

    public abstract void error(String var1);

    @Override
    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean recompileBuildFile(File var1, Set<String> var2, Set<String> var3, boolean var4, ThreadPoolExecutor var5) throws PluginExecutionException;

    public abstract boolean updateArtifactPaths(ProjectModule var1, boolean var2, boolean var3, ThreadPoolExecutor var4) throws PluginExecutionException;

    public abstract boolean updateArtifactPaths(File var1);

    public abstract void runUnitTests(File var1) throws PluginScenarioException, PluginExecutionException;

    public abstract void runIntegrationTests(File var1) throws PluginScenarioException, PluginExecutionException;

    public abstract void installFeatures(File var1, File var2, boolean var3);

    public abstract ServerFeatureUtil getServerFeatureUtilObj();

    public abstract Set<String> getExistingFeatures();

    public abstract void updateExistingFeatures();

    public abstract boolean compile(File var1);

    public abstract boolean compile(File var1, ProjectModule var2);

    public abstract void stopServer();

    public abstract ServerTask getServerTask() throws Exception;

    public abstract void redeployApp() throws PluginExecutionException;

    public abstract String getServerStartTimeoutExample();

    public abstract String getProjectName();

    public abstract boolean isLooseApplication();

    public abstract File getLooseApplicationFile();

    public DevUtil(File buildDirectory, File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, File projectDirectory, File multiModuleProjectDirectory, List<File> resourceDirs, boolean hotTests, boolean skipTests, boolean skipUTs, boolean skipITs, boolean skipInstallFeature, String applicationId, long serverStartTimeout, int appStartupTimeout, int appUpdateTimeout, long compileWaitMillis, boolean libertyDebug, boolean useBuildRecompile, boolean gradle, boolean pollingTest, boolean container, File containerfile, File containerBuildContext, String containerRunOpts, int containerBuildTimeout, boolean skipDefaultPorts, JavaCompilerOptions compilerOptions, boolean keepTempContainerfile, String mavenCacheLocation, List<ProjectModule> upstreamProjects, boolean recompileDependencies, String packagingType, File buildFile, Map<String, List<String>> parentBuildFiles, boolean generateFeatures, Set<String> compileArtifactPaths, Set<String> testArtifactPaths, List<Path> monitoredWebResourceDirs) {
        this.buildDirectory = buildDirectory;
        this.serverDirectory = serverDirectory;
        this.sourceDirectory = sourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.configDirectory = configDirectory;
        this.projectDirectory = projectDirectory;
        this.multiModuleProjectDirectory = multiModuleProjectDirectory;
        this.resourceDirs = resourceDirs;
        this.hotTests = hotTests;
        this.skipTests = skipTests;
        this.skipUTs = skipUTs;
        this.skipITs = skipITs;
        this.skipInstallFeature = skipInstallFeature;
        this.applicationId = applicationId;
        this.serverStartTimeout = serverStartTimeout;
        this.appStartupTimeout = appStartupTimeout;
        this.appUpdateTimeout = appUpdateTimeout;
        this.devStop = new AtomicBoolean(false);
        this.compileWaitMillis = compileWaitMillis;
        this.inputUnavailable = new AtomicBoolean(false);
        this.libertyDebug = libertyDebug;
        this.detectedAppStarted = new AtomicBoolean(false);
        this.useBuildRecompile = useBuildRecompile;
        this.calledShutdownHook = new AtomicBoolean(false);
        this.gradle = gradle;
        this.fileObservers = new HashSet<FileAlterationObserver>();
        this.newFileObservers = new HashSet<FileAlterationObserver>();
        this.cancelledFileObservers = new HashSet<FileAlterationObserver>();
        this.pollingInterval = 100L;
        this.trackingMode = pollingTest ? FileTrackMode.POLLING : FileTrackMode.NOT_SET;
        this.container = container;
        this.containerfile = containerfile;
        this.containerBuildContext = containerBuildContext;
        this.containerRunOpts = containerRunOpts;
        if (projectDirectory != null) {
            File defaultDockerFile = new File(projectDirectory, "Dockerfile");
            File userDefaultContainerFile = new File(projectDirectory, "Containerfile");
            this.defaultContainerfile = !defaultDockerFile.exists() && userDefaultContainerFile.exists() ? userDefaultContainerFile : defaultDockerFile;
        }
        this.containerBuildTimeout = containerBuildTimeout < 1 ? 600 : containerBuildTimeout;
        this.skipDefaultPorts = skipDefaultPorts;
        this.compilerOptions = compilerOptions;
        this.keepTempContainerfile = keepTempContainerfile;
        this.mavenCacheLocation = mavenCacheLocation;
        this.upstreamProjects = upstreamProjects;
        this.recompileDependencies = recompileDependencies;
        this.externalContainerShutdown = new AtomicBoolean(false);
        this.shownFeaturesShWarning = new AtomicBoolean(false);
        this.hasFeaturesSh = new AtomicBoolean(false);
        this.serverFullyStarted = new AtomicBoolean(false);
        this.packagingType = packagingType;
        this.buildFile = buildFile;
        this.parentBuildFiles = parentBuildFiles == null ? new HashMap<String, List<String>>() : parentBuildFiles;
        this.generateFeatures = generateFeatures;
        this.compileArtifactPaths = compileArtifactPaths;
        this.testArtifactPaths = testArtifactPaths;
        this.monitoredWebResourceDirs = monitoredWebResourceDirs;
        this.generatedFeaturesFile = new File(configDirectory, "configDropins/overrides/generated-features.xml");
        this.generatedFeaturesModified = false;
        this.generatedFeaturesSet = this.generateFeatures ? this.getGeneratedFeatures() : new HashSet<String>();
        this.modifiedSrcBuildFile = null;
    }

    public void runTests(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipTests, boolean forceSkipUTs, boolean forceSkipITs, File currentBuildFile, String projectName) {
        this.debug("Running tests for: " + currentBuildFile + "; skipTests: " + forceSkipTests + "; skipITs: " + forceSkipITs + "; skipUTs: " + forceSkipUTs);
        if (!forceSkipTests) {
            ServerTask serverTask = null;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                this.error("Could not get the server task for running tests.", e);
            }
            File logFile = this.getMessagesLogFile(serverTask);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.debug("Thread interrupted while waiting to start tests.", e);
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.debug("Tests were re-invoked before previous tests began. Cancelling previous tests and resubmitting them.");
                } else {
                    this.debug("Changes were detected before tests began. Cancelling tests and resubmitting them.");
                }
                return;
            }
            if (!this.gradle && !forceSkipUTs) {
                if (projectName != null) {
                    this.info("Running unit tests for " + projectName + " ...");
                } else {
                    this.info("Running unit tests...");
                }
                try {
                    this.runUnitTests(currentBuildFile);
                    if (projectName != null) {
                        this.info("Unit tests for " + projectName + " finished.");
                        this.info("");
                    } else {
                        this.info("Unit tests finished.");
                        this.info("");
                    }
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage(), e);
                }
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.info("Tests were invoked while previous tests were running. Restarting tests.");
                } else {
                    this.info("Changes were detected while tests were running. Restarting tests.");
                }
                return;
            }
            if (!forceSkipITs) {
                if (!this.detectedAppStarted.get()) {
                    if (this.appStartupTimeout < 0) {
                        this.warn("The verifyTimeout (verifyAppStartTimeout) value needs to be an integer greater than or equal to 0.  The default value of 30 seconds will be used.");
                        this.appStartupTimeout = 30;
                    }
                    long timeout = this.appStartupTimeout * 1000;
                    this.info("Waiting up to " + this.appStartupTimeout + " seconds to find the application start up or update message...");
                    String startMessage = serverTask.waitForStringInLog("(CWWKZ0001I:|CWWKZ0003I:)", timeout, logFile);
                    if (startMessage == null) {
                        this.error("Unable to verify if the application was started after " + this.appStartupTimeout + " seconds.  Consider increasing the verifyTimeout value if this continues to occur.");
                    } else {
                        this.detectedAppStarted.set(true);
                    }
                } else if (waitForApplicationUpdate) {
                    int timesStopped = serverTask.countStringOccurrencesInFile(STOPPED_APP_MESSAGE_REGEXP, logFile);
                    int timesUpdated = serverTask.countStringOccurrencesInFile(UPDATED_APP_MESSAGE_REGEXP, logFile);
                    this.debug("timesStopped=" + timesStopped + " timesUpdated=" + timesUpdated);
                    if (timesStopped > timesUpdated) {
                        if (this.appUpdateTimeout < 0) {
                            this.appUpdateTimeout = 5;
                        }
                        long timeout = this.appUpdateTimeout * 1000;
                        serverTask.waitForUpdatedStringInLog(UPDATED_APP_MESSAGE_REGEXP, timeout, logFile, messageOccurrences);
                    }
                }
                if (this.gradle) {
                    this.info("Running tests...");
                } else if (projectName != null) {
                    this.info("Running integration tests for " + projectName + "...");
                } else {
                    this.info("Running integration tests...");
                }
                try {
                    this.runIntegrationTests(currentBuildFile);
                    if (this.gradle) {
                        this.info("Tests finished.");
                    } else if (projectName != null) {
                        this.info("Integration tests for " + projectName + " finished.");
                        this.info("");
                    } else {
                        this.info("Integration tests finished.");
                        this.info("");
                    }
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage(), e);
                }
            }
        }
    }

    public int countApplicationUpdatedMessages() {
        int messageOccurrences = -1;
        if (!this.skipTests && !this.skipITs) {
            try {
                ServerTask serverTask = this.getServerTask();
                File logFile = this.getMessagesLogFile(serverTask);
                String regexp = UPDATED_APP_MESSAGE_REGEXP;
                messageOccurrences = serverTask.countStringOccurrencesInFile(regexp, logFile);
                this.debug("Message occurrences before compile: " + messageOccurrences);
            }
            catch (Exception e) {
                this.debug("Failed to get message occurrences before compile", e);
            }
        }
        return messageOccurrences;
    }

    private File getMessagesLogFile(ServerTask serverTask) {
        File logFile = this.container ? new File(this.serverDirectory, "logs/messages.log") : serverTask.getLogFile();
        return logFile;
    }

    public void startServer() throws PluginExecutionException {
        this.startServer(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(boolean buildContainer, boolean pullParentImage) throws PluginExecutionException {
        try {
            long serverStartTimeoutMillis;
            String startMessage;
            ServerTask serverTask;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
            }
            this.enableServerDebug();
            if (this.container && !this.checkDockerVersion()) {
                throw new PluginExecutionException("Could not find a valid Docker or Podman installation.");
            }
            if (this.container && buildContainer) {
                File containerfileToUse = this.getContainerfile();
                this.debug("Containerfile to use: " + containerfileToUse);
                if (containerfileToUse.exists()) {
                    File buildContext = this.containerBuildContext == null ? containerfileToUse.getParentFile() : this.containerBuildContext;
                    String buildContextString = buildContext.getAbsolutePath();
                    this.debug("Container build context: " + buildContextString);
                    File tempContainerfile = this.prepareTempContainerfile(containerfileToUse, buildContextString);
                    this.buildContainerImage(tempContainerfile, containerfileToUse, pullParentImage, buildContext);
                } else {
                    throw new PluginExecutionException("No Containerfile or Dockerfile was found at " + containerfileToUse.getAbsolutePath() + ". Create a Containerfile/Dockerfile at the specified location to use dev mode with container support. For an example of how to configure a Dockerfile, see https://github.com/OpenLiberty/ci.docker");
                }
            }
            String logsDirectory = this.serverDirectory.getCanonicalPath() + "/logs";
            final File messagesLogFile = new File(logsDirectory + "/messages.log");
            boolean logsExist = new File(logsDirectory).isDirectory();
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DevUtil.this.container) {
                            DevUtil.this.startContainer();
                        } else {
                            serverTask.execute();
                        }
                    }
                    catch (RuntimeException e) {
                        if (!DevUtil.this.devStop.get()) {
                            PluginExecutionException e2 = DevUtil.this.container ? new PluginExecutionException("An error occurred while running the container: " + e.getMessage(), e) : new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
                            DevUtil.this.error(e2.getMessage());
                            DevUtil.this.serverThreadException = e2;
                        }
                    }
                    catch (PluginExecutionException pe) {
                        DevUtil.this.error(pe.getMessage());
                        DevUtil.this.serverThreadException = pe;
                    }
                }
            });
            this.serverThread.start();
            this.setDevStop(false);
            if (logsExist) {
                final AtomicBoolean messagesModified = new AtomicBoolean(false);
                FileFilter singleFileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        block3: {
                            try {
                                if (file.getCanonicalFile().equals(messagesLogFile.getCanonicalFile())) {
                                    return true;
                                }
                            }
                            catch (IOException e) {
                                if (!file.equals(messagesLogFile)) break block3;
                                return true;
                            }
                        }
                        return false;
                    }
                };
                FileAlterationObserver observer = new FileAlterationObserver(logsDirectory, singleFileFilter);
                observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

                    public void onFileCreate(File file) {
                        messagesModified.set(true);
                    }

                    public void onFileChange(File file) {
                        messagesModified.set(true);
                    }
                });
                try {
                    observer.initialize();
                    while (!messagesModified.get()) {
                        this.checkStopDevMode(false);
                        observer.checkAndNotify();
                        Thread.sleep(500L);
                    }
                    this.debug("messages.log has been changed");
                }
                catch (PluginScenarioException e) {
                    if (this.serverThreadException != null) {
                        throw this.serverThreadException;
                    }
                    throw new PluginExecutionException(e);
                }
                catch (Exception e) {
                    this.error("An error occurred while waiting for the server to update messages.log: " + e.getMessage(), e);
                }
                finally {
                    try {
                        observer.destroy();
                    }
                    catch (Exception e) {
                        this.debug("Could not destroy FileAlterationObserver for logs directory " + logsDirectory, e);
                    }
                }
            } else {
                try {
                    while (!messagesLogFile.exists()) {
                        this.checkStopDevMode(false);
                        Thread.sleep(500L);
                    }
                    this.debug("messages.log has been created");
                }
                catch (PluginScenarioException e) {
                    if (this.serverThreadException != null) {
                        throw this.serverThreadException;
                    }
                    throw new PluginExecutionException(e);
                }
                catch (Exception e) {
                    this.error("An error occurred while waiting for the server to create messages.log: " + e.getMessage(), e);
                }
            }
            if (this.serverStartTimeout < 0L) {
                this.warn("The serverStartTimeout value needs to be an integer greater than or equal to 0.  The default value of 90 seconds will be used.");
                this.serverStartTimeout = 90L;
            }
            if ((startMessage = serverTask.waitForStringInLog(START_SERVER_MESSAGE_PREFIX, serverStartTimeoutMillis = this.serverStartTimeout * 1000L, messagesLogFile)) == null) {
                this.setDevStop(true);
                if (this.container) {
                    this.stopContainer();
                } else {
                    this.stopServer();
                }
                throw new PluginExecutionException("The server has not started within " + this.serverStartTimeout + " seconds. Consider increasing the server start timeout if this continues to occur. For example, " + this.getServerStartTimeoutExample());
            }
            this.serverFullyStarted.set(true);
            String portError = serverTask.findStringInFile(PORT_IN_USE_MESSAGE_PREFIX, messagesLogFile);
            if (portError != null) {
                this.error(portError.split(PORT_IN_USE_MESSAGE_PREFIX)[1]);
            }
            this.parseHostNameAndPorts(serverTask, messagesLogFile);
        }
        catch (IOException e) {
            throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
        }
    }

    private File getContainerfile() {
        return this.containerfile != null ? this.containerfile : this.defaultContainerfile;
    }

    protected List<String> readContainerfile(File containerfile) throws PluginExecutionException {
        List<String> containerfileLines = null;
        try {
            containerfileLines = Files.readAllLines(containerfile.toPath());
        }
        catch (IOException e) {
            this.error("Failed to read Containerfile located at " + containerfile);
            throw new PluginExecutionException("Could not read Containerfile " + containerfile + ": " + e.getMessage(), e);
        }
        return containerfileLines;
    }

    protected static char getEscapeCharacter(List<String> containerfileLines) throws PluginExecutionException {
        String escapeChar;
        String contentAfterSymbol;
        String directive;
        String[] split;
        String pendingLine;
        int directiveSymbolIndex;
        if (containerfileLines.size() > 0 && (directiveSymbolIndex = (pendingLine = containerfileLines.get(0).trim()).indexOf("#")) >= 0 && (split = (directive = (contentAfterSymbol = pendingLine.substring(directiveSymbolIndex + 1, pendingLine.length())).trim()).split("=")).length == 2 && split[0].trim().equalsIgnoreCase("escape") && (escapeChar = split[1].trim()).length() > 0) {
            return escapeChar.charAt(0);
        }
        return '\\';
    }

    protected static List<String> getCleanedLines(List<String> containerfileLines) throws PluginExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        boolean fromFound = false;
        for (String line : containerfileLines) {
            int commentIndex;
            String pendingLine = line.trim();
            if (!fromFound) {
                if (pendingLine.startsWith("FROM")) {
                    fromFound = true;
                } else {
                    result.add(pendingLine);
                    continue;
                }
            }
            if ((commentIndex = pendingLine.indexOf("#")) >= 0) {
                String contentBeforeSymbol = pendingLine.substring(0, commentIndex);
                pendingLine = contentBeforeSymbol.trim();
            }
            if (pendingLine.isEmpty()) continue;
            result.add(pendingLine);
        }
        return result;
    }

    protected static List<String> getCombinedLines(List<String> containerfileLines, char escape) throws PluginExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < containerfileLines.size()) {
            int j;
            String pendingLine = containerfileLines.get(i).trim();
            for (j = i + 1; pendingLine.length() > 0 && !pendingLine.startsWith("#") && pendingLine.charAt(pendingLine.length() - 1) == escape && j < containerfileLines.size(); ++j) {
                int multilineIndex = pendingLine.length() - 1;
                String contentBeforeSymbol = pendingLine.substring(0, multilineIndex);
                String nextLine = containerfileLines.get(j);
                String combined = contentBeforeSymbol + nextLine;
                pendingLine = combined.trim();
            }
            result.add(pendingLine);
            i = j;
        }
        return result;
    }

    protected void removeWarFileLines(List<String> containerfileLines) throws PluginExecutionException {
        this.removeFileExtensionLines(containerfileLines, ".war");
    }

    protected void removeEarFileLines(List<String> containerfileLines) throws PluginExecutionException {
        this.removeFileExtensionLines(containerfileLines, ".ear");
    }

    private void removeFileExtensionLines(List<String> containerfileLines, String extension) throws PluginExecutionException {
        ArrayList<String> fileExtensionLines = new ArrayList<String>();
        for (String line : containerfileLines) {
            String[] cmdSegments;
            String trimLine = line.trim();
            if (trimLine.startsWith("#") || !trimLine.toLowerCase().contains(extension) || !(cmdSegments = trimLine.split("#")[0].split("\\s+"))[0].equalsIgnoreCase("COPY") && !cmdSegments[0].equalsIgnoreCase("ADD")) continue;
            if (cmdSegments.length < 3) {
                throw new PluginExecutionException("Incorrect syntax on this line in the Containerfile: '" + line + "'. There must be at least two arguments for the COPY or ADD command, a source path and a destination path.");
            }
            if (!cmdSegments[cmdSegments.length - 2].toLowerCase().endsWith(extension)) continue;
            fileExtensionLines.add(line);
        }
        this.debug(extension + " file lines: " + ((Object)fileExtensionLines).toString());
        containerfileLines.removeAll(fileExtensionLines);
    }

    protected void disableOpenJ9SCC(List<String> containerfileLines) {
        String RUN_CONFIGURE_COMMAND_LOWERCASE = "run configure.sh";
        for (int i = 0; i < containerfileLines.size(); ++i) {
            String line = containerfileLines.get(i);
            if (!line.toLowerCase().equals("run configure.sh")) continue;
            this.debug("Detected RUN configure.sh command.  Skipping OpenJ9 Shared Class Cache.");
            containerfileLines.add(i, "ENV OPENJ9_SCC=false");
            return;
        }
    }

    protected void detectFeaturesSh(List<String> containerfileLines) {
        this.shownFeaturesShWarning.set(false);
        String FEATURES_SH_COMMAND_LOWERCASE = "run features.sh";
        for (int i = 0; i < containerfileLines.size(); ++i) {
            String line = containerfileLines.get(i);
            if (!line.toLowerCase().equals("run features.sh")) continue;
            this.debug("Detected RUN features.sh command.");
            this.hasFeaturesSh.set(true);
            return;
        }
        this.debug("Did not find RUN features.sh command.");
        this.hasFeaturesSh.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCopyLines(List<String> containerfileLines, String buildContext) throws PluginExecutionException {
        this.srcMount.clear();
        this.destMount.clear();
        for (String line : containerfileLines) {
            String[] cmdSegments;
            String trimLine = line.trim();
            if (trimLine.startsWith("#") || !(cmdSegments = trimLine.split("#")[0].split("\\s+"))[0].equalsIgnoreCase("COPY") && !cmdSegments[0].equalsIgnoreCase("ADD")) continue;
            if (cmdSegments.length < 3) {
                throw new PluginExecutionException("Incorrect syntax on this line in the Containerfile: '" + line + "'. There must be at least two arguments for the COPY or ADD command, a source path and a destination path.");
            }
            if (line.contains("$")) {
                this.warn("The Containerfile line '" + line + "' will not be able to be hot deployed to the dev mode container. Dev mode does not currently support environment variables in COPY or ADD commands. If you make changes to files specified by this line, type 'r' and press Enter to rebuild the container image and restart the container.");
                continue;
            }
            ArrayList<String> srcOrDestArguments = new ArrayList<String>();
            boolean skipLine = false;
            for (int i = 1; i < cmdSegments.length; ++i) {
                String segment = cmdSegments[i];
                if (segment.startsWith("--from")) {
                    this.warn("The Containerfile line '" + line + "' will not be able to be hot deployed to the dev mode container. Dev mode does not currently support hot deployment with multi-stage COPY commands.");
                    skipLine = true;
                    break;
                }
                if (segment.startsWith("--")) continue;
                srcOrDestArguments.add(segment);
            }
            if (skipLine) continue;
            if (srcOrDestArguments.size() < 2) {
                throw new PluginExecutionException("Incorrect syntax on this line in the Containerfile: '" + line + "'. There must be at least two arguments for the COPY or ADD command, a source path and a destination path.");
            }
            String dest = (String)srcOrDestArguments.get(srcOrDestArguments.size() - 1);
            List srcArguments = srcOrDestArguments.subList(0, srcOrDestArguments.size() - 1);
            for (String src : srcArguments) {
                if (this.isURL(src)) {
                    this.debug("COPY/ADD do not watch/mount URL:" + src);
                    continue;
                }
                String sourcePath = buildContext + "/" + src;
                File sourceFile = new File(sourcePath);
                if (src.contains("*") || src.contains("?")) {
                    this.warn("The COPY or ADD source " + src + " in the Containerfile line '" + line + "' will not be able to be hot deployed to the dev mode container. Dev mode does not currently support wildcards in the COPY or ADD commands. If you make changes to files specified by this line, type 'r' and press Enter to rebuild the container image and restart the container.");
                    continue;
                }
                if (sourceFile.isDirectory() || cmdSegments[0].equalsIgnoreCase("ADD")) {
                    Set<Path> set = this.containerfileDirectoriesToWatch;
                    synchronized (set) {
                        try {
                            this.containerfileDirectoriesToWatch.add(sourceFile.getCanonicalFile().toPath());
                            this.debug("COPY/ADD line=" + line + ", src=" + sourcePath + ", added to containerfileDirectoriesToWatch: " + sourceFile);
                        }
                        catch (IOException e) {
                            this.error("Could not resolve the canonical path of the directory specified in the Containerfile: " + sourcePath, e);
                        }
                        continue;
                    }
                }
                String destMountString = this.formatDestMount(dest, sourceFile);
                this.srcMount.add(sourcePath);
                this.destMount.add(destMountString);
                this.debug("COPY line=" + line + ", src=" + sourcePath + ", dest=" + destMountString);
            }
        }
    }

    protected abstract void updateLooseApp() throws PluginExecutionException;

    private String formatDestMount(String destMountString, File srcMountFile) {
        if (destMountString.endsWith("/") || destMountString.endsWith("\\")) {
            destMountString = destMountString + srcMountFile.getName();
        }
        return destMountString;
    }

    private boolean isURL(String name) {
        try {
            URL uRL = new URL(name);
        }
        catch (MalformedURLException m) {
            return false;
        }
        return true;
    }

    protected File prepareTempContainerfile(File containerfile, String buildContextString) throws PluginExecutionException {
        List<String> containerfileLines = this.readContainerfile(containerfile);
        char escape = DevUtil.getEscapeCharacter(containerfileLines);
        containerfileLines = DevUtil.getCleanedLines(containerfileLines);
        containerfileLines = DevUtil.getCombinedLines(containerfileLines, escape);
        this.removeWarFileLines(containerfileLines);
        this.removeEarFileLines(containerfileLines);
        this.processCopyLines(containerfileLines, buildContextString);
        this.detectFeaturesSh(containerfileLines);
        this.disableOpenJ9SCC(containerfileLines);
        for (String line : containerfileLines) {
            this.debug(line);
        }
        File tempContainerfile = null;
        try {
            this.debug("Creating temp Containerfile...");
            File devcHiddenFolder = new File(this.buildDirectory, DEVC_HIDDEN_FOLDER);
            devcHiddenFolder.mkdirs();
            tempContainerfile = File.createTempFile("tempContainerfile", "", devcHiddenFolder);
            this.debug("temp Containerfile: " + tempContainerfile);
            this.tempContainerfilePath = tempContainerfile.toPath();
            if (this.keepTempContainerfile) {
                this.info("Keeping temporary Containerfile: " + this.tempContainerfilePath);
            } else {
                tempContainerfile.deleteOnExit();
            }
            Files.write(tempContainerfile.toPath(), containerfileLines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            this.error("Failed to create temp Containerfile");
            throw new PluginExecutionException("Could not create temp Containerfile: " + e.getMessage(), e);
        }
        return tempContainerfile;
    }

    private void buildContainerImage(File tempContainerfile, File userContainerfile, boolean pullParentImage, File buildContext) throws PluginExecutionException {
        this.info("Building container image...");
        try {
            this.imageName = this.getProjectName() + DEVMODE_IMAGE_SUFFIX;
            this.imageName = this.imageName.replaceAll("[^a-zA-Z0-9]", "-").replaceAll("^[\\-]+", "").toLowerCase();
            ArrayList<String> commandElements = new ArrayList<String>();
            commandElements.add(this.getContainerCommandPrefix().trim());
            commandElements.add("build");
            if (pullParentImage) {
                commandElements.add("--pull");
            }
            commandElements.add("-f");
            commandElements.add(tempContainerfile.getAbsolutePath());
            commandElements.add("-t");
            commandElements.add(this.imageName);
            commandElements.add(buildContext.getAbsolutePath());
            CharSequence[] newCommand = commandElements.toArray(new String[commandElements.size()]);
            this.info("Container command: " + String.join((CharSequence)" ", newCommand));
            if (this.hasFeaturesSh.get()) {
                this.info("The RUN features.sh command is detected in the Containerfile and extra time may be necessary when installing features.");
            }
            long startTime = System.currentTimeMillis();
            this.execContainerCmdAndLog(this.getRunProcess((String[])newCommand), this.containerBuildTimeout, false);
            this.checkContainerBuildTime(startTime, buildContext);
            this.info("Completed building container image.");
        }
        catch (IllegalThreadStateException e) {
            this.debug("IllegalThreadStateException, message=" + e.getMessage());
            throw new PluginExecutionException("The container build command did not complete within the timeout period: " + this.containerBuildTimeout + " seconds. Use the containerBuildTimeout option to specify a longer period or add files not needed in the container to the .containerignore file", e);
        }
        catch (IOException e) {
            this.error("Input or output error building container image: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            this.debug("Thread InterruptedException while building the container image: " + e.getMessage());
            throw new PluginExecutionException("Could not build container image using Containerfile: " + userContainerfile.getAbsolutePath() + ". Address the following container build error and then start dev mode again: " + e.getMessage(), e);
        }
        catch (RuntimeException r) {
            this.debug("RuntimeException building container image: " + r.getMessage());
            throw new PluginExecutionException("Could not build container image using Containerfile: " + userContainerfile.getAbsolutePath() + ". Address the following container build error and then start dev mode again: " + r.getMessage(), r);
        }
    }

    private void checkContainerBuildTime(long startTime, File containerBuildContext) {
        if (System.currentTimeMillis() - startTime < 30000L) {
            return;
        }
        this.debug("checkContainerBuildTime, containerBuildContext=" + containerBuildContext.getAbsolutePath());
        File dockerIgnore = new File(containerBuildContext, ".dockerignore");
        if (!dockerIgnore.exists()) {
            String buildContextPath;
            try {
                buildContextPath = containerBuildContext.getCanonicalPath();
            }
            catch (IOException e) {
                buildContextPath = containerBuildContext.getAbsolutePath();
            }
            this.warn("The container build command took longer than 30 seconds. You may increase performance by adding unneeded files and directories such as any Liberty runtime directories to a .dockerignore file in " + buildContextPath + ".");
        }
    }

    private void startContainer() throws PluginExecutionException {
        try {
            new File(this.serverDirectory, "logs").mkdirs();
            new File(this.buildDirectory, ".libertyDevc/apps").mkdirs();
            new File(this.buildDirectory, ".libertyDevc/dropins").mkdirs();
            this.info("Starting container...");
            String[] startContainerCommand = this.getContainerCommand();
            this.containerRunProcess = this.getRunProcess(startContainerCommand);
            this.execContainerCmdAndLog(this.containerRunProcess, 0, true);
        }
        catch (IOException e) {
            this.error("Error starting container: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            this.error("Thread was interrupted while starting the container: " + e.getMessage());
        }
        catch (RuntimeException r) {
            try {
                String containerRmCmd = "container rm " + this.containerName;
                this.execContainerCmdWithPrefix(containerRmCmd, 20);
            }
            catch (Exception e) {
                this.debug("Exception running container command rm:", e);
            }
            throw r;
        }
    }

    private Process getRunProcess(String[] command) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        Map<String, String> env = processBuilder.environment();
        if (!OSUtil.isLinux() && !env.keySet().contains("DOCKER_BUILDKIT")) {
            env.put("DOCKER_BUILDKIT", "0");
            this.debug("Generating environment for docker build & run: DOCKER_BUILDKIT=0");
        }
        if (!env.keySet().contains("DOCKER_SCAN_SUGGEST")) {
            env.put("DOCKER_SCAN_SUGGEST", "false");
            this.debug("Generating environment for docker build & run: DOCKER_SCAN_SUGGEST=false");
        }
        return processBuilder.start();
    }

    private void execContainerCmdAndLog(final Process startingProcess, int timeout, boolean isStartCommand) throws InterruptedException {
        Thread logCopyInputThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DevUtil.this.copyStreamToBuildLog(startingProcess.getInputStream(), true);
            }
        });
        logCopyInputThread.start();
        final StringBuilder firstErrorLine = new StringBuilder();
        Thread logCopyErrorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (OSUtil.isLinux() && !DevUtil.this.isDocker) {
                    firstErrorLine.append(DevUtil.this.copyStreamToBuildLog(startingProcess.getErrorStream(), true));
                } else {
                    firstErrorLine.append(DevUtil.this.copyStreamToBuildLog(startingProcess.getErrorStream(), false));
                }
            }
        });
        logCopyErrorThread.start();
        if (isStartCommand) {
            this.writeDevcMetadata(true);
        }
        if (timeout == 0) {
            startingProcess.waitFor();
        } else {
            startingProcess.waitFor(timeout, TimeUnit.SECONDS);
        }
        if (startingProcess.exitValue() != 0 && !this.devStop.get()) {
            if (startingProcess.exitValue() == 143) {
                this.setDevStop(true);
                this.externalContainerShutdown.set(true);
            }
            this.debug("Unexpected exit running container command, return value=" + startingProcess.exitValue());
            String errorMessage = new String(firstErrorLine).trim() + " RC=" + startingProcess.exitValue();
            if (isStartCommand) {
                this.writeDevcMetadata(false);
            }
            throw new RuntimeException(errorMessage);
        }
    }

    private String runCmd(String cmd) throws IOException, InterruptedException {
        String result = null;
        Process p = Runtime.getRuntime().exec(cmd);
        p.waitFor(5L, TimeUnit.SECONDS);
        if (p.exitValue() != 0) {
            this.error("Error running command:" + cmd + ", return value=" + p.exitValue());
        } else {
            result = this.readStdOut(p);
        }
        return result;
    }

    private String copyStreamToBuildLog(InputStream stream, boolean info) {
        String firstLine = null;
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line;
            while ((line = inputReader.readLine()) != null) {
                if (firstLine == null) {
                    firstLine = line;
                }
                if (info) {
                    this.info(line);
                    continue;
                }
                this.error(line);
                this.alertOnServerError(line, "JVMCFRE003", "Java classes were compiled with a higher version of Java than the JVM in the container. To resolve this issue, set the source and target Java versions in your Gradle build to correspond to the Java version used in your Containerfile/Dockerfile or its parent image, then restart dev mode.", "Java classes were compiled with a higher version of Java than the JVM in the container. To resolve this issue, set the source and target Java versions in your Maven build to correspond to the Java version used in your Containerfile/Dockerfile or its parent image, then clean the project output and restart dev mode.", false);
                if (this.serverFullyStarted.get() || this.hasFeaturesSh.get() || this.shownFeaturesShWarning.get()) continue;
                String errMsg = "Feature definitions were not found in the container. To install features to the container, specify 'RUN features.sh' in your Containerfile/Dockerfile. For an example of how to configure a Containerfile/Dockerfile, see https://github.com/OpenLiberty/ci.docker";
                this.shownFeaturesShWarning.set(this.alertOnServerError(line, "CWWKF0001E", errMsg, errMsg, true));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading container output: " + e.getMessage());
        }
        finally {
            try {
                inputReader.close();
            }
            catch (IOException iOException) {}
        }
        return firstLine;
    }

    private boolean alertOnServerError(String line, String errorCode, String gradleMessage, String mavenMessage, boolean warning) {
        if (this.container && line.contains(errorCode)) {
            if (this.gradle) {
                if (warning) {
                    this.warn("***** [ WARNING ] ***** " + gradleMessage);
                } else {
                    this.error("***** [ ERROR ] ***** " + gradleMessage);
                }
            } else if (warning) {
                this.warn(mavenMessage);
            } else {
                this.error(mavenMessage);
            }
            return true;
        }
        return false;
    }

    protected void addContainerRunOpts(String runOpts, List<String> commandElements) {
        String[] opts = this.getCommandTokens(runOpts);
        for (int index = 0; index < opts.length; ++index) {
            if (index == 0 || opts[index].startsWith("-")) {
                commandElements.add(opts[index]);
                continue;
            }
            String lastListElement = commandElements.get(commandElements.size() - 1);
            if (!lastListElement.startsWith("-")) {
                commandElements.set(commandElements.size() - 1, lastListElement + " " + opts[index]);
                continue;
            }
            commandElements.add(opts[index]);
        }
    }

    protected String[] getCommandTokens(String command) {
        StringTokenizer stringTokenizer = new StringTokenizer(command);
        String[] commandTokens = new String[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            commandTokens[i] = stringTokenizer.nextToken();
            ++i;
        }
        return commandTokens;
    }

    private void stopContainer() throws PluginExecutionException {
        try {
            this.serverFullyStarted.set(false);
            if (this.containerRunProcess != null && this.containerRunProcess.isAlive()) {
                this.info("Stopping container...");
                String containerStopCmd = "stop " + this.containerName;
                this.debug("Stopping container " + this.containerName);
                this.execContainerCmdWithPrefix(containerStopCmd, 40);
                this.writeDevcMetadata(false);
            }
        }
        catch (RuntimeException r) {
            this.error("Error stopping container: " + r.getMessage());
            throw r;
        }
        finally {
            this.containerRunProcess = null;
        }
    }

    public static File getLooseAppProjectRoot(File projectDirectory, File multiModuleProjectDirectory) {
        if (multiModuleProjectDirectory == null) {
            return projectDirectory;
        }
        try {
            return DevUtil.getLongestCommonDir(projectDirectory.getCanonicalFile(), multiModuleProjectDirectory.getCanonicalFile());
        }
        catch (IOException e) {
            return DevUtil.getLongestCommonDir(projectDirectory.getAbsoluteFile(), multiModuleProjectDirectory.getAbsoluteFile());
        }
    }

    protected static File getLongestCommonDir(File dir1, File dir2) {
        Path relativePath;
        for (relativePath = dir1.toPath().relativize(dir2.toPath()).normalize(); relativePath != null && !relativePath.endsWith(".."); relativePath = relativePath.getParent()) {
        }
        if (relativePath == null || relativePath.toString().isEmpty()) {
            return dir1;
        }
        return dir1.toPath().resolve(relativePath).normalize().toFile();
    }

    private String[] getContainerCommand() throws IOException, PluginExecutionException {
        ArrayList<String> commandElements = new ArrayList<String>();
        commandElements.add(this.getContainerCommandPrefix().trim());
        commandElements.add("run");
        commandElements.add("--rm");
        if (!this.skipDefaultPorts) {
            int httpsPortToUse;
            int httpPortToUse;
            try {
                httpPortToUse = this.findAvailablePort(9080, false);
                httpsPortToUse = this.findAvailablePort(9443, false);
            }
            catch (IOException x) {
                this.error("An error occurred while trying to find an available network port. Using default port numbers.", x);
                httpPortToUse = 9080;
                httpsPortToUse = 9443;
            }
            commandElements.add("-p");
            commandElements.add(httpPortToUse + ":" + 9080);
            commandElements.add("-p");
            commandElements.add(httpsPortToUse + ":" + 9443);
        }
        if (this.libertyDebug) {
            int containerDebugPort;
            int hostDebugPort;
            try {
                if (this.alternativeDebugPort == -1) {
                    hostDebugPort = this.findAvailablePort(this.libertyDebugPort, true);
                    containerDebugPort = this.libertyDebugPort;
                } else {
                    containerDebugPort = hostDebugPort = this.alternativeDebugPort;
                }
            }
            catch (IOException x) {
                containerDebugPort = hostDebugPort = this.libertyDebugPort;
            }
            commandElements.add("-p");
            commandElements.add(hostDebugPort + ":" + containerDebugPort);
            commandElements.add("-e");
            commandElements.add("WLP_DEBUG_SUSPEND=n");
            commandElements.add("-e");
            commandElements.add("WLP_DEBUG_ADDRESS=" + containerDebugPort);
            commandElements.add("-e");
            commandElements.add("WLP_DEBUG_REMOTE=y");
        }
        File tempApps = new File(this.buildDirectory, ".libertyDevc/apps");
        File tempDropins = new File(this.buildDirectory, ".libertyDevc/dropins");
        commandElements.add("-v");
        commandElements.add(tempApps + ":/config/apps");
        commandElements.add("-v");
        commandElements.add(tempDropins + ":/config/dropins");
        File looseApplicationProjectRoot = DevUtil.getLooseAppProjectRoot(this.projectDirectory, this.multiModuleProjectDirectory);
        commandElements.add("-v");
        commandElements.add(looseApplicationProjectRoot.getAbsolutePath() + ":" + DEVMODE_DIR_NAME);
        File logsDir = new File(this.serverDirectory.getAbsolutePath(), "logs");
        commandElements.add("-v");
        commandElements.add(logsDir + ":/logs");
        commandElements.add("-v");
        commandElements.add(this.mavenCacheLocation + ":/devmode-maven-cache");
        this.addCopiedFiles(commandElements);
        this.addUserId(commandElements);
        String name = this.getContainerOption("--name");
        if (name == null || name.isEmpty()) {
            if (name != null && name.isEmpty()) {
                this.error("The container option --name is specified with an unsupported value: empty string.");
            }
            this.containerName = this.generateNewContainerName();
            commandElements.add("--name");
            commandElements.add(this.containerName);
        } else {
            this.containerName = name;
        }
        this.debug("containerName: " + this.containerName + ".");
        if (this.containerRunOpts != null) {
            this.addContainerRunOpts(this.containerRunOpts, commandElements);
        }
        commandElements.add(this.imageName);
        commandElements.add("server");
        if (this.libertyDebug) {
            commandElements.add("debug");
        } else {
            commandElements.add("run");
        }
        commandElements.add("defaultServer");
        commandElements.add("--");
        commandElements.add("--io.openliberty.tools.projectRoot=/devmode");
        CharSequence[] newCommand = commandElements.toArray(new String[commandElements.size()]);
        this.info("Container command: " + String.join((CharSequence)" ", newCommand));
        return newCommand;
    }

    private String getContainerOption(String optionName) {
        if (this.containerRunOpts == null || this.containerRunOpts.isEmpty()) {
            return null;
        }
        String[] options = this.containerRunOpts.split("\\s+");
        for (int i = 0; i < options.length; ++i) {
            if (options[i].equals(optionName)) {
                return i < options.length - 1 ? options[i + 1] : null;
            }
            if (!options[i].startsWith(optionName + "=")) continue;
            return options[i].substring(optionName.length() + 1);
        }
        return null;
    }

    private String generateNewContainerName() throws PluginExecutionException {
        String containerContNamesCmd = "ps -a --format \"{{.Names}}\"";
        this.debug("container names list command: " + containerContNamesCmd);
        String result = this.execContainerCmdWithPrefix(containerContNamesCmd, 20);
        if (result == null) {
            return DEVMODE_CONTAINER_BASE_NAME;
        }
        String[] containerNames = result.split(" ");
        int highestNum = -1;
        for (int i = 0; i < containerNames.length; ++i) {
            String[] nameSegments;
            String name = DevUtil.removeSurroundingQuotes(containerNames[i]);
            int num = -1;
            if (name.equals(DEVMODE_CONTAINER_BASE_NAME)) {
                num = 0;
            } else if (name.startsWith("liberty-dev-") && (nameSegments = name.split("-")).length == 3) {
                String lastSegment = nameSegments[nameSegments.length - 1];
                try {
                    num = Integer.parseInt(lastSegment);
                }
                catch (NumberFormatException e) {
                    this.debug("Last segment of container name is not a number.");
                }
            }
            if (num <= highestNum) continue;
            highestNum = num;
        }
        return DEVMODE_CONTAINER_BASE_NAME + (highestNum != -1 ? "-" + ++highestNum : "");
    }

    private String[] getContainerNetworks(String contName) throws PluginExecutionException {
        String containerNetworkCmd = "inspect -f '{{.NetworkSettings.Networks}}' " + contName;
        String cmdResult = this.execContainerCmdWithPrefix(containerNetworkCmd, 20, false);
        if (cmdResult == null || cmdResult.contains(" RC=")) {
            this.warn("Unable to retrieve container networks.");
            return null;
        }
        return DevUtil.parseNetworks(DevUtil.removeSurroundingQuotes(cmdResult.trim()));
    }

    protected static String[] parseNetworks(String containerResult) {
        if (!containerResult.matches("map\\[(.*?)\\]")) {
            return null;
        }
        String networkMap = containerResult.substring(containerResult.indexOf("[") + 1, containerResult.indexOf("]"));
        String[] networkHex = networkMap.split(" ");
        String[] networks = new String[networkHex.length];
        for (int i = 0; i < networkHex.length; ++i) {
            networks[i] = networkHex[i].split(":")[0];
        }
        return networks;
    }

    private String getContainerIPAddress(String contName, String network) throws PluginExecutionException {
        String containerIPAddressCmd = "inspect -f '{{.NetworkSettings.Networks." + network + ".IPAddress}}' " + contName;
        String result = this.execContainerCmdWithPrefix(containerIPAddressCmd, 20, false);
        if (result == null || result.contains(" RC=")) {
            this.warn("Unable to retrieve container IP address for network '" + network + "'.");
            return "<no value>";
        }
        return DevUtil.removeSurroundingQuotes(result.trim());
    }

    protected static String removeSurroundingQuotes(String str) {
        if (str != null && str.length() >= 2 && (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'"))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private void addCopiedFiles(List<String> commandElements) {
        for (int i = 0; i < this.srcMount.size(); ++i) {
            if (new File(this.srcMount.get(i)).exists()) {
                commandElements.add("-v");
                commandElements.add(this.srcMount.get(i) + ":" + this.destMount.get(i));
                continue;
            }
            this.error("A file referenced by the Containerfile is not found: " + this.srcMount.get(i) + ". Update the Containerfile or ensure the file is in the correct location.");
        }
    }

    private void addUserId(List<String> commandElements) {
        if (OSUtil.isLinux() || !this.isDocker) {
            try {
                String id = this.runCmd("id -u");
                if (id != null) {
                    commandElements.add("--user");
                    commandElements.add(id.trim());
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public abstract void libertyCreate() throws PluginExecutionException;

    public abstract void libertyDeploy() throws PluginExecutionException;

    public abstract boolean libertyGenerateFeatures(Collection<String> var1, boolean var2);

    public abstract void libertyInstallFeature() throws PluginExecutionException;

    public void restartServer() throws PluginExecutionException {
        this.restartServer(false);
    }

    public void restartServer(boolean buildContainer) throws PluginExecutionException {
        this.info("Restarting server...");
        this.setDevStop(true);
        if (this.container) {
            this.stopContainer();
        } else {
            this.stopServer();
            if (this.serverThread != null) {
                long threadShutdownTimeoutSeconds = 30L;
                try {
                    this.serverThread.join(30000L);
                    if (this.serverThread.isAlive()) {
                        throw new PluginExecutionException("Could not stop the server after 30 seconds.  Ensure that the server has been stopped, then start dev mode again.");
                    }
                }
                catch (InterruptedException e) {
                    if (this.serverThread.isAlive()) {
                        throw new PluginExecutionException("Could not stop the server.  Ensure that the server has been stopped, then start dev mode again.", e);
                    }
                    this.debug(e);
                }
            }
        }
        System.setProperty(SKIP_BETA_INSTALL_WARNING, Boolean.TRUE.toString());
        this.libertyCreate();
        if (!this.container && !this.skipInstallFeature) {
            this.libertyInstallFeature();
        } else if (this.skipInstallFeature) {
            this.info("Skipping installation of features due to skipInstallFeature configuration.");
        }
        this.libertyDeploy();
        this.startServer(buildContainer, false);
        this.setDevStop(false);
        this.info("The server has been restarted.");
        this.printDevModeMessages(this.inputUnavailable.get(), true);
    }

    private void parseHostNameAndPorts(ServerTask serverTask, File messagesLogFile) throws PluginExecutionException {
        List listeningOnPortMessages;
        String webAppMessage = serverTask.findStringInFile(WEB_APP_AVAILABLE_MESSAGE_PREFIX, messagesLogFile);
        this.debug("Web app available message: " + webAppMessage);
        if (webAppMessage != null) {
            int portPrefixIndex = this.parseHostName(webAppMessage);
            this.parseHttpPort(webAppMessage, portPrefixIndex);
        }
        if ((listeningOnPortMessages = serverTask.findStringsInFile(LISTENING_ON_PORT_MESSAGE_PREFIX, messagesLogFile)) != null) {
            this.parseHttpsPort(listeningOnPortMessages);
        }
    }

    protected int parseHostName(String webAppMessage) throws PluginExecutionException {
        int protocolIndex = webAppMessage.indexOf(HTTP_PREFIX);
        int hostNameIndex = protocolIndex + HTTP_PREFIX.length();
        if (protocolIndex < 0) {
            protocolIndex = webAppMessage.indexOf(HTTP_PREFIX_ESCAPED);
            hostNameIndex = protocolIndex + HTTP_PREFIX_ESCAPED.length();
        }
        if (protocolIndex < 0) {
            protocolIndex = webAppMessage.indexOf(HTTPS_PREFIX);
            hostNameIndex = protocolIndex + HTTPS_PREFIX.length();
        }
        if (protocolIndex < 0) {
            protocolIndex = webAppMessage.indexOf(HTTPS_PREFIX_ESCAPED);
            hostNameIndex = protocolIndex + HTTPS_PREFIX_ESCAPED.length();
        }
        if (protocolIndex < 0) {
            throw new PluginExecutionException("Could not parse the host name from the log message: " + webAppMessage);
        }
        int portPrefixIndex = webAppMessage.indexOf(":", hostNameIndex);
        if (portPrefixIndex < 0) {
            throw new PluginExecutionException("Could not parse the port number from the log message: " + webAppMessage);
        }
        this.hostName = this.container ? "localhost" : webAppMessage.substring(hostNameIndex, portPrefixIndex);
        this.debug("Parsed host name: " + this.hostName);
        return portPrefixIndex;
    }

    protected void parseHttpPort(String webAppMessage, int portPrefixIndex) throws PluginExecutionException {
        if (!webAppMessage.contains(HTTP_PREFIX)) {
            return;
        }
        int portIndex = portPrefixIndex + 1;
        int portEndIndex = webAppMessage.indexOf("/", portIndex);
        if (portEndIndex < 0) {
            portEndIndex = webAppMessage.length();
        }
        String parsedHttpPort = webAppMessage.substring(portIndex, portEndIndex);
        this.debug("Parsed http port: " + parsedHttpPort);
        if (this.container) {
            this.httpPort = this.findLocalPort(parsedHttpPort);
            this.containerHttpPort = parsedHttpPort;
        } else {
            this.httpPort = parsedHttpPort;
        }
    }

    protected void parseHttpsPort(List<String> messages) throws PluginExecutionException {
        for (String message : messages) {
            String[] messageTokens;
            this.debug("Looking for https port in message: " + message);
            String httpsMessageContents = message.split(LISTENING_ON_PORT_MESSAGE_PREFIX)[1];
            for (String token : messageTokens = httpsMessageContents.split(" ")) {
                if (!token.contains("-ssl")) continue;
                String parsedHttpsPort = this.getPortFromMessageTokens(messageTokens);
                if (parsedHttpsPort != null) {
                    this.debug("Parsed https port: " + parsedHttpsPort);
                    if (this.container) {
                        this.httpsPort = this.findLocalPort(parsedHttpsPort);
                        this.containerHttpsPort = parsedHttpsPort;
                    } else {
                        this.httpsPort = parsedHttpsPort;
                    }
                    return;
                }
                throw new PluginExecutionException("Could not parse the https port number from the log message: " + message);
            }
        }
        this.debug("Could not find https port. The server might not be configured for https.");
    }

    private String getPortFromMessageTokens(String[] messageTokens) throws PluginExecutionException {
        for (int i = messageTokens.length - 1; i >= 0; --i) {
            String numericToken = messageTokens[i].replaceAll("[^\\d]", "");
            if (numericToken.length() <= 0) continue;
            try {
                int parsedPort = Integer.parseInt(numericToken);
                if (parsedPort > 65535) continue;
                return numericToken;
            }
            catch (NumberFormatException e) {
                this.debug("Could not parse integer from numeric token " + numericToken + " from message token " + messageTokens[i], e);
            }
        }
        return null;
    }

    private String findLocalPort(String internalContainerPort) throws PluginExecutionException {
        String containerPortCmd = "port " + this.containerName + " " + internalContainerPort;
        String cmdResult = this.execContainerCmdWithPrefix(containerPortCmd, 20, false);
        if (cmdResult == null) {
            this.warn("Unable to retrieve locally mapped port.");
            return null;
        }
        if (cmdResult.contains(" RC=")) {
            this.warn("Unable to retrieve locally mapped port. Container result: \"" + cmdResult.split(" RC=")[0] + "\". Ensure the container ports are mapped correctly.");
            return null;
        }
        String[] cmdResultSplit = cmdResult.split(":");
        String localPort = cmdResultSplit[cmdResultSplit.length - 1].trim();
        this.debug("Local port: " + localPort);
        return localPort;
    }

    public void cleanUpServerEnv() {
        block5: {
            try {
                File serverEnvBackup = new File(this.serverDirectory.getCanonicalPath() + "/server.env.bak");
                File serverEnvFile = new File(this.serverDirectory.getCanonicalPath() + "/server.env");
                if (serverEnvBackup.exists()) {
                    try {
                        Files.copy(serverEnvBackup.toPath(), serverEnvFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.error("Could not restore server.env: " + e.getMessage());
                    }
                    serverEnvBackup.delete();
                    break block5;
                }
                serverEnvFile.delete();
            }
            catch (IOException e) {
                this.error("Could not retrieve server.env: " + e.getMessage());
            }
        }
    }

    public void cleanUpTempConfig() {
        File tempConfig;
        if (this.tempConfigPath != null && (tempConfig = this.tempConfigPath.toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)tempConfig);
                this.debug("Successfully deleted liberty:dev temporary configuration folder");
            }
            catch (IOException e) {
                this.warn("Could not delete liberty:dev temporary configuration folder: " + e.getMessage());
            }
        }
    }

    public void cleanUpTempContainerfile() {
        File tempContainerfile;
        if (!this.keepTempContainerfile && this.tempContainerfilePath != null && (tempContainerfile = this.tempContainerfilePath.toFile()).exists()) {
            try {
                Files.delete(this.tempContainerfilePath);
                this.debug("Successfully deleted dev mode temporary Containernerfile");
            }
            catch (IOException e) {
                this.warn("Could not delete dev mode temporary Containerfile: " + e.getMessage());
            }
        }
    }

    public void setDevStop(boolean devStop) {
        this.devStop.set(devStop);
    }

    public void addShutdownHook(final ThreadPoolExecutor executor) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DevUtil.this.runShutdownHook(executor);
            }
        });
    }

    private void runShutdownHook(ThreadPoolExecutor executor) {
        try {
            if (!this.calledShutdownHook.getAndSet(true)) {
                if (this.trackingMode == FileTrackMode.POLLING || this.trackingMode == FileTrackMode.NOT_SET) {
                    this.disablePolling();
                }
                this.setDevStop(true);
                this.cleanUpTempConfig();
                this.cleanUpServerEnv();
                if (this.hotkeyReader != null) {
                    this.hotkeyReader.shutdown();
                }
                executor.shutdown();
                if (this.container) {
                    this.cleanUpTempContainerfile();
                    this.stopContainer();
                } else {
                    this.stopServer();
                }
            }
        }
        catch (PluginExecutionException pe) {
            this.error("Exception during container shutdown. Container may have shutdown incorrectly. " + pe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disablePolling() {
        Set<FileAlterationObserver> set = this.newFileObservers;
        synchronized (set) {
            this.consolidateFileObservers();
            for (FileAlterationObserver observer : this.fileObservers) {
                try {
                    observer.destroy();
                }
                catch (Exception e) {
                    this.debug("Could not destroy file observer", e);
                }
            }
        }
    }

    public Map<String, String> getDebugEnvironmentVariables() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("WLP_DEBUG_SUSPEND", "n");
        map.put("WLP_DEBUG_ADDRESS", String.valueOf(this.findAvailablePort(this.libertyDebugPort, true)));
        return map;
    }

    public void enableServerDebug() throws IOException {
        this.enableServerDebug(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableServerDebug(boolean doFindPort) throws IOException {
        if (!this.libertyDebug) {
            return;
        }
        String serverEnvPath = this.serverDirectory.getCanonicalPath() + "/server.env";
        File serverEnvFile = new File(serverEnvPath);
        StringBuilder sb = new StringBuilder();
        File serverEnvBackup = new File(serverEnvPath + ".bak");
        if (serverEnvFile.exists()) {
            this.debug("server.env already exists");
            Files.copy(serverEnvFile.toPath(), serverEnvBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean deleted = serverEnvFile.delete();
            if (!deleted) {
                this.error("Could not move existing server.env file");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(serverEnvBackup));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
        } else {
            serverEnvBackup.delete();
        }
        this.debug("Creating server.env file: " + serverEnvFile.getCanonicalPath());
        sb.append("WLP_DEBUG_SUSPEND=n\n");
        sb.append("WLP_DEBUG_ADDRESS=");
        if (doFindPort) {
            sb.append(this.findAvailablePort(this.libertyDebugPort, true));
        } else {
            sb.append(this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort);
        }
        sb.append("\n");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(serverEnvFile));){
            writer.write(sb.toString());
        }
        if (serverEnvFile.exists()) {
            this.debug("Successfully created liberty:dev server.env file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findAvailablePort(int preferredPort, boolean isDebugPort) throws IOException {
        int portToTry = preferredPort;
        if (isDebugPort && this.alternativeDebugPort != -1) {
            portToTry = this.alternativeDebugPort;
        }
        ServerSocket serverSocket = null;
        while (portToTry < 65535) {
            if (OSUtil.isWindows()) {
                try {
                    serverSocket = new ServerSocket(portToTry);
                    int n = serverSocket.getLocalPort();
                    return n;
                }
                catch (IOException e) {
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                    if (isDebugPort) {
                        serverSocket = new ServerSocket(0);
                        int availablePort = serverSocket.getLocalPort();
                        this.processAvailableDebugPort(preferredPort, portToTry, availablePort);
                        int n = availablePort;
                        return n;
                    }
                    this.debug("findAvailablePort found port is in use: " + portToTry);
                    ++portToTry;
                    continue;
                }
                finally {
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                    continue;
                }
            }
            try {
                serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(false);
                serverSocket.bind(new InetSocketAddress(InetAddress.getByName(null), portToTry), 1);
                int e = serverSocket.getLocalPort();
                return e;
            }
            catch (IOException e) {
                if (serverSocket != null) {
                    if (isDebugPort) {
                        serverSocket.bind(null, 1);
                        int availablePort = serverSocket.getLocalPort();
                        this.processAvailableDebugPort(preferredPort, portToTry, availablePort);
                        int n = availablePort;
                        return n;
                    }
                    this.debug("findAvailablePort found port is in use: " + portToTry);
                    ++portToTry;
                    continue;
                }
                throw new IOException("Could not create a server socket.", e);
            }
            finally {
                if (serverSocket == null) continue;
                serverSocket.close();
            }
        }
        return preferredPort;
    }

    private void processAvailableDebugPort(int preferredPort, int portToTry, int availablePort) {
        if (portToTry == preferredPort) {
            this.warn("The debug port " + preferredPort + " is not available.  Using " + availablePort + " as the debug port instead.");
        } else {
            this.debug("The previous debug port " + this.alternativeDebugPort + " is no longer available.  Using " + availablePort + " as the debug port instead.");
        }
        this.alternativeDebugPort = availablePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHotkeyReaderThread(ThreadPoolExecutor executor) {
        if (this.inputUnavailable.get()) {
            return;
        }
        boolean startedNewHotkeyReader = false;
        if (this.hotkeyReader == null) {
            this.hotkeyReader = new HotkeyReader(executor);
            new Thread(this.hotkeyReader).start();
            this.debug("Started hotkey reader.");
            startedNewHotkeyReader = true;
        }
        AtomicBoolean atomicBoolean = this.inputUnavailable;
        synchronized (atomicBoolean) {
            try {
                if (startedNewHotkeyReader) {
                    this.inputUnavailable.wait(500L);
                }
                this.printDevModeMessages(this.inputUnavailable.get(), this.firstStartup);
                this.firstStartup = false;
            }
            catch (InterruptedException e) {
                this.debug("Interrupted while waiting to determine whether input can be read", e);
            }
            catch (PluginExecutionException pe) {
                this.error(pe.getMessage());
            }
        }
    }

    private void printDevModeMessages(boolean inputUnavailable, boolean startup) throws PluginExecutionException {
        if (startup) {
            this.info(this.formatAttentionBarrier());
            this.info(this.formatAttentionTitle("Liberty is running in dev mode."));
            this.printFeatureGenerationStatus();
        }
        if (!inputUnavailable) {
            if (startup) {
                this.info(this.formatAttentionMessage("h - see the help menu for available actions, type 'h' and press Enter."));
                this.info(this.formatAttentionMessage("q - stop the server and quit dev mode, press Ctrl-C or type 'q' and press Enter."));
            } else {
                this.printTestsMessage(false);
            }
        } else {
            this.debug("Cannot read user input, setting hotTests to true.");
            String message = "Tests will run automatically when changes are detected.";
            this.info(startup ? this.formatAttentionMessage("Enter - " + message) : message);
            this.hotTests = true;
        }
        if (startup) {
            if (this.container) {
                boolean nonDefaultDebugPortUsed;
                boolean nonDefaultHttpPortUsed = !this.skipDefaultPorts && !String.valueOf(9080).equals(this.httpPort);
                boolean nonDefaultHttpsPortUsed = !this.skipDefaultPorts && !String.valueOf(9443).equals(this.httpsPort);
                boolean bl = nonDefaultDebugPortUsed = this.alternativeDebugPort != -1;
                if (this.containerHttpPort != null || this.containerHttpsPort != null || this.libertyDebug) {
                    this.info(this.formatAttentionMessage(""));
                    this.info(this.formatAttentionTitle("Liberty container port information:"));
                }
                if (this.containerHttpPort != null && this.httpPort != null && nonDefaultHttpPortUsed || this.containerHttpsPort != null && this.httpsPort != null && nonDefaultHttpsPortUsed || this.libertyDebug && nonDefaultDebugPortUsed) {
                    this.warn(this.formatAttentionMessage("The Liberty container is using non-default host ports to avoid port conflict errors."));
                }
                if (this.containerHttpPort != null) {
                    if (this.httpPort != null) {
                        if (!nonDefaultHttpPortUsed) {
                            this.info(this.formatAttentionMessage("Internal container HTTP port [ " + this.containerHttpPort + " ] is mapped to container host port [ " + this.httpPort + " ]"));
                        } else {
                            this.info(this.formatAttentionMessage("Internal container HTTP port [ " + this.containerHttpPort + " ] is mapped to container host port [ " + this.httpPort + " ] <"));
                        }
                    } else {
                        this.info(this.formatAttentionMessage("Internal container HTTP port: [ " + this.containerHttpPort + " ]"));
                    }
                }
                if (this.containerHttpsPort != null) {
                    if (this.httpsPort != null) {
                        if (!nonDefaultHttpsPortUsed) {
                            this.info(this.formatAttentionMessage("Internal container HTTPS port [ " + this.containerHttpsPort + " ] is mapped to container host port [ " + this.httpsPort + " ]"));
                        } else {
                            this.info(this.formatAttentionMessage("Internal container HTTPS port [ " + this.containerHttpsPort + " ] is mapped to container host port [ " + this.httpsPort + " ] <"));
                        }
                    } else {
                        this.info(this.formatAttentionMessage("Internal container HTTPS port: [ " + this.containerHttpsPort + " ]"));
                    }
                }
                if (this.libertyDebug) {
                    int debugPort;
                    int n = debugPort = this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort;
                    if (!nonDefaultDebugPortUsed) {
                        this.info(this.formatAttentionMessage("Liberty debug port mapped to container host port: [ " + debugPort + " ]"));
                    } else {
                        this.info(this.formatAttentionMessage("Liberty debug port mapped to container host port: [ " + debugPort + " ] <"));
                    }
                }
                this.info(this.formatAttentionMessage(""));
                this.info(this.formatAttentionTitle("Container network information:"));
                this.info(this.formatAttentionMessage("Container name: [ " + this.containerName + " ]"));
                String[] networks = this.getContainerNetworks(this.containerName);
                if (networks != null) {
                    for (String network : networks) {
                        this.info(this.formatAttentionMessage("IP address [ " + this.getContainerIPAddress(this.containerName, network) + " ] on container network [ " + network + " ]"));
                    }
                }
            } else {
                if (this.httpPort != null || this.httpsPort != null || this.libertyDebug) {
                    this.info(this.formatAttentionMessage(""));
                    this.info(this.formatAttentionTitle("Liberty server port information:"));
                }
                if (this.httpPort != null) {
                    this.info(this.formatAttentionMessage("Liberty server HTTP port: [ " + this.httpPort + " ]"));
                }
                if (this.httpsPort != null) {
                    this.info(this.formatAttentionMessage("Liberty server HTTPS port: [ " + this.httpsPort + " ]"));
                }
                if (this.libertyDebug) {
                    int debugPort = this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort;
                    this.info(this.formatAttentionMessage("Liberty debug port: [ " + debugPort + " ]"));
                }
            }
            this.info(this.formatAttentionBarrier());
        }
    }

    private void printTestsMessage(boolean formatForAttention) {
        if (this.hotTests) {
            String message = "Tests will run automatically when changes are detected. You can also press the Enter key to run tests on demand.";
            this.info(formatForAttention ? this.formatAttentionMessage("Enter - " + message) : message);
        } else {
            String message = "run tests on demand, press Enter.";
            this.info(formatForAttention ? this.formatAttentionMessage("Enter - " + message) : "To " + message);
        }
    }

    private void printHelpMessages() {
        this.printFeatureGenerationStatus();
        this.printFeatureGenerationHotkeys();
        this.printTestsMessage(true);
        if (this.container) {
            this.info(this.formatAttentionMessage("r - rebuild the container image and restart the container, type 'r' and press Enter."));
        } else {
            this.info(this.formatAttentionMessage("r - restart the server, type 'r' and press Enter."));
        }
        this.info(this.formatAttentionMessage("h - see the help menu for available actions, type 'h' and press Enter."));
        this.info(this.formatAttentionMessage("q - stop the server and quit dev mode, press Ctrl-C or type 'q' and press Enter."));
    }

    private void printFeatureGenerationStatus() {
        this.info(this.formatAttentionMessage("Automatic generation of features: " + this.getFormattedBooleanString(this.generateFeatures)));
    }

    private void printFeatureGenerationHotkeys() {
        this.info(this.formatAttentionMessage("g - toggle the automatic generation of features, type 'g' and press Enter."));
        this.info(this.formatAttentionMessage("    A new server configuration file will be generated in the SOURCE configDropins/overrides configuration directory."));
        if (this.generateFeatures) {
            this.info(this.formatAttentionMessage("o - optimize the list of generated features, type 'o' and press Enter."));
            this.info(this.formatAttentionMessage("    A new server configuration file will be generated in the SOURCE configDropins/overrides configuration directory."));
        }
    }

    private String formatAttentionBarrier() {
        return "************************************************************************";
    }

    private String formatAttentionTitle(String message) {
        return "*    " + message;
    }

    private String formatAttentionMessage(String message) {
        return "*        " + message;
    }

    private String getFormattedBooleanString(boolean bool) {
        return "[ " + (bool ? "On" : "Off") + " ]";
    }

    private void toggleFeatureGeneration() {
        this.generateFeatures = !this.generateFeatures;
        this.logFeatureGenerationStatus();
        if (this.generateFeatures) {
            String generatedFileCanonicalPath;
            try {
                generatedFileCanonicalPath = new File(this.configDirectory, "configDropins/overrides/generated-features.xml").getCanonicalPath();
            }
            catch (IOException e) {
                generatedFileCanonicalPath = new File(this.configDirectory, "configDropins/overrides/generated-features.xml").toString();
            }
            this.warn("The source configuration directory will be modified. Features will automatically be generated in a new file: " + generatedFileCanonicalPath);
            this.optimizeGenerateFeatures();
        }
    }

    private void logFeatureGenerationStatus() {
        this.info("Setting automatic generation of features to: " + this.getFormattedBooleanString(this.generateFeatures));
    }

    protected void setFeatureGeneration(boolean generateFeatures) {
        this.generateFeatures = generateFeatures;
        this.logFeatureGenerationStatus();
    }

    private boolean optimizeGenerateFeatures() {
        this.debug("Generating optimized features list...");
        boolean generatedFeatures = this.libertyGenerateFeatures(null, true);
        if (generatedFeatures) {
            this.modifiedClasses.clear();
            this.failedToGenerateClasses.clear();
            this.generatedFeaturesModified = this.generatedFeaturesModified();
        }
        return generatedFeatures;
    }

    private boolean incrementGenerateFeatures() {
        this.debug("Generating feature list from incremental changes...");
        boolean generatedFeatures = false;
        try {
            Collection<String> classPaths = this.getClassPaths(this.modifiedClasses);
            generatedFeatures = this.libertyGenerateFeatures(classPaths, false);
            if (generatedFeatures) {
                this.modifiedClasses.clear();
                this.failedToGenerateClasses.clear();
                this.generatedFeaturesModified = this.generatedFeaturesModified();
            } else {
                this.failedToGenerateClasses.addAll(this.modifiedClasses);
                this.modifiedClasses.clear();
            }
        }
        catch (IOException e) {
            this.error("An error occurred while trying to generate features: " + e.getMessage(), e);
        }
        return generatedFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchFiles(File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, File serverXmlFile, File bootstrapPropertiesFile, File jvmOptionsFile) throws Exception {
        this.outputDirectory = outputDirectory;
        this.testOutputDirectory = testOutputDirectory;
        this.serverXmlFile = serverXmlFile;
        this.bootstrapPropertiesFile = bootstrapPropertiesFile;
        this.jvmOptionsFile = jvmOptionsFile;
        this.containerfileUsed = null;
        this.initialCompile = true;
        this.lastChangeCompiled = false;
        this.disableDependencyCompile = false;
        this.omitWatchingFiles = new ArrayList<File>();
        try {
            if (this.isLooseApplication()) {
                this.looseAppFile = this.getLooseApplicationFile();
                this.debug("Loose application configuration file set to: " + this.looseAppFile);
            }
            this.watcher = FileSystems.getDefault().newWatchService();
            this.serverXmlFileParent = null;
            if (serverXmlFile != null && serverXmlFile.exists()) {
                this.serverXmlFileParent = serverXmlFile.getParentFile();
            }
            this.bootstrapPropertiesFileParent = null;
            if (bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists()) {
                this.bootstrapPropertiesFileParent = bootstrapPropertiesFile.getParentFile();
            }
            this.jvmOptionsFileParent = null;
            if (jvmOptionsFile != null && jvmOptionsFile.exists()) {
                this.jvmOptionsFileParent = jvmOptionsFile.getParentFile();
            }
            Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
            Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
            Path configPath = this.configDirectory.getCanonicalFile().toPath();
            Path outputPath = this.outputDirectory.getCanonicalFile().toPath();
            boolean sourceDirRegistered = false;
            boolean testSourceDirRegistered = false;
            boolean configDirRegistered = false;
            boolean serverXmlFileRegistered = false;
            boolean bootstrapPropertiesFileRegistered = false;
            boolean jvmOptionsFileRegistered = false;
            boolean sourceOutputDirRegistered = false;
            boolean mmOutputDirRegAttempted = false;
            if (!this.parentBuildFiles.isEmpty()) {
                for (String string : this.parentBuildFiles.keySet()) {
                    File file = new File(string);
                    if (!file.exists()) continue;
                    this.registerSingleFile(file, executor);
                }
            }
            if (this.isMultiModuleProject()) {
                for (ProjectModule projectModule : this.upstreamProjects) {
                    this.updateArtifactPaths(projectModule, false, this.generateFeatures, executor);
                    if (this.shouldIncludeSources(projectModule.getPackagingType()) && projectModule.getSourceDirectory().exists()) {
                        this.omitWatchingFiles.addAll(this.getOmitFilesList(this.looseAppFile, projectModule.getSourceDirectory().getCanonicalPath()));
                        this.registerAll(projectModule.getSourceDirectory().getCanonicalFile().toPath(), executor);
                        projectModule.sourceDirRegistered = true;
                    }
                    if (projectModule.getTestSourceDirectory().exists()) {
                        this.registerAll(projectModule.getTestSourceDirectory().getCanonicalFile().toPath(), executor);
                        projectModule.testSourceDirRegistered = true;
                    }
                    HashMap<File, Boolean> hashMap = new HashMap<File, Boolean>();
                    for (File upstreamResourceDir : projectModule.getResourceDirs()) {
                        hashMap.put(upstreamResourceDir, false);
                        if (!upstreamResourceDir.exists()) continue;
                        this.registerAll(upstreamResourceDir.getCanonicalFile().toPath(), executor);
                        hashMap.put(upstreamResourceDir, true);
                    }
                    projectModule.setResourceMap(hashMap);
                    if (!projectModule.getBuildFile().exists()) continue;
                    this.registerSingleFile(projectModule.getBuildFile(), executor);
                }
            }
            if (this.shouldIncludeSources(this.packagingType) && this.sourceDirectory.exists()) {
                this.omitWatchingFiles.addAll(this.getOmitFilesList(this.looseAppFile, this.sourceDirectory.getCanonicalPath()));
                this.registerAll(srcPath, executor);
                sourceDirRegistered = true;
            }
            if (this.testSourceDirectory.exists()) {
                this.registerAll(testSrcPath, executor);
                testSourceDirRegistered = true;
            }
            if (this.configDirectory.exists()) {
                this.registerAll(configPath, executor);
                configDirRegistered = true;
            }
            if (serverXmlFile != null && serverXmlFile.exists() && this.serverXmlFileParent.exists()) {
                Path serverXmlFilePath = this.serverXmlFileParent.getCanonicalFile().toPath();
                this.registerAll(serverXmlFilePath, executor);
                serverXmlFileRegistered = true;
            }
            if (bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists() && this.bootstrapPropertiesFileParent.exists()) {
                Path bootstrapPropertiesFilePath = this.bootstrapPropertiesFileParent.getCanonicalFile().toPath();
                this.registerAll(bootstrapPropertiesFilePath, executor);
                bootstrapPropertiesFileRegistered = true;
            }
            if (jvmOptionsFile != null && jvmOptionsFile.exists() && this.jvmOptionsFileParent.exists()) {
                Path jvmOptionsFilePath = this.jvmOptionsFileParent.getCanonicalFile().toPath();
                this.registerAll(jvmOptionsFilePath, executor);
                jvmOptionsFileRegistered = true;
            }
            if (this.container) {
                this.containerfileUsed = this.getContainerfile();
                this.registerSingleFile(this.containerfileUsed, executor);
            }
            HashMap<File, Boolean> resourceMap = new HashMap<File, Boolean>();
            for (File file : this.resourceDirs) {
                resourceMap.put(file, false);
                if (!file.exists()) continue;
                this.registerAll(file.getCanonicalFile().toPath(), executor);
                resourceMap.put(file, true);
            }
            HashMap<Path, Boolean> hashMap = new HashMap<Path, Boolean>();
            for (Path path : this.monitoredWebResourceDirs) {
                hashMap.put(path, false);
                if (!Files.exists(path, new LinkOption[0])) continue;
                this.registerAll(path, executor);
                hashMap.put(path, true);
            }
            this.registerSingleFile(this.buildFile, executor);
            if (this.propertyFilesMap != null) {
                for (File file : this.propertyFilesMap.keySet()) {
                    this.registerSingleFile(file, executor);
                }
            }
            this.initWatchLoop();
            while (true) {
                this.checkStopDevMode(true);
                if (this.container) {
                    Set<Path> set = this.containerfileDirectoriesToWatch;
                    synchronized (set) {
                        if (!this.containerfileDirectoriesToWatch.isEmpty()) {
                            for (Path path : this.containerfileDirectoriesToWatch) {
                                File f = path.toFile();
                                if (f.isDirectory()) {
                                    this.debug("Registering path from containerfileDirectoriesToWatch: " + path);
                                    this.registerAll(path, executor, true);
                                } else {
                                    this.debug("Registering file path from containerfileDirectoriesToWatch: " + path);
                                    this.registerSingleFile(f, executor, true);
                                }
                                this.containerfileDirectoriesTracked.add(path);
                            }
                            this.containerfileDirectoriesToWatch.clear();
                        }
                    }
                }
                if (this.isMultiModuleProject()) {
                    boolean bl = this.processUpstreamJavaCompilation(this.upstreamProjects, executor);
                    this.processJavaCompilation(outputDirectory, testOutputDirectory, executor, this.compileArtifactPaths, this.testArtifactPaths, this.applicationId, bl);
                } else {
                    this.processJavaCompilation(outputDirectory, testOutputDirectory, executor, this.compileArtifactPaths, this.testArtifactPaths, null, false);
                }
                if (!(this.recompileDependencies || this.initialCompile || sourceOutputDirRegistered)) {
                    if (this.isMultiModuleProject() && !mmOutputDirRegAttempted) {
                        this.debug("Attempt to register upstream class file directories");
                        mmOutputDirRegAttempted = true;
                        for (ProjectModule projectModule : this.upstreamProjects) {
                            if (!this.shouldIncludeSources(projectModule.getPackagingType()) || !projectModule.getOutputDirectory().exists()) continue;
                            this.registerAll(projectModule.getOutputDirectory().getCanonicalFile().toPath(), executor);
                            projectModule.sourceOutputDirRegistered = true;
                        }
                    }
                    if (this.shouldIncludeSources(this.packagingType) && this.outputDirectory.exists() && this.outputDirectory.list().length > 0) {
                        this.debug("Registering class output directory: " + this.outputDirectory);
                        this.registerAll(outputPath, executor);
                        sourceOutputDirRegistered = true;
                    }
                }
                if (this.generateFeatures && !this.classesFailingToCompile() && !this.modifiedClasses.isEmpty() && (this.recompileDependencies && this.lastChangeCompiled || !this.recompileDependencies)) {
                    if (!this.failedToGenerateClasses.isEmpty()) {
                        this.modifiedClasses.addAll(this.failedToGenerateClasses);
                    }
                    this.debug("Detected a change in the following classes/directories: " + this.modifiedClasses);
                    this.lastChangeCompiled = false;
                    this.modifiedSrcBuildFile = null;
                    long l = this.generatedFeaturesFile.lastModified();
                    int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                    this.incrementGenerateFeatures();
                    if (!this.generatedFeaturesFile.exists()) {
                        if (this.isMultiModuleProject()) {
                            this.runTestThread(false, executor, -1, false, this.getAllBuildFiles());
                        } else {
                            this.runTestThread(false, executor, -1, false, false, this.buildFile);
                        }
                    } else if (this.generatedFeaturesFile.lastModified() == l) {
                        if (this.isMultiModuleProject()) {
                            this.runTestThread(false, executor, numApplicationUpdatedMessages, false, this.getAllBuildFiles());
                        } else {
                            this.runTestThread(false, executor, numApplicationUpdatedMessages, false, false, this.buildFile);
                        }
                    }
                }
                if (this.shouldIncludeSources(this.packagingType)) {
                    if (!sourceDirRegistered && this.sourceDirectory.exists() && this.sourceDirectory.listFiles().length > 0) {
                        int n = this.countApplicationUpdatedMessages();
                        this.compile(this.sourceDirectory);
                        this.registerAll(srcPath, executor);
                        this.debug("Registering Java source directory: " + this.sourceDirectory);
                        this.runTestThread(true, executor, n, false, this.buildFile);
                        sourceDirRegistered = true;
                    } else if (sourceDirRegistered && !this.sourceDirectory.exists()) {
                        this.cleanTargetDir(outputDirectory);
                        sourceDirRegistered = false;
                    }
                }
                if (!testSourceDirRegistered && this.testSourceDirectory.exists() && this.testSourceDirectory.listFiles().length > 0) {
                    this.compile(this.testSourceDirectory);
                    this.registerAll(testSrcPath, executor);
                    this.debug("Registering Java test directory: " + this.testSourceDirectory);
                    this.runTestThread(false, executor, -1, false, this.buildFile);
                    testSourceDirRegistered = true;
                } else if (testSourceDirRegistered && !this.testSourceDirectory.exists()) {
                    this.cleanTargetDir(testOutputDirectory);
                    testSourceDirRegistered = false;
                }
                if (!configDirRegistered && this.configDirectory.exists()) {
                    configDirRegistered = true;
                    if (serverXmlFile != null && !serverXmlFile.exists()) {
                        this.registerAll(configPath, executor);
                        this.debug("Registering configuration directory: " + this.configDirectory);
                    } else {
                        this.warn("The server configuration directory " + this.configDirectory + " has been added. Restart dev mode for it to take effect.");
                    }
                }
                if (!serverXmlFileRegistered && serverXmlFile != null && serverXmlFile.exists()) {
                    serverXmlFileRegistered = true;
                    this.debug("Server configuration file has been added: " + serverXmlFile);
                    this.warn("The server configuration file " + serverXmlFile + " has been added. Restart dev mode for it to take effect.");
                }
                if (!bootstrapPropertiesFileRegistered && bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists()) {
                    bootstrapPropertiesFileRegistered = true;
                    this.debug("Bootstrap properties file has been added: " + bootstrapPropertiesFile);
                    this.warn("The bootstrap properties file " + bootstrapPropertiesFile + " has been added. Restart dev mode for it to take effect.");
                }
                if (!jvmOptionsFileRegistered && jvmOptionsFile != null && jvmOptionsFile.exists()) {
                    jvmOptionsFileRegistered = true;
                    this.debug("JVM Options file has been added: " + jvmOptionsFile);
                    this.warn("The JVM Options file " + jvmOptionsFile + " has been added. Restart dev mode for it to take effect.");
                }
                for (File file : this.resourceDirs) {
                    if (!((Boolean)resourceMap.get(file)).booleanValue() && file.exists()) {
                        this.resourceDirectoryCreated();
                        this.registerAll(file.getCanonicalFile().toPath(), executor);
                        resourceMap.put(file, true);
                        continue;
                    }
                    if (!((Boolean)resourceMap.get(file)).booleanValue() || file.exists()) continue;
                    this.warn("The resource directory " + file + " was deleted.  Restart dev mode for it to take effect.");
                    resourceMap.put(file, false);
                }
                for (Path path : this.monitoredWebResourceDirs) {
                    if (!((Boolean)hashMap.get(path)).booleanValue() && Files.exists(path, new LinkOption[0])) {
                        this.updateLooseApp();
                        this.registerAll(path, executor);
                        hashMap.put(path, true);
                        this.runTestThread(false, executor, -1, false, false, new File[0]);
                        continue;
                    }
                    if (!((Boolean)hashMap.get(path)).booleanValue() || Files.exists(path, new LinkOption[0])) continue;
                    this.updateLooseApp();
                    this.warn("The webResource directory " + path + " was deleted.  Restart liberty:dev mode for it to take effect.");
                    hashMap.put(path, false);
                    this.runTestThread(false, executor, -1, false, false, new File[0]);
                }
                if (this.isMultiModuleProject()) {
                    for (ProjectModule projectModule : this.upstreamProjects) {
                        for (File resourceDir : projectModule.getResourceDirs()) {
                            if (!projectModule.getResourceMap().get(resourceDir).booleanValue() && resourceDir.exists()) {
                                this.registerAll(resourceDir.getCanonicalFile().toPath(), executor);
                                projectModule.getResourceMap().put(resourceDir, true);
                                continue;
                            }
                            if (!projectModule.getResourceMap().get(resourceDir).booleanValue() || resourceDir.exists()) continue;
                            this.warn("The resource directory " + resourceDir + " was deleted.  Restart dev mode for it to take effect.");
                            projectModule.getResourceMap().put(resourceDir, false);
                        }
                        if (this.shouldIncludeSources(projectModule.getPackagingType())) {
                            if (!projectModule.sourceDirRegistered && projectModule.getSourceDirectory().exists() && projectModule.getSourceDirectory().listFiles().length > 0) {
                                projectModule.sourceDirRegistered = true;
                                this.warn("The source directory " + projectModule.getSourceDirectory() + " was added.  This may result in compilation errors between dependent modules.  Restart dev mode for it to take effect.");
                            } else if (projectModule.sourceDirRegistered && !projectModule.getSourceDirectory().exists()) {
                                projectModule.sourceDirRegistered = false;
                                this.warn("The source directory " + projectModule.getSourceDirectory() + " was deleted.  This may result in compilation errors between dependent modules.  Restart dev mode for it to take effect.");
                            }
                        }
                        if (!projectModule.testSourceDirRegistered && projectModule.getTestSourceDirectory().exists() && projectModule.getTestSourceDirectory().listFiles().length > 0) {
                            this.compile(projectModule.getTestSourceDirectory(), projectModule);
                            this.registerAll(projectModule.getTestSourceDirectory().getCanonicalFile().toPath(), executor);
                            projectModule.testSourceDirRegistered = true;
                            this.debug("Registering Java test directory: " + projectModule.getTestSourceDirectory());
                            for (File dependentBuildFile : projectModule.getDependentModules()) {
                                ProjectModule depModule = this.getProjectModule(dependentBuildFile);
                                if (depModule != null) {
                                    this.compile(depModule.getTestSourceDirectory(), depModule);
                                    continue;
                                }
                                this.compile(this.testSourceDirectory);
                            }
                            this.runTestThread(false, executor, -1, false, this.getAllBuildFiles(projectModule));
                            continue;
                        }
                        if (!projectModule.testSourceDirRegistered || projectModule.getTestSourceDirectory().exists()) continue;
                        this.cleanTargetDir(projectModule.getTestOutputDirectory());
                        projectModule.testSourceDirRegistered = false;
                    }
                }
                if (this.trackingMode == FileTrackMode.FILE_WATCHER || this.trackingMode == FileTrackMode.NOT_SET) {
                    try {
                        WatchKey watchKey = this.watcher.poll(100L, TimeUnit.MILLISECONDS);
                        Watchable watchable = watchKey.watchable();
                        Path directory = (Path)watchable;
                        List<WatchEvent<?>> events = watchKey.pollEvents();
                        for (WatchEvent<?> event : events) {
                            if (this.trackingMode == FileTrackMode.NOT_SET) {
                                this.trackingMode = FileTrackMode.FILE_WATCHER;
                                this.disablePolling();
                            }
                            Path changed = (Path)event.context();
                            this.debug("Processing events for watched directory: " + directory);
                            File fileChanged = new File(directory.toString(), changed.toString());
                            if (this.ignoreFileOrDir(fileChanged)) continue;
                            this.debug("Changed: " + changed + "; " + event.kind());
                            ChangeType changeType = null;
                            if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                                changeType = ChangeType.CREATE;
                            } else if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                                changeType = ChangeType.MODIFY;
                            } else if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                                changeType = ChangeType.DELETE;
                            }
                            this.processFileChanges(executor, fileChanged, outputDirectory, false, changeType);
                        }
                        boolean valid = watchKey.reset();
                        if (!valid) {
                            this.debug("WatchService key has been unregistered for " + directory);
                        }
                    }
                    catch (InterruptedException | NullPointerException exception) {
                        // empty catch block
                    }
                }
                if (this.trackingMode != FileTrackMode.POLLING && this.trackingMode != FileTrackMode.NOT_SET) continue;
                Set<FileAlterationObserver> set = this.newFileObservers;
                synchronized (set) {
                    this.consolidateFileObservers();
                }
                for (FileAlterationObserver fileAlterationObserver : this.fileObservers) {
                    if (this.cancelledFileObservers.contains(fileAlterationObserver)) continue;
                    fileAlterationObserver.checkAndNotify();
                }
                Set<FileAlterationObserver> set2 = this.cancelledFileObservers;
                synchronized (set2) {
                    this.removeCancelledFileObservers();
                }
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (Throwable throwable) {
            if (this.watcher != null) {
                try {
                    this.watcher.close();
                }
                catch (IOException e) {
                    this.error("An error occurred attempting to close the file watcher. " + e.getMessage(), e);
                }
            }
            throw throwable;
        }
    }

    public Collection<String> getJavaSourceClassPaths() throws IOException {
        return this.getClassPaths(this.modifiedClasses);
    }

    private Collection<String> getClassPaths(Collection<File> classFiles) throws IOException {
        HashSet<String> classPaths = new HashSet<String>();
        for (File classPath : classFiles) {
            classPaths.add(classPath.getCanonicalPath());
        }
        return classPaths;
    }

    private boolean shouldIncludeSources(String packaging) {
        return !"ear".equals(packaging) && !"pom".equals(packaging);
    }

    private void consolidateFileObservers() {
        this.fileObservers.addAll(this.newFileObservers);
        this.newFileObservers.clear();
    }

    private void removeCancelledFileObservers() {
        this.fileObservers.removeAll(this.cancelledFileObservers);
        this.cancelledFileObservers.clear();
    }

    private void registerSingleFile(File registerFile, ThreadPoolExecutor executor) throws IOException {
        this.registerSingleFile(registerFile, executor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSingleFile(final File registerFile, ThreadPoolExecutor executor, boolean removeOnContainerRebuild) throws IOException {
        if (this.trackingMode == FileTrackMode.POLLING || this.trackingMode == FileTrackMode.NOT_SET) {
            String parentPath = registerFile.getParentFile().getCanonicalPath();
            this.debug("Registering single file polling for " + registerFile.toString());
            Set<FileAlterationObserver> set = this.newFileObservers;
            synchronized (set) {
                HashSet<FileAlterationObserver> tempCombinedObservers = new HashSet<FileAlterationObserver>();
                tempCombinedObservers.addAll(this.fileObservers);
                tempCombinedObservers.addAll(this.newFileObservers);
                FileAlterationObserver existingObserver = null;
                for (FileAlterationObserver observer : tempCombinedObservers) {
                    if (!parentPath.equals(observer.getDirectory().getCanonicalPath())) continue;
                    this.debug("Updating file polling for " + registerFile.toString() + " since its parent directory is already being observed");
                    existingObserver = observer;
                }
                FileFilter singleFileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        block3: {
                            try {
                                if (file.getCanonicalFile().equals(registerFile.getCanonicalFile())) {
                                    return true;
                                }
                            }
                            catch (IOException e) {
                                if (!file.equals(registerFile)) break block3;
                                return true;
                            }
                        }
                        return false;
                    }
                };
                try {
                    FileAlterationObserver observer;
                    observer = existingObserver;
                    if (observer != null) {
                        this.debug("Updating parent file observer for: " + registerFile.toString());
                        observer = this.addFileAlterationObserver(executor, observer, parentPath, singleFileFilter);
                    } else {
                        this.debug("Adding single file observer for: " + registerFile.toString());
                        observer = this.addFileAlterationObserver(executor, parentPath, singleFileFilter);
                    }
                    if (removeOnContainerRebuild) {
                        this.debug("Adding file to containerfileDirectoriesFileObservers: " + registerFile.toString());
                        this.containerfileDirectoriesFileObservers.add(observer);
                    }
                }
                catch (Exception e) {
                    this.error("Could not observe single file " + registerFile.toString(), e);
                }
            }
        }
        if (this.trackingMode == FileTrackMode.FILE_WATCHER || this.trackingMode == FileTrackMode.NOT_SET) {
            this.debug("Adding directory to WatchService " + registerFile.getParentFile().toPath() + " for single file " + registerFile.getName());
            WatchKey key = registerFile.getParentFile().toPath().register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
            if (removeOnContainerRebuild) {
                this.debug("Adding file to containerfileDirectoriesWatchKeys: " + registerFile.getName());
                this.containerfileDirectoriesWatchKeys.add(key);
            }
        }
    }

    private FileAlterationObserver addFileAlterationObserver(ThreadPoolExecutor executor, FileAlterationObserver observer, String parentPath, FileFilter filter) throws Exception {
        FileAlterationObserver newObserver = this.getFileAlterationObserver(executor, parentPath, filter);
        for (FileAlterationListener nextListener : observer.getListeners()) {
            newObserver.addListener(nextListener);
        }
        newObserver.initialize();
        this.fileObservers.remove(observer);
        this.newFileObservers.remove(observer);
        try {
            observer.destroy();
        }
        catch (Exception e) {
            this.debug("Could not destroy file observer", e);
        }
        this.newFileObservers.add(newObserver);
        return newObserver;
    }

    private FileAlterationObserver addFileAlterationObserver(ThreadPoolExecutor executor, String parentPath, FileFilter filter) throws Exception {
        FileAlterationObserver observer = this.getFileAlterationObserver(executor, parentPath, filter);
        observer.initialize();
        this.newFileObservers.add(observer);
        return observer;
    }

    private FileAlterationObserver getFileAlterationObserver(ThreadPoolExecutor executor, String parentPath, FileFilter filter) throws Exception {
        FileAlterationObserver observer = new FileAlterationObserver(parentPath, filter);
        this.addFileAlterationListener(executor, observer, parentPath, filter);
        return observer;
    }

    private void addFileAlterationListener(final ThreadPoolExecutor executor, FileAlterationObserver observer, final String parentPath, FileFilter filter) {
        observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onDirectoryCreate(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.CREATE);
            }

            public void onDirectoryDelete(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.DELETE);
            }

            public void onDirectoryChange(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.MODIFY);
            }

            public void onFileCreate(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.CREATE);
            }

            public void onFileDelete(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.DELETE);
            }

            public void onFileChange(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.MODIFY);
            }

            private void onAlteration(ThreadPoolExecutor executor2, String parentPath2, File file, boolean isDirectory, ChangeType changeType) {
                if (DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    try {
                        WatchKey wk = null;
                        if (DevUtil.this.watcher != null) {
                            wk = DevUtil.this.watcher.poll(1000L, TimeUnit.MILLISECONDS);
                        }
                        List<WatchEvent<?>> events = null;
                        if (wk != null) {
                            events = wk.pollEvents();
                        }
                        if (events == null || events.isEmpty()) {
                            DevUtil.this.debug("Setting file track mode to POLLING since no file watcher events were found.");
                            DevUtil.this.trackingMode = FileTrackMode.POLLING;
                            if (DevUtil.this.watcher != null) {
                                DevUtil.this.watcher.close();
                            }
                        } else {
                            DevUtil.this.debug("Setting file track mode to FILE_WATCHER.");
                            DevUtil.this.trackingMode = FileTrackMode.FILE_WATCHER;
                            DevUtil.this.disablePolling();
                        }
                    }
                    catch (Exception e) {
                        DevUtil.this.error("An error occurred attempting to retrieve the watch key or close the file watcher. " + e.getMessage(), e);
                    }
                }
                try {
                    DevUtil.this.processFileChanges(executor2, file, DevUtil.this.outputDirectory, isDirectory, changeType);
                }
                catch (Exception e) {
                    DevUtil.this.debug(e);
                    DevUtil.this.error("Could not file process changes for " + file.getAbsolutePath() + ": " + e.getMessage());
                }
            }
        });
    }

    protected Collection<File> getOmitFilesList(File looseAppFile, String srcDirectoryPath) {
        ArrayList<File> omitFiles = new ArrayList<File>();
        try {
            if (looseAppFile != null && looseAppFile.exists()) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(looseAppFile);
                NodeList archiveList = document.getElementsByTagName("archive");
                for (int i = 0; i < archiveList.getLength(); ++i) {
                    NodeList ar = archiveList.item(i).getChildNodes();
                    for (int j = 0; j < ar.getLength(); ++j) {
                        File srcOnDiskFile;
                        Node node = ar.item(j);
                        if (!node.getNodeName().equals("dir") && !node.getNodeName().equals("file")) continue;
                        String srcOnDiskNodeText = node.getAttributes().getNamedItem("sourceOnDisk").getTextContent();
                        if (this.container) {
                            srcOnDiskNodeText = srcOnDiskNodeText.replace("${io.openliberty.tools.projectRoot}", DevUtil.getLooseAppProjectRoot(this.projectDirectory, this.multiModuleProjectDirectory).getCanonicalPath());
                        }
                        if (!(srcOnDiskFile = new File(srcOnDiskNodeText)).getCanonicalPath().startsWith(srcDirectoryPath)) continue;
                        omitFiles.add(srcOnDiskFile);
                    }
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.error("Unable to read loose application configuration file: " + looseAppFile.toString());
            return null;
        }
        return omitFiles;
    }

    private boolean processUpstreamJavaCompilation(List<ProjectModule> upstreamProjects, ThreadPoolExecutor executor) throws PluginExecutionException, IOException {
        boolean processTests;
        boolean change = false;
        boolean processSources = System.currentTimeMillis() > this.lastJavaSourceChange + this.compileWaitMillis;
        boolean bl = processTests = System.currentTimeMillis() > this.lastJavaTestChange + this.compileWaitMillis;
        if (processSources) {
            if (this.triggerUpstreamJavaSourceRecompile) {
                this.compileFailingProjects(null, false, executor);
                if (!this.failedCompilationJavaSources.isEmpty()) {
                    this.triggerJavaSourceRecompile = true;
                }
                if (!this.failedCompilationJavaTests.isEmpty()) {
                    this.triggerJavaTestRecompile = true;
                }
                change = true;
            }
            for (ProjectModule project : upstreamProjects) {
                boolean successfulCompilation = true;
                boolean compileDownstreamSrc = false;
                boolean compileDownstreamTest = false;
                boolean pastBuildFileWaitPeriod = System.currentTimeMillis() > this.lastBuildFileChange.get(project.getBuildFile()) + this.compileWaitMillis;
                if (!pastBuildFileWaitPeriod) continue;
                if (!project.deleteJavaSources.isEmpty()) {
                    this.debug("Deleting Java source files: " + project.deleteJavaSources);
                    for (File file : project.deleteJavaSources) {
                        this.deleteJavaFile(file, project.getOutputDirectory(), project.getSourceDirectory());
                    }
                    change = true;
                }
                if (!project.recompileJavaSources.isEmpty()) {
                    if (!project.failedCompilationJavaSources.isEmpty()) {
                        project.recompileJavaSources.addAll(project.failedCompilationJavaSources);
                    }
                    if (this.shouldRecompileDependencies(project) || !this.recompileDependencies) {
                        compileDownstreamSrc = true;
                        if (!this.compileFailingProjects(project, false, executor)) {
                            successfulCompilation = false;
                        }
                    }
                    this.debug("Recompiling Java source files: " + project.recompileJavaSources);
                    if (this.recompileJavaSource(project.recompileJavaSources, project.getCompileArtifacts(), executor, project.getOutputDirectory(), project.getTestOutputDirectory(), project.getProjectName(), project.getBuildFile(), project.getCompilerOptions(), project.skipUTs(), true)) {
                        project.failedCompilationJavaSources.clear();
                        change = true;
                        if (this.modifiedSrcBuildFile != null && project.getBuildFile().equals(this.modifiedSrcBuildFile)) {
                            this.debug("Setting lastChangeCompiled to true");
                            this.lastChangeCompiled = true;
                        }
                    } else {
                        successfulCompilation = false;
                        project.failedCompilationJavaSources.addAll(project.recompileJavaSources);
                    }
                }
                if (processTests) {
                    if (!project.deleteJavaTests.isEmpty()) {
                        this.debug("Deleting Java test files: " + project.deleteJavaTests);
                        for (File file : project.deleteJavaTests) {
                            this.deleteJavaFile(file, project.getTestOutputDirectory(), project.getTestSourceDirectory());
                        }
                    }
                    if (!project.recompileJavaTests.isEmpty() || project.triggerJavaTestRecompile) {
                        if (!project.failedCompilationJavaTests.isEmpty()) {
                            project.recompileJavaTests.addAll(project.failedCompilationJavaTests);
                        }
                        if (this.shouldRecompileDependencies(project) || !this.recompileDependencies) {
                            compileDownstreamTest = true;
                            if (!this.compileFailingProjects(project, true, executor)) {
                                successfulCompilation = false;
                            }
                        }
                        this.debug("Recompiling Java test files: " + project.recompileJavaTests);
                        if (this.recompileJavaTest(project.recompileJavaTests, project.getTestArtifacts(), executor, project.getOutputDirectory(), project.getTestOutputDirectory(), project.getProjectName(), project.getBuildFile(), project.getCompilerOptions(), project.skipUTs(), true)) {
                            project.failedCompilationJavaTests.clear();
                        } else {
                            successfulCompilation = false;
                            project.failedCompilationJavaTests.addAll(project.recompileJavaTests);
                        }
                    }
                }
                if (compileDownstreamSrc) {
                    int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                    for (File dependentModule : project.getDependentModules()) {
                        if (!this.recompileDependencies) {
                            if (this.compileFailingClasses(this.getProjectModule(dependentModule), false, executor)) continue;
                            successfulCompilation = false;
                            continue;
                        }
                        if (this.compileModuleForBuildFile(dependentModule, false, executor)) continue;
                        successfulCompilation = false;
                    }
                    if (successfulCompilation && !this.generateFeatures) {
                        this.runTestThread(true, executor, numApplicationUpdatedMessages, false, this.getAllBuildFiles(project));
                    }
                } else if (compileDownstreamTest) {
                    for (File file : project.getDependentModules()) {
                        if (!this.recompileDependencies) {
                            if (this.compileFailingClasses(this.getProjectModule(file), true, executor)) continue;
                            successfulCompilation = false;
                            continue;
                        }
                        if (this.compileModuleForBuildFile(file, true, executor)) continue;
                        successfulCompilation = false;
                    }
                    if (successfulCompilation) {
                        this.runTestThread(false, executor, -1, false, this.getAllBuildFiles(project));
                    }
                }
                if (!project.deleteJavaSources.isEmpty() && project.recompileJavaSources.isEmpty()) {
                    int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                    this.runTestThread(true, executor, numApplicationUpdatedMessages, false, this.getAllBuildFiles(project));
                } else if (processTests && !project.deleteJavaTests.isEmpty() && project.recompileJavaTests.isEmpty()) {
                    this.runTestThread(false, executor, -1, false, this.getAllBuildFiles(project));
                }
                project.deleteJavaSources.clear();
                project.recompileJavaSources.clear();
                project.triggerJavaTestRecompile = false;
                if (processTests) {
                    project.deleteJavaTests.clear();
                    project.recompileJavaTests.clear();
                }
                if (!project.disableDependencyCompile) continue;
                project.disableDependencyCompile = false;
            }
            this.triggerUpstreamJavaSourceRecompile = false;
        }
        return change;
    }

    private boolean compileFailingProjects(ProjectModule currentProject, boolean testsOnly, ThreadPoolExecutor executor) throws PluginExecutionException {
        if (this.initialCompile) {
            return false;
        }
        boolean successfulCompilation = true;
        for (int i = 0; i < this.upstreamProjects.size(); ++i) {
            ProjectModule project = this.upstreamProjects.get(i);
            if (currentProject != null && this.upstreamProjects.get(i).equals(currentProject)) break;
            if (this.compileFailingClasses(project, testsOnly, executor)) continue;
            successfulCompilation = false;
        }
        return successfulCompilation;
    }

    private boolean compileFailingClasses(ProjectModule currentProject, boolean testsOnly, ThreadPoolExecutor executor) throws PluginExecutionException {
        if (this.initialCompile) {
            return false;
        }
        boolean successfulSrcCompile = true;
        boolean successfulTestCompile = true;
        if (currentProject == null) {
            if (!testsOnly && !this.failedCompilationJavaSources.isEmpty()) {
                if (this.recompileJavaSource(this.failedCompilationJavaSources, this.compileArtifactPaths, executor, this.outputDirectory, this.testOutputDirectory, this.getProjectName(), this.buildFile, this.compilerOptions, this.skipUTs, true)) {
                    this.failedCompilationJavaSources.clear();
                } else {
                    successfulSrcCompile = false;
                }
            }
            if (!this.failedCompilationJavaTests.isEmpty()) {
                if (this.recompileJavaTest(this.failedCompilationJavaTests, this.testArtifactPaths, executor, this.outputDirectory, this.testOutputDirectory, this.getProjectName(), this.buildFile, this.compilerOptions, this.skipUTs, true)) {
                    this.failedCompilationJavaTests.clear();
                } else {
                    successfulTestCompile = false;
                }
            }
            return successfulSrcCompile && successfulTestCompile;
        }
        if (!testsOnly && !currentProject.failedCompilationJavaSources.isEmpty()) {
            if (this.recompileJavaSource(currentProject.failedCompilationJavaSources, currentProject.getCompileArtifacts(), executor, currentProject.getOutputDirectory(), currentProject.getTestOutputDirectory(), currentProject.getProjectName(), currentProject.getBuildFile(), currentProject.getCompilerOptions(), currentProject.skipUTs(), true)) {
                currentProject.failedCompilationJavaSources.clear();
            } else {
                successfulSrcCompile = false;
            }
        }
        if (!currentProject.failedCompilationJavaTests.isEmpty()) {
            if (this.recompileJavaTest(currentProject.failedCompilationJavaTests, currentProject.getTestArtifacts(), executor, currentProject.getOutputDirectory(), currentProject.getTestOutputDirectory(), currentProject.getProjectName(), currentProject.getBuildFile(), currentProject.getCompilerOptions(), currentProject.skipUTs(), true)) {
                currentProject.failedCompilationJavaTests.clear();
            } else {
                successfulTestCompile = false;
            }
        }
        return successfulSrcCompile && successfulTestCompile;
    }

    private void processJavaCompilation(File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, Set<String> compileArtifactPaths, Set<String> testArtifactPaths, String projectName, boolean upstreamBuilt) throws IOException, PluginExecutionException {
        boolean pastBuildFileWaitPeriod;
        boolean processSources = System.currentTimeMillis() > this.lastJavaSourceChange + this.compileWaitMillis;
        boolean processTests = System.currentTimeMillis() > this.lastJavaTestChange + this.compileWaitMillis;
        boolean bl = pastBuildFileWaitPeriod = System.currentTimeMillis() > this.lastBuildFileChange.get(this.buildFile) + this.compileWaitMillis;
        if (processSources && pastBuildFileWaitPeriod) {
            int numApplicationUpdatedMessages = 0;
            if (!this.deleteJavaSources.isEmpty()) {
                this.debug("Deleting Java source files: " + this.deleteJavaSources);
                numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                for (File file : this.deleteJavaSources) {
                    this.deleteJavaFile(file, outputDirectory, this.sourceDirectory);
                }
            }
            if (!this.recompileJavaSources.isEmpty() || this.triggerJavaSourceRecompile) {
                numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                if (!this.failedCompilationJavaSources.isEmpty()) {
                    this.recompileJavaSources.addAll(this.failedCompilationJavaSources);
                }
                boolean skipRunningTests = false;
                if (this.initialCompile || this.disableDependencyCompile) {
                    skipRunningTests = true;
                }
                if (!(!this.isMultiModuleProject() || this.disableDependencyCompile && this.recompileDependencies || this.compileFailingProjects(null, false, executor))) {
                    skipRunningTests = true;
                }
                this.debug("Recompiling Java source files: " + this.recompileJavaSources);
                if (this.recompileJavaSource(this.recompileJavaSources, compileArtifactPaths, executor, outputDirectory, testOutputDirectory, projectName, this.buildFile, this.compilerOptions, this.skipUTs, skipRunningTests)) {
                    this.failedCompilationJavaSources.clear();
                    if (this.modifiedSrcBuildFile != null && this.modifiedSrcBuildFile.equals(this.buildFile)) {
                        this.debug("Setting lastChangeCompiled to true");
                        this.lastChangeCompiled = true;
                    }
                } else {
                    this.failedCompilationJavaSources.addAll(this.recompileJavaSources);
                }
            }
            if (processTests) {
                if (!this.deleteJavaTests.isEmpty()) {
                    this.debug("Deleting Java test files: " + this.deleteJavaTests);
                    for (File file : this.deleteJavaTests) {
                        this.deleteJavaFile(file, testOutputDirectory, this.testSourceDirectory);
                    }
                }
                if (!this.recompileJavaTests.isEmpty() || this.triggerJavaTestRecompile) {
                    if (!this.failedCompilationJavaTests.isEmpty()) {
                        this.recompileJavaTests.addAll(this.failedCompilationJavaTests);
                    }
                    boolean skipRunningTests = false;
                    if (this.initialCompile || this.disableDependencyCompile) {
                        skipRunningTests = true;
                    }
                    if (!(!this.isMultiModuleProject() || this.disableDependencyCompile && this.recompileDependencies || this.compileFailingProjects(null, true, executor))) {
                        skipRunningTests = true;
                    }
                    this.debug("Recompiling Java test files: " + this.recompileJavaTests);
                    if (this.recompileJavaTest(this.recompileJavaTests, testArtifactPaths, executor, outputDirectory, testOutputDirectory, projectName, this.buildFile, this.compilerOptions, this.skipUTs, skipRunningTests)) {
                        this.failedCompilationJavaTests.clear();
                    } else {
                        this.failedCompilationJavaTests.addAll(this.recompileJavaTests);
                    }
                }
            }
            if (!this.deleteJavaSources.isEmpty() && this.recompileJavaSources.isEmpty()) {
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, this.buildFile);
            } else if (processTests && !this.deleteJavaTests.isEmpty() && this.recompileJavaTests.isEmpty()) {
                this.runTestThread(false, executor, -1, false, this.buildFile);
            }
            this.deleteJavaSources.clear();
            this.recompileJavaSources.clear();
            this.triggerJavaTestRecompile = false;
            this.triggerJavaSourceRecompile = false;
            if (processTests) {
                this.deleteJavaTests.clear();
                this.recompileJavaTests.clear();
            }
            if (this.disableDependencyCompile) {
                this.disableDependencyCompile = false;
            }
            if (this.initialCompile) {
                this.debug("Setting initialCompile to false");
                this.initialCompile = false;
                if (this.hotTests) {
                    if (this.isMultiModuleProject()) {
                        this.runTestThread(false, executor, -1, true, this.getAllBuildFiles());
                    } else {
                        this.runTestThread(false, executor, -1, false, this.buildFile);
                    }
                }
            }
        }
    }

    private void checkStopDevMode(boolean skipOnRestart) throws PluginScenarioException {
        if (this.serverThread == null || this.serverThread.getState().equals((Object)Thread.State.TERMINATED)) {
            boolean restarting;
            boolean bl = restarting = this.devStop.get() && !this.calledShutdownHook.get();
            if (skipOnRestart && restarting && !this.externalContainerShutdown.get()) {
                this.debug("Server is restarting. Allowing dev mode to continue.");
                return;
            }
            if (!this.devStop.get()) {
                if (this.container) {
                    throw new PluginScenarioException("The container has stopped. Exiting dev mode.");
                }
                throw new PluginScenarioException("The server has stopped. Exiting dev mode.");
            }
            throw new PluginScenarioException();
        }
    }

    private void initWatchLoop() throws IOException {
        this.recompileJavaSources = new HashSet<File>();
        this.recompileJavaTests = new HashSet<File>();
        this.deleteJavaSources = new HashSet<File>();
        this.deleteJavaTests = new HashSet<File>();
        this.failedCompilationJavaSources = new HashSet<File>();
        this.failedCompilationJavaTests = new HashSet<File>();
        this.lastJavaSourceChange = System.currentTimeMillis();
        this.lastJavaTestChange = System.currentTimeMillis();
        this.triggerJavaSourceRecompile = false;
        this.triggerJavaTestRecompile = false;
        this.triggerUpstreamJavaSourceRecompile = false;
        this.lastBuildFileChange = new HashMap<File, Long>();
        this.modifiedClasses = new HashSet<File>();
        this.failedToGenerateClasses = new HashSet<File>();
        if (this.isMultiModuleProject()) {
            for (ProjectModule project : this.upstreamProjects) {
                this.triggerUpstreamModuleCompile(project, false);
                this.lastBuildFileChange.put(project.getBuildFile(), System.currentTimeMillis());
            }
        }
        this.triggerMainModuleCompile(false);
        this.lastBuildFileChange.put(this.buildFile, System.currentTimeMillis());
    }

    private void processFileChanges(ThreadPoolExecutor executor, File fileChanged, File outputDirectory, boolean isDirectory, ChangeType changeType) throws IOException, PluginExecutionException {
        ArrayList<File> javaFilesChanged;
        if (this.ignoreFileOrDir(fileChanged)) {
            return;
        }
        this.debug("Processing file changes for " + fileChanged + ", change type " + (Object)((Object)changeType));
        Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
        Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
        Path configPath = this.configDirectory.getCanonicalFile().toPath();
        Path outputPath = this.outputDirectory.getCanonicalFile().toPath();
        Path directory = fileChanged.getParentFile().getCanonicalFile().toPath();
        File resourceParent = null;
        for (File file : this.resourceDirs) {
            if (!directory.startsWith(file.getCanonicalFile().toPath())) continue;
            resourceParent = file;
            break;
        }
        Path webResourceParent = null;
        for (Path webResourceDir : this.monitoredWebResourceDirs) {
            if (!directory.startsWith(webResourceDir)) continue;
            webResourceParent = webResourceDir;
            break;
        }
        if (fileChanged.isDirectory()) {
            if (changeType == ChangeType.CREATE && !this.isUpstreamSourceDir(fileChanged)) {
                File newlyRegisteredFile;
                this.registerAll(fileChanged.toPath(), executor);
                Iterator iterator = FileUtils.iterateFiles((File)fileChanged, (IOFileFilter)new NameFileFilter("generated-features.xml"), (IOFileFilter)TrueFileFilter.INSTANCE);
                if (iterator.hasNext() && (newlyRegisteredFile = (File)iterator.next()).equals(this.generatedFeaturesFile)) {
                    this.debug("Registered configDropins/overrides directory, processing file changes for generated features file: " + newlyRegisteredFile);
                    this.processFileChanges(executor, newlyRegisteredFile, outputDirectory, false, ChangeType.CREATE);
                }
            }
            return;
        }
        int n = this.countApplicationUpdatedMessages();
        System.setProperty(SKIP_BETA_INSTALL_WARNING, Boolean.FALSE.toString());
        if (!this.parentBuildFiles.isEmpty() && this.parentBuildFiles.containsKey(fileChanged.getCanonicalPath()) && changeType == ChangeType.MODIFY) {
            this.debug("Change detected in parent build file: " + fileChanged + ". Updating compile artifact paths.");
            this.updateArtifactPaths(fileChanged);
            if (this.recompileDependencies) {
                if (this.isMultiModuleProject()) {
                    ProjectModule project = this.getFirstProjectModule(fileChanged);
                    if (project != null) {
                        this.triggerUpstreamModuleCompile(project, false);
                    } else {
                        this.triggerMainModuleCompile(false);
                    }
                } else {
                    this.triggerMainModuleCompile(false);
                }
            } else {
                this.compileFailingProjects(null, false, executor);
            }
        }
        if (this.upstreamProjects != null && !this.upstreamProjects.isEmpty()) {
            for (ProjectModule project : this.upstreamProjects) {
                File upstreamResourceParent = null;
                for (File resourceDir : project.getResourceDirs()) {
                    if (!directory.startsWith(resourceDir.getCanonicalFile().toPath())) continue;
                    upstreamResourceParent = resourceDir;
                    break;
                }
                if (directory.startsWith(project.getSourceDirectory().getCanonicalPath())) {
                    if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                        this.debug("Java source file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                        this.lastJavaSourceChange = System.currentTimeMillis();
                        if (this.recompileDependencies) {
                            if (this.generateFeatures) {
                                this.modifiedSrcBuildFile = project.getBuildFile();
                                this.debug("Multi-module - setting modifiedSrcBuildFile to: " + this.modifiedSrcBuildFile);
                                ProjectModule modifiedModule = this.getProjectModule(this.modifiedSrcBuildFile);
                                File outputDir = modifiedModule.getOutputDirectory();
                                if (outputDir != null) {
                                    this.modifiedClasses.add(outputDir);
                                }
                                this.lastChangeCompiled = false;
                            }
                            this.triggerUpstreamModuleCompile(project, false);
                            continue;
                        }
                        project.recompileJavaSources.add(fileChanged);
                        continue;
                    }
                    if (changeType != ChangeType.DELETE) continue;
                    this.debug("Java file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                    this.lastJavaSourceChange = System.currentTimeMillis();
                    project.deleteJavaSources.add(fileChanged);
                    if (!this.recompileDependencies) continue;
                    this.triggerUpstreamModuleCompile(project, false);
                    continue;
                }
                if (directory.startsWith(project.getTestSourceDirectory().getCanonicalPath())) {
                    if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                        this.debug("Java test file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                        this.lastJavaTestChange = System.currentTimeMillis();
                        if (this.recompileDependencies) {
                            this.triggerUpstreamModuleCompile(project, true);
                            continue;
                        }
                        project.recompileJavaTests.add(fileChanged);
                        continue;
                    }
                    if (changeType != ChangeType.DELETE) continue;
                    this.debug("Java test file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                    this.lastJavaTestChange = System.currentTimeMillis();
                    project.deleteJavaTests.add(fileChanged);
                    if (!this.recompileDependencies) continue;
                    this.triggerUpstreamModuleCompile(project, true);
                    continue;
                }
                if (!this.recompileDependencies && this.generateFeatures && directory.startsWith(project.getOutputDirectory().getCanonicalPath())) {
                    if (fileChanged.exists() && fileChanged.getName().endsWith(".class") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                        this.debug("Java source class file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                        this.modifiedClasses.add(fileChanged);
                        continue;
                    }
                    if (changeType != ChangeType.DELETE) continue;
                    this.debug("Java source class deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                    this.modifiedClasses.remove(fileChanged);
                    continue;
                }
                if (fileChanged.equals(project.getBuildFile()) && directory.startsWith(project.getBuildFile().getParentFile().getCanonicalFile().toPath()) && changeType == ChangeType.MODIFY) {
                    this.debug("Change detected in: " + project.getBuildFile() + ". Updating compile artifact paths.");
                    this.lastBuildFileChange.put(project.getBuildFile(), System.currentTimeMillis());
                    boolean updatedArtifactPaths = this.updateArtifactPaths(project, true, this.generateFeatures, executor);
                    if (!updatedArtifactPaths) continue;
                    if (this.recompileDependencies) {
                        if (!(project.getSourceDirectory().exists() || project.getTestSourceDirectory().exists() || project.getDependentModules().isEmpty())) {
                            this.triggerUpstreamModuleCompile(this.getProjectModule(project.getDependentModules().get(0)), false);
                            continue;
                        }
                        this.triggerUpstreamModuleCompile(project, false);
                        continue;
                    }
                    if (!project.failedCompilationJavaSources.isEmpty()) {
                        this.triggerUpstreamJavaSourceRecompile = true;
                    }
                    if (project.failedCompilationJavaTests.isEmpty()) continue;
                    project.triggerJavaTestRecompile = true;
                    continue;
                }
                if (upstreamResourceParent == null || !directory.startsWith(upstreamResourceParent.getCanonicalFile().toPath())) continue;
                this.debug("Resource dir: " + upstreamResourceParent.toString());
                if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                    this.copyFile(fileChanged, upstreamResourceParent, project.getOutputDirectory(), null);
                    this.runTestThread(true, executor, n, false, this.getAllBuildFiles(project));
                    continue;
                }
                if (changeType != ChangeType.DELETE) continue;
                this.debug("Resource file deleted: " + fileChanged.getName());
                this.deleteFile(fileChanged, upstreamResourceParent, project.getOutputDirectory(), null);
                this.runTestThread(true, executor, n, false, this.getAllBuildFiles(project));
            }
        }
        if (directory.startsWith(srcPath)) {
            javaFilesChanged = new ArrayList<File>();
            javaFilesChanged.add(fileChanged);
            if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.debug("Java source file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaSourceChange = System.currentTimeMillis();
                if (this.recompileDependencies) {
                    if (this.generateFeatures) {
                        this.modifiedSrcBuildFile = this.buildFile;
                        this.debug("Single module - setting modifiedSrcBuildFile to: " + this.modifiedSrcBuildFile);
                        if (outputDirectory != null) {
                            this.modifiedClasses.add(outputDirectory);
                        }
                        this.lastChangeCompiled = false;
                    }
                    this.triggerMainModuleCompile(false);
                } else {
                    this.recompileJavaSources.add(fileChanged);
                }
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Java file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaSourceChange = System.currentTimeMillis();
                this.deleteJavaSources.add(fileChanged);
                if (this.recompileDependencies) {
                    this.triggerMainModuleCompile(false);
                }
            }
        } else if (directory.startsWith(testSrcPath)) {
            javaFilesChanged = new ArrayList();
            javaFilesChanged.add(fileChanged);
            if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.debug("Java test file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaTestChange = System.currentTimeMillis();
                if (this.recompileDependencies) {
                    this.triggerMainModuleCompile(true);
                } else {
                    this.recompileJavaTests.add(fileChanged);
                }
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Java test file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaTestChange = System.currentTimeMillis();
                this.deleteJavaTests.add(fileChanged);
                if (this.recompileDependencies) {
                    this.triggerMainModuleCompile(true);
                }
            }
        } else if (this.serverXmlFileParent != null && directory.equals(this.serverXmlFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.serverXmlFile.getName())) {
            this.processConfigFileChange(fileChanged, changeType, executor, n, true);
        } else if (directory.startsWith(configPath) && !this.isGeneratedConfigFile(fileChanged, this.configDirectory, this.serverDirectory)) {
            this.processConfigFileChange(fileChanged, changeType, executor, n, false);
        } else if (this.bootstrapPropertiesFileParent != null && directory.equals(this.bootstrapPropertiesFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.bootstrapPropertiesFile.getName())) {
            if (this.isContainerfileDirectoryChanged(fileChanged)) {
                this.untrackContainerfileDirectoriesAndRestart();
            } else {
                this.restartServer(false);
            }
        } else if (this.jvmOptionsFileParent != null && directory.equals(this.jvmOptionsFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.jvmOptionsFile.getName())) {
            if (this.isContainerfileDirectoryChanged(fileChanged)) {
                this.untrackContainerfileDirectoriesAndRestart();
            } else {
                this.restartServer(false);
            }
        } else if (resourceParent != null && directory.startsWith(resourceParent.getCanonicalFile().toPath())) {
            this.debug("Resource dir: " + resourceParent.toString());
            if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.resourceModifiedOrCreated(fileChanged, resourceParent, outputDirectory);
                this.runTestThread(true, executor, n, this.skipUTs, false, this.buildFile);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Resource file deleted: " + fileChanged.getName());
                this.resourceDeleted(fileChanged, resourceParent, outputDirectory);
                this.runTestThread(true, executor, n, this.skipUTs, false, this.buildFile);
            }
        } else if (webResourceParent != null && directory.startsWith(webResourceParent)) {
            this.debug("webResource dir: " + webResourceParent.toString());
            this.updateLooseApp();
            this.runTestThread(true, executor, n, false, false, new File[0]);
        } else if (fileChanged.equals(this.buildFile) && directory.startsWith(this.buildFile.getParentFile().getCanonicalFile().toPath()) && changeType == ChangeType.MODIFY) {
            this.lastBuildFileChange.put(this.buildFile, System.currentTimeMillis());
            boolean recompiledBuild = this.recompileBuildFile(this.buildFile, this.compileArtifactPaths, this.testArtifactPaths, this.generateFeatures, executor);
            if (recompiledBuild) {
                if (this.recompileDependencies) {
                    this.triggerMainModuleCompile(false);
                } else {
                    if (!this.failedCompilationJavaSources.isEmpty()) {
                        this.triggerJavaSourceRecompile = true;
                    }
                    if (!this.failedCompilationJavaTests.isEmpty()) {
                        this.triggerJavaTestRecompile = true;
                    }
                }
                this.runTestThread(true, executor, n, this.skipUTs, false, this.buildFile);
            }
        } else if (fileChanged.equals(this.containerfileUsed) && directory.startsWith(this.containerfileUsed.getParentFile().getCanonicalFile().toPath()) && changeType == ChangeType.MODIFY) {
            this.untrackContainerfileDirectoriesAndRestart();
        } else if (this.propertyFilesMap != null && this.propertyFilesMap.keySet().contains(fileChanged)) {
            boolean reloadedPropertyFile = this.reloadPropertyFile(fileChanged);
            if (reloadedPropertyFile) {
                this.runTestThread(true, executor, n, this.skipUTs, false, this.buildFile);
            }
        } else if (this.isContainerfileDirectoryChanged(fileChanged)) {
            this.untrackContainerfileDirectoriesAndRestart();
        } else if (!this.recompileDependencies && this.generateFeatures && directory.startsWith(outputPath)) {
            if (fileChanged.exists() && fileChanged.getName().endsWith(".class") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.debug("Java source class file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                this.modifiedClasses.add(fileChanged);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Java source class deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                this.modifiedClasses.remove(fileChanged);
            }
        }
    }

    private void processConfigFileChange(File fileChanged, ChangeType changeType, ThreadPoolExecutor executor, int numApplicationUpdatedMessages, boolean configuredServerXml) throws IOException, PluginExecutionException {
        File fileChangedParentDir;
        boolean isGeneratedFeaturesFile = configuredServerXml ? false : fileChanged.equals(this.generatedFeaturesFile);
        String targetFileName = configuredServerXml ? "server.xml" : null;
        File file = fileChangedParentDir = configuredServerXml ? this.serverXmlFileParent : this.configDirectory;
        if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
            this.debug("Config file modified: " + fileChanged);
            boolean generateFeaturesSuccess = true;
            boolean serverFeaturesModified = this.serverFeaturesModified();
            if (this.generateFeatures && fileChanged.getName().endsWith(".xml") && !isGeneratedFeaturesFile && serverFeaturesModified) {
                generateFeaturesSuccess = this.optimizeGenerateFeatures();
            }
            if (serverFeaturesModified) {
                System.setProperty(SKIP_BETA_INSTALL_WARNING, Boolean.TRUE.toString());
                this.installFeaturesToTempDir(fileChanged, fileChangedParentDir, targetFileName, generateFeaturesSuccess);
            }
            this.copyFile(fileChanged, fileChangedParentDir, this.serverDirectory, targetFileName);
            if (generateFeaturesSuccess && this.generatedFeaturesModified && !isGeneratedFeaturesFile) {
                this.copyFile(this.generatedFeaturesFile, this.configDirectory, this.serverDirectory, null);
                this.generatedFeaturesModified = false;
            }
            if (serverFeaturesModified) {
                this.updateExistingFeatures();
            }
            if (this.isContainerfileDirectoryChanged(this.serverDirectory, fileChanged)) {
                this.untrackContainerfileDirectoriesAndRestart();
            } else {
                if (changeType == ChangeType.CREATE) {
                    this.redeployApp();
                }
                if (fileChanged.getName().equals("server.env")) {
                    this.enableServerDebug(false);
                } else if (fileChanged.getName().equals("bootstrap.properties") && this.bootstrapPropertiesFileParent == null || fileChanged.getName().equals("jvm.options") && this.jvmOptionsFileParent == null) {
                    this.restartServer(false);
                }
            }
            if (isGeneratedFeaturesFile && this.generateFeatures) {
                if (this.isMultiModuleProject()) {
                    this.runTestThread(true, executor, numApplicationUpdatedMessages, false, this.getAllBuildFiles());
                } else {
                    this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false, this.buildFile);
                }
            } else {
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false, this.buildFile);
            }
        } else if (changeType == ChangeType.DELETE) {
            this.info("Config file deleted: " + fileChanged.getName());
            this.deleteFile(fileChanged, fileChangedParentDir, this.serverDirectory, targetFileName);
            if (this.generateFeatures && fileChanged.getName().endsWith(".xml") && !fileChanged.equals(this.generatedFeaturesFile) && this.serverFeaturesModified()) {
                this.optimizeGenerateFeatures();
            }
            if (this.isContainerfileDirectoryChanged(this.serverDirectory, fileChanged)) {
                this.untrackContainerfileDirectoriesAndRestart();
            } else {
                if (fileChanged.getName().equals("server.env")) {
                    this.enableServerDebug(false);
                }
                if (this.container && OSUtil.isLinux()) {
                    this.info("Restarting the container for this change to take effect.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this.debug("Unexpected InterruptedException handling config file deletion.", e);
                    }
                    this.restartServer(false);
                }
            }
            this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false, this.buildFile);
        }
    }

    private ProjectModule getFirstProjectModule(File buildFileChanged) throws IOException {
        for (ProjectModule project : this.upstreamProjects) {
            ProjectModule match = this.getFirstProjectModule(project, buildFileChanged);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private ProjectModule getFirstProjectModule(ProjectModule project, File buildFileChanged) throws IOException {
        List<String> childBuildFiles = this.parentBuildFiles.get(buildFileChanged.getCanonicalPath());
        for (String childBuildPath : childBuildFiles) {
            if (childBuildPath.equals(project.getBuildFile().getCanonicalPath())) {
                return project;
            }
            if (!this.parentBuildFiles.containsKey(childBuildPath)) continue;
            return this.getFirstProjectModule(project, new File(childBuildPath));
        }
        return null;
    }

    protected abstract void resourceDirectoryCreated() throws IOException;

    protected abstract void resourceModifiedOrCreated(File var1, File var2, File var3) throws IOException;

    protected abstract void resourceDeleted(File var1, File var2, File var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackContainerfileDirectoriesAndRestart() throws PluginExecutionException {
        for (WatchKey key : this.containerfileDirectoriesWatchKeys) {
            key.cancel();
        }
        this.containerfileDirectoriesWatchKeys.clear();
        Set<FileAlterationObserver> set = this.cancelledFileObservers;
        synchronized (set) {
            for (FileAlterationObserver observer : this.containerfileDirectoriesFileObservers) {
                this.cancelledFileObservers.add(observer);
                try {
                    observer.destroy();
                }
                catch (Exception e) {
                    this.debug("Could not destroy file observer", e);
                }
            }
        }
        this.containerfileDirectoriesFileObservers.clear();
        this.containerfileDirectoriesTracked.clear();
        this.restartServer(true);
    }

    private boolean isContainerfileDirectoryChanged(File ... files) throws IOException {
        if (this.container && !this.containerfileDirectoriesTracked.isEmpty()) {
            for (Path trackedPath : this.containerfileDirectoriesTracked) {
                Path logsPath = new File(this.serverDirectory, "logs").getCanonicalFile().toPath();
                for (File file : files) {
                    Path filePath = file.getCanonicalFile().toPath();
                    if (!filePath.startsWith(trackedPath) || filePath.startsWith(logsPath) || filePath.toString().endsWith(".war.xml") || filePath.toString().endsWith(".ear.xml")) continue;
                    this.debug("isContainerfileDirectoryChanged=true for directory " + trackedPath + " with file " + file);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isGeneratedConfigFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        return (fileChanged.getName().equals("bootstrap.properties") || fileChanged.getName().equals("jvm.options")) && this.isGeneratedTargetFile(fileChanged, srcDir, targetDir);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isGeneratedTargetFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        File targetFile = this.getTargetFile(fileChanged, srcDir, targetDir, null);
        try (FileReader fileReader = new FileReader(targetFile);){
            boolean bl;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                String line = bufferedReader.readLine();
                bl = line == null ? false : line.matches(GENERATED_HEADER_REGEX);
            }
            return bl;
        }
        catch (IOException e) {
            this.debug("Could not read the target file " + targetFile + ". It will be replaced by the contents of " + fileChanged, e);
            return false;
        }
    }

    public String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public void installFeaturesToTempDir(File fileChanged, File srcDir, String targetFileName, boolean generateFeaturesSuccess) throws IOException {
        if (this.generateFeatures && !generateFeaturesSuccess) {
            return;
        }
        this.tempConfigPath = Files.createTempDirectory("tempConfig", new FileAttribute[0]);
        File tempConfig = this.tempConfigPath.toFile();
        this.debug("Temporary configuration folder created: " + tempConfig);
        FileUtils.copyDirectory((File)this.serverDirectory, (File)tempConfig, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                String parent = pathname.getParentFile().getName();
                String serverDirName = DevUtil.this.serverDirectory.getName();
                boolean skip = DevUtil.this.ignoreFileOrDir(pathname) || pathname.isDirectory() && (name.equals("workarea") || name.equals("logs") || name.equals("messaging") && parent.equals(serverDirName));
                return !skip;
            }
        }, (boolean)true);
        this.copyFile(fileChanged, srcDir, tempConfig, targetFileName);
        if (this.generateFeatures && generateFeaturesSuccess && !fileChanged.equals(this.generatedFeaturesFile)) {
            this.copyFile(this.generatedFeaturesFile, srcDir, tempConfig, this.generatedFeaturesFile.getName());
        }
        this.installFeatures(fileChanged, tempConfig, this.generateFeatures);
        this.cleanUpTempConfig();
    }

    private boolean ignoreFileOrDir(File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            for (String prefix : IGNORE_DIRECTORY_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        } else {
            for (String prefix : IGNORE_FILE_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
            for (String postfix : IGNORE_FILE_POSTFIXES) {
                if (!name.endsWith(postfix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        }
        return false;
    }

    public void copyFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        File targetResource = this.getTargetFile(fileChanged, srcDir, targetDir, targetFileName);
        try {
            FileUtils.copyFile((File)fileChanged, (File)targetResource);
            this.info("Copied file: " + fileChanged.getCanonicalPath() + " to: " + targetResource.getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            this.debug("Failed to copy file: " + fileChanged.getCanonicalPath());
        }
        catch (Exception ex) {
            this.debug(ex);
        }
    }

    private File getTargetFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        String relPath = fileChanged.getCanonicalPath().substring(fileChanged.getCanonicalPath().indexOf(srcDir.getCanonicalPath()) + srcDir.getCanonicalPath().length());
        if (targetFileName != null) {
            relPath = relPath.substring(0, relPath.indexOf(fileChanged.getName())) + targetFileName;
        }
        File targetResource = new File(targetDir.getCanonicalPath() + relPath);
        return targetResource;
    }

    protected void deleteFile(File deletedFile, File dir, File targetDir, String targetFileName) throws IOException {
        File targetFile = this.getTargetFile(deletedFile, dir, targetDir, targetFileName);
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)targetFile);
                    this.info("The directory " + targetFile.getCanonicalPath() + " was deleted.");
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not delete the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
                catch (IOException e) {
                    this.error("An error encountered while deleting the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
            } else if (targetFile.delete()) {
                this.info("The file " + targetFile.getCanonicalPath() + " was deleted.");
            } else {
                this.error("Could not delete the file " + targetFile.getCanonicalPath() + ".");
            }
        }
    }

    protected void cleanTargetDir(File outputDirectory) {
        File[] fList = outputDirectory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && file.getName().toLowerCase().endsWith(".class")) {
                    file.delete();
                    this.info("Deleted Java class file: " + file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.cleanTargetDir(file);
            }
        }
        if (outputDirectory.listFiles().length == 0) {
            outputDirectory.delete();
        }
    }

    protected void registerAll(Path start, ThreadPoolExecutor executor) throws IOException {
        this.registerAll(start, executor, false);
    }

    protected void registerAll(Path start, final ThreadPoolExecutor executor, final boolean removeOnContainerRebuild) throws IOException {
        this.debug("Registering all files in directory: " + start.toString());
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileVisitResult preVisitDirectory(final Path dir, BasicFileAttributes attrs) throws IOException {
                if (DevUtil.this.trackingMode == FileTrackMode.POLLING || DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    Set set = DevUtil.this.newFileObservers;
                    synchronized (set) {
                        HashSet tempCombinedObservers = new HashSet();
                        tempCombinedObservers.addAll(DevUtil.this.fileObservers);
                        tempCombinedObservers.addAll(DevUtil.this.newFileObservers);
                        for (FileAlterationObserver observer : tempCombinedObservers) {
                            if (!dir.equals(observer.getDirectory().getCanonicalFile().toPath())) continue;
                            DevUtil.this.debug("Skipping subdirectory " + dir.toString() + " since it already being observed");
                            return FileVisitResult.CONTINUE;
                        }
                        for (File omitFile : DevUtil.this.omitWatchingFiles) {
                            if (!dir.startsWith(omitFile.getCanonicalPath() + File.separator)) continue;
                            DevUtil.this.debug("Skipping subdirectory " + dir.toString() + " since it is in the omit files list");
                            return FileVisitResult.CONTINUE;
                        }
                        FileFilter singleDirectoryFilter = new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                try {
                                    if (dir.equals(file.getParentFile().getCanonicalFile().toPath())) {
                                        return true;
                                    }
                                }
                                catch (IOException e) {
                                    return false;
                                }
                                return false;
                            }
                        };
                        try {
                            FileAlterationObserver observer;
                            DevUtil.this.debug("Adding subdirectory to file observers: " + dir.toString());
                            observer = DevUtil.this.addFileAlterationObserver(executor, dir.toString(), singleDirectoryFilter);
                            if (removeOnContainerRebuild) {
                                DevUtil.this.debug("Adding to containerfileDirectoriesFileObservers: " + dir);
                                DevUtil.this.containerfileDirectoriesFileObservers.add(observer);
                            }
                        }
                        catch (Exception e) {
                            DevUtil.this.error("Could not observe directory " + dir.toString(), e);
                        }
                    }
                }
                if (DevUtil.this.trackingMode == FileTrackMode.FILE_WATCHER || DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    DevUtil.this.debug("Adding subdirectory to WatchService: " + dir.toString());
                    WatchKey key = dir.register(DevUtil.this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
                    if (removeOnContainerRebuild) {
                        DevUtil.this.debug("Adding to containerfileDirectoriesWatchKeys: " + dir);
                        DevUtil.this.containerfileDirectoriesWatchKeys.add(key);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected File getFileFromConfigDirectory(String file) {
        File f = new File(this.configDirectory, file);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    protected void deleteJavaFile(File fileChanged, File classesDir, File compileSourceRoot) throws IOException {
        String relPath;
        String fileName = fileChanged.getName();
        File parentFile = fileChanged.getParentFile();
        boolean javaFile = fileName.endsWith(".java");
        if (javaFile) {
            fileName = fileName.substring(0, fileChanged.getName().indexOf(".java"));
            relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName + ".class";
        } else {
            relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName;
        }
        File targetFile = new File(classesDir.getCanonicalPath() + relPath);
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)targetFile);
                    this.info("The target directory " + targetFile.getCanonicalPath() + " was deleted.");
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not delete directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
                catch (IOException e) {
                    this.error("There was an error encountered while deleting the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
            } else if (targetFile.delete()) {
                this.info("The java class " + targetFile.getCanonicalPath() + " was deleted.");
            } else {
                this.error("Could not delete the file " + targetFile.getCanonicalPath() + ". ");
            }
        } else {
            this.debug("File deleted but could not find corresponding file or folder in the target directory: " + fileChanged.getCanonicalPath() + ".");
        }
    }

    protected boolean recompileJavaSource(Collection<File> javaFilesChanged, Set<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory, String projectName, File projectBuildFile, JavaCompilerOptions projectCompilerOptions, boolean forceSkipUTs, boolean skipRunningTests) throws PluginExecutionException {
        return this.recompileJava(javaFilesChanged, artifactPaths, executor, false, outputDirectory, testOutputDirectory, projectName, projectBuildFile, projectCompilerOptions, forceSkipUTs, skipRunningTests);
    }

    protected boolean recompileJavaTest(Collection<File> javaFilesChanged, Set<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory, String projectName, File projectBuildFile, JavaCompilerOptions projectCompilerOptions, boolean forceSkipUTs, boolean skipRunningTests) throws PluginExecutionException {
        return this.recompileJava(javaFilesChanged, artifactPaths, executor, true, outputDirectory, testOutputDirectory, projectName, projectBuildFile, projectCompilerOptions, forceSkipUTs, skipRunningTests);
    }

    protected boolean recompileJava(Collection<File> javaFilesChanged, Set<String> artifactPaths, ThreadPoolExecutor executor, boolean tests, File outputDirectory, File testOutputDirectory, String projectName, File projectBuildFile, JavaCompilerOptions projectCompilerOptions, boolean forceSkipUTs, boolean skipRunningTests) throws PluginExecutionException {
        try {
            boolean compileResult;
            int messageOccurrences = this.countApplicationUpdatedMessages();
            if (this.useBuildRecompile) {
                compileResult = this.compile(tests ? this.testSourceDirectory : this.sourceDirectory);
            } else {
                File classesDir;
                File file = classesDir = tests ? testOutputDirectory : outputDirectory;
                if (!classesDir.exists()) {
                    if (!classesDir.mkdirs()) {
                        throw new PluginExecutionException("The classes output directory " + classesDir.getAbsolutePath() + " does not exist and cannot be created.");
                    }
                    if (classesDir.exists() && Objects.equals(classesDir.getCanonicalFile(), outputDirectory.getCanonicalFile())) {
                        this.redeployApp();
                    }
                }
                ArrayList<String> combinedCompilerOptions = new ArrayList<String>(Arrays.asList(DEFAULT_COMPILER_OPTIONS));
                if (projectCompilerOptions != null) {
                    combinedCompilerOptions.addAll(projectCompilerOptions.getOptions());
                }
                this.debug("Compiler options: " + combinedCompilerOptions);
                ArrayList<File> outputDirs = new ArrayList<File>();
                if (tests) {
                    outputDirs.add(outputDirectory);
                    outputDirs.add(testOutputDirectory);
                } else {
                    outputDirs.add(outputDirectory);
                }
                Set<File> classPathElems = this.getClassPath(artifactPaths, outputDirs);
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                fileManager.setLocation(StandardLocation.CLASS_PATH, classPathElems);
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(classesDir));
                HashSet<JavaFileObject> compilationUnits = new HashSet<JavaFileObject>();
                for (File file2 : javaFilesChanged) {
                    if (file2.exists() && file2.isFile()) {
                        for (JavaFileObject javaFileObject : fileManager.getJavaFileObjects(file2)) {
                            compilationUnits.add(javaFileObject);
                        }
                        continue;
                    }
                    this.debug("The Java file " + file2 + " does not exist and will not be compiled.");
                }
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, combinedCompilerOptions, null, compilationUnits);
                compileResult = task.call();
            }
            if (compileResult) {
                if (tests) {
                    if (projectName != null) {
                        this.info(projectName + " tests compilation was successful.");
                    } else {
                        this.info("Tests compilation was successful.");
                    }
                } else {
                    if (!this.isLooseApplication()) {
                        this.redeployApp();
                    }
                    if (projectName != null) {
                        this.info(projectName + " source compilation was successful.");
                    } else {
                        this.info("Source compilation was successful.");
                    }
                }
                if (!skipRunningTests) {
                    if (tests) {
                        this.runTestThread(false, executor, -1, this.skipUTs, false, projectBuildFile);
                    } else if (!this.generateFeatures) {
                        this.runTestThread(true, executor, messageOccurrences, this.skipUTs, false, projectBuildFile);
                    }
                }
                return true;
            }
            if (tests) {
                if (projectName != null) {
                    this.info(projectName + " tests compilation had errors.");
                } else {
                    this.info("Tests compilation had errors.");
                }
            } else if (projectName != null) {
                this.info(projectName + " source compilation had errors.");
            } else {
                this.info("Source compilation had errors.");
            }
            return false;
        }
        catch (Exception e) {
            if (projectName != null) {
                this.error(projectName + " error compiling Java files: " + e.getMessage());
            } else {
                this.error("Error compiling Java files: " + e.getMessage());
            }
            this.debug(e);
            return false;
        }
    }

    protected Set<File> getClassPath(Set<String> artifactPaths, List<File> outputDirs) throws IOException {
        HashSet<String> parsedFiles = new HashSet<String>();
        ArrayDeque<String> toParse = new ArrayDeque<String>();
        for (String artifactPath : artifactPaths) {
            toParse.add(new File(artifactPath).getCanonicalPath());
        }
        HashSet<File> classPathElements = new HashSet<File>();
        classPathElements.addAll(outputDirs);
        while (!toParse.isEmpty()) {
            String s = (String)toParse.poll();
            if (parsedFiles.contains(s)) continue;
            parsedFiles.add(s);
            File file = new File(s);
            if (file.exists() && file.getName().endsWith(".jar")) {
                classPathElements.add(file);
                if (file.isDirectory()) continue;
                try {
                    JarFile jar = new JarFile(file);
                    try {
                        Object classPath;
                        Manifest mf = jar.getManifest();
                        if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                        for (String i : classPath.toString().split(" ")) {
                            File f;
                            try {
                                URL u = new URL(i);
                                f = new File(u.getPath());
                            }
                            catch (MalformedURLException e) {
                                f = new File(file.getParentFile(), i);
                            }
                            if (!f.exists()) continue;
                            toParse.add(f.getCanonicalPath());
                        }
                        continue;
                    }
                    finally {
                        jar.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to open class path file " + file, e);
                }
            }
            if (!file.isDirectory() || classPathElements.contains(file)) continue;
            this.debug("Adding directory to compile class path: " + file);
            classPathElements.add(file);
        }
        return classPathElements;
    }

    public void runTestThread(boolean waitForApplicationUpdate, ThreadPoolExecutor executor, int messageOccurrences, boolean manualInvocation, File ... currentBuildFiles) {
        this.runTestThread(waitForApplicationUpdate, executor, messageOccurrences, this.skipUTs, manualInvocation, currentBuildFiles);
    }

    public void runTestThread(boolean waitForApplicationUpdate, ThreadPoolExecutor executor, int messageOccurrences, boolean skipUnitTests, boolean manualInvocation, File ... currentBuildFiles) {
        try {
            if (manualInvocation || this.hotTests) {
                executor.execute(new TestJob(waitForApplicationUpdate, messageOccurrences, executor, skipUnitTests, manualInvocation, currentBuildFiles));
            }
        }
        catch (RejectedExecutionException e) {
            this.debug("Cannot add thread since max threads reached", e);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setLibertyDebugPort(int libertyDebugPort) {
        this.libertyDebugPort = libertyDebugPort;
    }

    private boolean reloadPropertyFile(File propertyFile) throws PluginExecutionException {
        Properties properties = this.readPropertiesFromFile(propertyFile);
        if (!Objects.equals(properties, this.propertyFilesMap.get(propertyFile))) {
            this.debug("Properties file " + propertyFile.getAbsolutePath() + " has changed. Restarting server...");
            this.propertyFilesMap.put(propertyFile, properties);
            this.restartServer();
            return true;
        }
        this.debug("No changes detected in properties file " + propertyFile.getAbsolutePath());
        return false;
    }

    public void setPropertyFiles(List<File> propertyFiles) {
        if (propertyFiles == null) {
            return;
        }
        if (this.propertyFilesMap == null) {
            this.propertyFilesMap = new HashMap<File, Properties>(propertyFiles.size());
        }
        for (File propertyFile : propertyFiles) {
            Properties properties = this.readPropertiesFromFile(propertyFile);
            this.propertyFilesMap.put(propertyFile, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readPropertiesFromFile(File propertyFile) {
        Properties properties = null;
        if (propertyFile.exists()) {
            InputStream inputStream = null;
            try {
                this.debug("Loading properties from file: " + propertyFile);
                inputStream = new FileInputStream(propertyFile);
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (IOException e) {
                this.error("Could not read properties file " + propertyFile.getAbsolutePath(), e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public Set<String> getCompileArtifacts() {
        return this.compileArtifactPaths;
    }

    public Set<String> getTestArtifacts() {
        return this.testArtifactPaths;
    }

    public void updateJavaCompilerOptions(JavaCompilerOptions updatedCompilerOptions) {
        this.compilerOptions = updatedCompilerOptions;
    }

    public ProjectModule getProjectModule(File buildFile) throws IOException {
        if (this.isMultiModuleProject()) {
            for (ProjectModule p : this.upstreamProjects) {
                if (!p.getBuildFile().getCanonicalPath().equals(buildFile.getCanonicalPath())) continue;
                return p;
            }
        }
        return null;
    }

    public boolean isMultiModuleProject() {
        return this.upstreamProjects != null && !this.upstreamProjects.isEmpty();
    }

    private File[] getAllBuildFiles() {
        File[] buildFiles = new File[this.upstreamProjects.size() + 1];
        int count = 0;
        for (ProjectModule project : this.upstreamProjects) {
            buildFiles[count] = project.getBuildFile();
            ++count;
        }
        buildFiles[count] = this.buildFile;
        return buildFiles;
    }

    private File[] getAllBuildFiles(ProjectModule currentProject) {
        List<File> dependentModuleBuildFiles = currentProject.getDependentModules();
        File[] buildFiles = new File[dependentModuleBuildFiles.size() + 1];
        buildFiles[0] = currentProject.getBuildFile();
        int count = 1;
        Iterator<File> iterator = dependentModuleBuildFiles.iterator();
        while (iterator.hasNext()) {
            File buildFile;
            buildFiles[count] = buildFile = iterator.next();
            ++count;
        }
        return buildFiles;
    }

    protected void triggerMainModuleCompile(boolean testsOnly) throws IOException {
        this.triggerProjectCompile(this.sourceDirectory, this.recompileJavaSources, this.testSourceDirectory, this.recompileJavaTests, testsOnly, this.packagingType);
    }

    protected void triggerUpstreamModuleCompile(ProjectModule project, boolean testsOnly) throws IOException {
        this.triggerProjectCompile(project.getSourceDirectory(), project.recompileJavaSources, project.getTestSourceDirectory(), project.recompileJavaTests, testsOnly, project.getPackagingType());
    }

    private void triggerProjectCompile(File sourceDir, Collection<File> recompileJavaSourceSet, File testSourceDir, Collection<File> recompileJavaTestSet, boolean testsOnly, String packagingType) throws IOException {
        if (!testsOnly && this.shouldIncludeSources(packagingType) && sourceDir.exists()) {
            Collection allJavaSources = FileUtils.listFiles((File)sourceDir.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            recompileJavaSourceSet.addAll(allJavaSources);
        }
        if (testSourceDir.exists()) {
            Collection allJavaTestSources = FileUtils.listFiles((File)testSourceDir.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            recompileJavaTestSet.addAll(allJavaTestSources);
        }
    }

    private boolean compileModuleForBuildFile(File moduleBuildFile, boolean testsOnly, ThreadPoolExecutor executor) throws IOException, PluginExecutionException {
        if (moduleBuildFile.getCanonicalPath().equals(this.buildFile.getCanonicalPath())) {
            this.debug("recompileDependencies is set to true, recompiling the entire module for " + moduleBuildFile.getCanonicalPath());
            this.disableDependencyCompile = true;
            return this.compileAllClasses(testsOnly, executor);
        }
        for (ProjectModule project : this.upstreamProjects) {
            if (!moduleBuildFile.getCanonicalPath().equals(project.getBuildFile().getCanonicalPath())) continue;
            this.debug("recompileDependencies is set to true, recompiling the entire module for " + moduleBuildFile.getCanonicalPath());
            project.disableDependencyCompile = true;
            return this.compileAllClasses(project, testsOnly, executor);
        }
        return false;
    }

    private boolean compileAllClasses(boolean tests, ThreadPoolExecutor executor) throws PluginExecutionException, IOException {
        return this.compileAllClasses(this.sourceDirectory, this.testSourceDirectory, this.packagingType, this.compileArtifactPaths, this.testArtifactPaths, this.outputDirectory, this.testOutputDirectory, this.getProjectName(), this.buildFile, this.compilerOptions, this.skipUTs, this.failedCompilationJavaSources, this.failedCompilationJavaTests, tests, executor);
    }

    private boolean compileAllClasses(ProjectModule project, boolean tests, ThreadPoolExecutor executor) throws IOException, PluginExecutionException {
        return this.compileAllClasses(project.getSourceDirectory(), project.getTestSourceDirectory(), project.getPackagingType(), project.getCompileArtifacts(), project.getTestArtifacts(), project.getOutputDirectory(), project.getTestOutputDirectory(), project.getProjectName(), project.getBuildFile(), project.getCompilerOptions(), project.skipUTs(), project.failedCompilationJavaSources, project.failedCompilationJavaTests, tests, executor);
    }

    private boolean compileAllClasses(File sourceDir, File testSourceDir, String packagingType, Set<String> compileArtifactPaths, Set<String> testArtifactPaths, File outputDir, File testOutputDir, String projectName, File buildFile, JavaCompilerOptions compilerOptions, boolean skipUTs, Collection<File> failedCompilationJavaSources, Collection<File> failedCompilationJavaTests, boolean tests, ThreadPoolExecutor executor) throws IOException, PluginExecutionException {
        boolean successfulCompilation = true;
        if (!tests && this.shouldIncludeSources(packagingType) && sourceDir.exists()) {
            Collection allJavaSources = FileUtils.listFiles((File)sourceDir.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            this.debug("Recompiling Java source files: " + allJavaSources);
            if (this.recompileJavaSource(allJavaSources, compileArtifactPaths, executor, outputDir, testOutputDir, projectName, buildFile, compilerOptions, skipUTs, true)) {
                failedCompilationJavaSources.clear();
            } else {
                successfulCompilation = false;
                failedCompilationJavaSources.addAll(this.recompileJavaSources);
            }
        }
        if (testSourceDir.exists()) {
            Collection allJavaTestSources = FileUtils.listFiles((File)testSourceDir.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            this.debug("Recompiling Java test files: " + allJavaTestSources);
            if (this.recompileJavaTest(allJavaTestSources, testArtifactPaths, executor, outputDir, testOutputDir, projectName, buildFile, compilerOptions, skipUTs, true)) {
                failedCompilationJavaTests.clear();
            } else {
                successfulCompilation = false;
                failedCompilationJavaTests.addAll(this.recompileJavaTests);
            }
        }
        return successfulCompilation;
    }

    private boolean shouldRecompileDependencies(ProjectModule project) {
        return !project.disableDependencyCompile && this.recompileDependencies && !this.initialCompile;
    }

    private boolean isUpstreamSourceDir(File dirAdded) {
        try {
            if (this.isMultiModuleProject()) {
                for (ProjectModule p : this.upstreamProjects) {
                    if (!p.getSourceDirectory().getCanonicalPath().startsWith(dirAdded.getCanonicalPath() + File.separator)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean classesFailingToCompile() {
        boolean failingClasses = false;
        if (this.isMultiModuleProject()) {
            for (ProjectModule p : this.upstreamProjects) {
                if (p.failedCompilationJavaSources.isEmpty()) continue;
                failingClasses = true;
            }
        }
        if (!this.failedCompilationJavaSources.isEmpty()) {
            failingClasses = true;
        }
        return failingClasses;
    }

    private boolean serverFeaturesModified() {
        HashSet<String> features;
        ServerFeatureUtil servUtil = this.getServerFeatureUtilObj();
        Set<String> generatedFeatureSet = null;
        Set<String> featuresExcludingGenerated = null;
        if (this.generateFeatures) {
            generatedFeatureSet = servUtil.getServerXmlFeatures(null, this.serverDirectory, this.generatedFeaturesFile, null, null);
            HashSet<String> generatedFiles = new HashSet<String>();
            generatedFiles.add(this.generatedFeaturesFile.getName());
            featuresExcludingGenerated = servUtil.getServerFeatures(this.configDirectory, this.serverXmlFile, new HashMap<String, File>(), generatedFiles);
            if (featuresExcludingGenerated != null && generatedFeatureSet != null && !Collections.disjoint(featuresExcludingGenerated, generatedFeatureSet)) {
                return true;
            }
        } else {
            featuresExcludingGenerated = servUtil.getServerFeatures(this.configDirectory, this.serverXmlFile, new HashMap<String, File>(), null);
        }
        HashSet<String> hashSet = features = featuresExcludingGenerated != null ? new HashSet<String>(featuresExcludingGenerated) : new HashSet();
        if (generatedFeatureSet != null) {
            features.addAll(generatedFeatureSet);
        }
        return !features.equals(this.getExistingFeatures());
    }

    private boolean generatedFeaturesModified() {
        Set<String> updatedGeneratedFeatures = this.getGeneratedFeatures();
        if (!updatedGeneratedFeatures.equals(this.generatedFeaturesSet)) {
            this.generatedFeaturesSet = updatedGeneratedFeatures;
            return true;
        }
        return false;
    }

    private Set<String> getGeneratedFeatures() {
        ServerFeatureUtil servUtil = this.getServerFeatureUtilObj();
        HashSet<String> genFeatSet = new HashSet<String>();
        servUtil.getServerXmlFeatures(genFeatSet, this.configDirectory, this.generatedFeaturesFile, null, null);
        return genFeatSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDevcMetadata(boolean alive) {
        File metaFile = new File(this.buildDirectory, this.serverDirectory.getName() + "-liberty-devc-metadata.xml");
        FileWriter metaFileWriter = null;
        XMLStreamWriter metadataWriter = null;
        try {
            metaFileWriter = new FileWriter(metaFile);
            metadataWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(metaFileWriter);
            metadataWriter.writeStartDocument();
            metadataWriter.writeStartElement("devcModeMetaData");
            this.writeElement(metadataWriter, "containerType", this.isDocker ? DEVC_CONTAINER_DOCKER : DEVC_CONTAINER_PODMAN);
            this.writeElement(metadataWriter, "containerName", this.containerName != null ? this.containerName : DEVMODE_CONTAINER_BASE_NAME);
            this.writeElement(metadataWriter, "imageName", this.imageName);
            if (this.containerfile != null) {
                this.writeElement(metadataWriter, "containerfile", this.containerfile.getCanonicalPath());
            }
            if (this.containerBuildContext != null) {
                this.writeElement(metadataWriter, "containerBuildContext", this.containerBuildContext.getCanonicalPath());
            }
            this.writeElement(metadataWriter, "containerAlive", String.valueOf(alive));
            this.writeElement(metadataWriter, "containerBuildTimeout", Integer.toString(this.containerBuildTimeout));
            this.writeElement(metadataWriter, "containerRunOpts", this.containerRunOpts);
            metadataWriter.writeEndElement();
            metadataWriter.writeEndDocument();
        }
        catch (Exception e) {
            this.warn("Failed to write metadata.\n" + e.getMessage());
        }
        finally {
            try {
                if (metadataWriter != null) {
                    metadataWriter.flush();
                    metadataWriter.close();
                }
                if (metaFileWriter != null) {
                    metaFileWriter.flush();
                    metaFileWriter.close();
                }
            }
            catch (Exception e) {
                this.warn("Failed to close metadata writer due to an error.\n" + e.getMessage());
            }
        }
    }

    private void writeElement(XMLStreamWriter writer, String element, String optional) throws XMLStreamException {
        writer.writeStartElement(element);
        if (optional != null) {
            writer.writeCharacters(optional);
        }
        writer.writeEndElement();
    }

    public class TestJob
    implements Runnable {
        private boolean waitForApplicationUpdate;
        private int messageOccurrences;
        private ThreadPoolExecutor executor;
        private boolean skipUnitTests;
        private boolean manualInvocation;
        private File[] currentBuildFiles;

        public TestJob(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean skipUnitTests, boolean manualInvocation, File ... currentBuildFiles) {
            this.waitForApplicationUpdate = waitForApplicationUpdate;
            this.messageOccurrences = messageOccurrences;
            this.executor = executor;
            this.skipUnitTests = skipUnitTests;
            this.manualInvocation = manualInvocation;
            this.currentBuildFiles = currentBuildFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.currentBuildFiles.length >= 1) {
                    for (File currentBuildFile : this.currentBuildFiles) {
                        boolean currentProjForceSkipUTs = this.skipUnitTests;
                        boolean currentProjForceSkipITs = DevUtil.this.skipITs;
                        boolean currentProjSkipTests = DevUtil.this.skipTests;
                        String currentProjName = DevUtil.this.applicationId;
                        if (DevUtil.this.isMultiModuleProject()) {
                            for (ProjectModule upstreamProject : DevUtil.this.upstreamProjects) {
                                if (!upstreamProject.getBuildFile().equals(currentBuildFile)) continue;
                                currentProjForceSkipUTs = upstreamProject.skipUTs();
                                currentProjForceSkipITs = upstreamProject.skipITs();
                                currentProjSkipTests = upstreamProject.skipTests();
                                currentProjName = upstreamProject.getProjectName();
                                break;
                            }
                            DevUtil.this.runTests(this.waitForApplicationUpdate, this.messageOccurrences, this.executor, currentProjSkipTests, currentProjForceSkipUTs, currentProjForceSkipITs, currentBuildFile, currentProjName);
                            continue;
                        }
                        DevUtil.this.runTests(this.waitForApplicationUpdate, this.messageOccurrences, this.executor, currentProjSkipTests, currentProjForceSkipUTs, currentProjForceSkipITs, currentBuildFile, null);
                    }
                } else {
                    DevUtil.this.runTests(this.waitForApplicationUpdate, this.messageOccurrences, this.executor, DevUtil.this.skipTests, DevUtil.this.skipUTs, DevUtil.this.skipITs, null, null);
                }
            }
            finally {
                DevUtil.this.runHotkeyReaderThread(this.executor);
            }
        }

        public boolean isManualInvocation() {
            return this.manualInvocation;
        }
    }

    private static enum ChangeType {
        CREATE,
        DELETE,
        MODIFY;

    }

    private class HotkeyReader
    implements Runnable {
        private Scanner scanner;
        private ThreadPoolExecutor executor;
        private boolean shutdown = false;

        public HotkeyReader(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public void run() {
            DevUtil.this.debug("Running hotkey reader thread");
            this.scanner = new Scanner((InputStream)new CloseShieldInputStream(System.in));
            try {
                this.readInput();
            }
            finally {
                this.scanner.close();
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readInput() {
            HotKey q = new HotKey("q", "quit", "exit");
            HotKey h = new HotKey("h", "help");
            HotKey r = new HotKey("r");
            HotKey g = new HotKey("g");
            HotKey o = new HotKey("o");
            HotKey enter = new HotKey("");
            if (this.scanner.hasNextLine()) {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.notify();
                }
                while (!this.shutdown) {
                    DevUtil.this.debug("Waiting for Enter key to run tests");
                    if (this.scanner.hasNextLine()) {
                        String line = this.scanner.nextLine();
                        if (q.isPressed(line)) {
                            DevUtil.this.debug("Detected exit command");
                            DevUtil.this.runShutdownHook(this.executor);
                            continue;
                        }
                        if (r.isPressed(line)) {
                            DevUtil.this.debug("Detected restart command");
                            try {
                                DevUtil.this.restartServer(true);
                            }
                            catch (PluginExecutionException e) {
                                DevUtil.this.debug("Exiting dev mode due to server restart failure");
                                DevUtil.this.error("Could not restart the server.", e);
                                DevUtil.this.runShutdownHook(this.executor);
                            }
                            continue;
                        }
                        if (h.isPressed(line)) {
                            DevUtil.this.info(DevUtil.this.formatAttentionBarrier());
                            DevUtil.this.printHelpMessages();
                            DevUtil.this.info(DevUtil.this.formatAttentionBarrier());
                            continue;
                        }
                        if (g.isPressed(line)) {
                            DevUtil.this.toggleFeatureGeneration();
                            continue;
                        }
                        if (o.isPressed(line)) {
                            if (DevUtil.this.generateFeatures) {
                                DevUtil.this.optimizeGenerateFeatures();
                                continue;
                            }
                            DevUtil.this.warn("Cannot optimize features because automatic generation of features is off.");
                            DevUtil.this.warn("To toggle the automatic generation of features, type 'g' and press Enter.");
                            continue;
                        }
                        if (enter.isPressed(line)) {
                            DevUtil.this.debug("Detected Enter key. Running tests... ");
                            if (DevUtil.this.isMultiModuleProject()) {
                                DevUtil.this.runTestThread(false, this.executor, -1, true, DevUtil.this.getAllBuildFiles());
                                continue;
                            }
                            DevUtil.this.runTestThread(false, this.executor, -1, true, DevUtil.this.buildFile);
                            continue;
                        }
                        DevUtil.this.warn("Unrecognized command: " + line + ". To see the help menu, type 'h' and press Enter.");
                        continue;
                    }
                    break;
                }
            } else {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.set(true);
                    DevUtil.this.inputUnavailable.notify();
                }
            }
        }
    }

    private static enum FileTrackMode {
        NOT_SET,
        FILE_WATCHER,
        POLLING;

    }
}

