/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant;

import io.openliberty.tools.ant.AbstractTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class DeployTask
extends AbstractTask {
    private static final String START_APP_MESSAGE_CODE_REG = "CWWKZ0001I.*";
    private static final long APP_START_TIMEOUT_DEFAULT = 30000L;
    private final List<FileSet> fileSets = new ArrayList<FileSet>();
    private File appFile;
    private String deployName;
    private String timeout;

    public void execute() {
        super.initTask();
        if (this.appFile == null && this.fileSets.size() == 0) {
            throw new BuildException(this.getMessage("error.fileset.set", new Object[0]), this.getLocation());
        }
        if (this.deployName != null && this.appFile == null) {
            throw new BuildException(this.getMessage("error.file.set", new Object[0]), this.getLocation());
        }
        long appStartTimeout = 30000L;
        if (this.timeout != null && !this.timeout.equals("")) {
            appStartTimeout = Long.valueOf(this.timeout);
        }
        File dropInFolder = new File(this.serverConfigDir, "dropins");
        if (this.appFile != null) {
            if (!this.appFile.exists()) {
                throw new BuildException(this.getMessage("error.deploy.file.noexist", this.appFile), this.getLocation());
            }
            if (this.appFile.isDirectory()) {
                throw new BuildException(this.getMessage("error.deploy.file.isdirectory", this.appFile), this.getLocation());
            }
            File destFile = new File(dropInFolder, this.deployName == null ? this.appFile.getName() : this.deployName);
            this.deploy(appStartTimeout, this.appFile, destFile);
        }
        List<File> files = this.scanFileSets();
        for (File file : files) {
            File destFile = new File(dropInFolder, file.getName());
            this.deploy(appStartTimeout, file, destFile);
        }
    }

    private void deploy(long appStartTimeout, File srcFile, File destFile) {
        this.log(this.getMessage("info.deploy.app", srcFile.getPath()));
        try {
            FileUtils.getFileUtils().copyFile(srcFile, destFile, null, true);
        }
        catch (IOException e) {
            throw new BuildException(this.getMessage("error.deploy.fail", new Object[0]));
        }
        String startMessage = START_APP_MESSAGE_CODE_REG + this.getFileName(destFile.getName());
        if (this.waitForStringInLog(startMessage, appStartTimeout, this.getLogFile()) == null) {
            throw new BuildException(this.getMessage("error.deploy.fail", srcFile.getPath()));
        }
    }

    public void addFileset(FileSet fs) {
        this.fileSets.add(fs);
    }

    public void setFile(File appFile) {
        this.appFile = appFile;
    }

    private List<File> scanFileSets() {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < this.fileSets.size(); ++i) {
            String[] names;
            FileSet fs = this.fileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            for (String element : names = ds.getIncludedFiles()) {
                list.add(new File(ds.getBasedir(), element));
            }
        }
        return list;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getDeployName() {
        return this.deployName;
    }

    public void setDeployName(String name) {
        if (name != null && (name = name.trim()).isEmpty()) {
            throw new BuildException(this.getMessage("error.parameter.empty", "deployName"));
        }
        this.deployName = name;
    }
}

