/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant.install;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final int WILDCARD = -1;
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    private Version(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public static Version parseVersion(String version) {
        return Version.parseVersion(version, false);
    }

    public static Version parseVersion(String version, boolean wildcard) {
        Pattern p = null;
        p = wildcard ? Pattern.compile("^([\\d\\+]+)(?:\\.([\\d\\+]+))?(?:\\.([\\d\\+]+))?(?:\\_(.*))?$") : Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\_(.*))?$");
        Matcher m = p.matcher(version);
        if (m.find()) {
            int major = Version.parseComponent(m.group(1));
            int minor = Version.parseComponent(m.group(2));
            int micro = Version.parseComponent(m.group(3));
            String qualifier = m.group(4);
            return new Version(major, minor, micro, qualifier);
        }
        throw new IllegalArgumentException("Invalid version: " + version);
    }

    private static int parseComponent(String version) {
        if (version == null) {
            return 0;
        }
        if ("+".equals(version)) {
            return -1;
        }
        return Integer.parseInt(version);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }

    public boolean match(Version version) {
        if (this.major == -1) {
            return true;
        }
        if (this.major != version.major) {
            return false;
        }
        if (this.minor == -1) {
            return true;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.micro == -1) {
            return true;
        }
        if (this.micro != version.micro) {
            return false;
        }
        if ("+".equals(this.qualifier)) {
            return true;
        }
        if (this.qualifier == null) {
            return version.qualifier == null;
        }
        return this.qualifier.equals(version.qualifier);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.major == -1) {
            result.append('+');
        } else {
            result.append(this.major);
            result.append('.');
            if (this.minor == -1) {
                result.append('+');
            } else {
                result.append(this.minor);
                result.append('.');
                if (this.micro == -1) {
                    result.append('+');
                } else {
                    result.append(this.micro);
                    if (this.qualifier != null) {
                        result.append('_');
                        result.append(this.qualifier);
                    }
                }
            }
        }
        return result.toString();
    }
}

