/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.utils;

import java.io.PrintStream;
import java.util.Objects;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntTaskFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AntTaskFactory.class);
    private final Project ant = new Project();

    private AntTaskFactory(MavenProject mavenProject) {
        this.ant.setBaseDir(mavenProject.getBasedir());
        this.initAntLogger(this.ant);
        this.ant.init();
    }

    protected void initAntLogger(Project ant) {
        Slf4jLoggingBuildListener antLogger = new Slf4jLoggingBuildListener(LOG);
        antLogger.setEmacsMode(true);
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        if (LOG.isDebugEnabled()) {
            antLogger.setMessageOutputLevel(3);
        } else {
            antLogger.setMessageOutputLevel(2);
        }
        ant.addBuildListener((BuildListener)antLogger);
    }

    public static AntTaskFactory forMavenProject(MavenProject mavenProject) {
        return new AntTaskFactory(mavenProject);
    }

    public <T extends Task> T createTask(String taskName) {
        return (T)this.ant.createTask(taskName);
    }

    static class Slf4jLoggingBuildListener
    extends DefaultLogger {
        private final Logger logger;

        public Slf4jLoggingBuildListener(Logger logger) {
            this.logger = Objects.requireNonNull(logger);
        }

        protected void printMessage(String message, PrintStream stream, int priority) {
            switch (priority) {
                case 0: {
                    this.logger.error(message);
                    break;
                }
                case 1: {
                    this.logger.warn(message);
                    break;
                }
                case 2: {
                    this.logger.info(message);
                    break;
                }
                case 4: {
                    this.logger.debug(message);
                    break;
                }
                case 3: {
                    this.logger.trace(message);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown logging level: " + priority);
                }
            }
        }
    }
}

