/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.semconv.incubating.HttpIncubatingAttributes;
import java.util.List;
import javax.annotation.Nullable;

public final class HttpExperimentalAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final HttpCommonAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpExperimentalAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpExperimentalAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private HttpExperimentalAttributesExtractor(HttpCommonAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Long requestBodySize = this.requestBodySize(request);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpIncubatingAttributes.HTTP_REQUEST_BODY_SIZE, (Object)requestBodySize);
        if (response != null) {
            Long responseBodySize = this.responseBodySize(request, response);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, (Object)responseBodySize);
        }
    }

    @Nullable
    private Long requestBodySize(REQUEST request) {
        return HttpExperimentalAttributesExtractor.parseNumber(HttpExperimentalAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "content-length")));
    }

    @Nullable
    private Long responseBodySize(REQUEST request, RESPONSE response) {
        return HttpExperimentalAttributesExtractor.parseNumber(HttpExperimentalAttributesExtractor.firstHeaderValue(this.getter.getHttpResponseHeader(request, response, "content-length")));
    }

    @Nullable
    static String firstHeaderValue(List<String> values) {
        return values.isEmpty() ? null : values.get(0);
    }

    @Nullable
    private static Long parseNumber(@Nullable String number) {
        if (number == null) {
            return null;
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

