/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.PropagatorBasedSpanLinksExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaBatchProcessSpanLinksExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerRecordGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerRequest;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveRequest;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.RecordMetadata;

public final class KafkaInstrumenterFactory {
    private final OpenTelemetry openTelemetry;
    private final String instrumentationName;
    private ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.getDefault();
    private List<String> capturedHeaders = Collections.emptyList();
    private boolean captureExperimentalSpanAttributes = false;
    private boolean messagingReceiveInstrumentationEnabled = false;

    public KafkaInstrumenterFactory(OpenTelemetry openTelemetry, String instrumentationName) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
    }

    @CanIgnoreReturnValue
    public KafkaInstrumenterFactory setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = errorCauseExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaInstrumenterFactory setCapturedHeaders(List<String> capturedHeaders) {
        this.capturedHeaders = capturedHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaInstrumenterFactory setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public KafkaInstrumenterFactory setPropagationEnabled(boolean propagationEnabled) {
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaInstrumenterFactory setMessagingReceiveInstrumentationEnabled(boolean messagingReceiveInstrumentationEnabled) {
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
        return this;
    }

    public Instrumenter<KafkaProducerRequest, RecordMetadata> createProducerInstrumenter() {
        return this.createProducerInstrumenter(Collections.emptyList());
    }

    public Instrumenter<KafkaProducerRequest, RecordMetadata> createProducerInstrumenter(Iterable<AttributesExtractor<KafkaProducerRequest, RecordMetadata>> extractors) {
        KafkaProducerAttributesGetter getter = KafkaProducerAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.PUBLISH;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).addAttributesExtractors(extractors).addAttributesExtractor((AttributesExtractor)new KafkaProducerAttributesExtractor()).setErrorCauseExtractor(this.errorCauseExtractor).buildInstrumenter(SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<KafkaReceiveRequest, Void> createConsumerReceiveInstrumenter() {
        return this.createConsumerReceiveInstrumenter(Collections.emptyList());
    }

    public Instrumenter<KafkaReceiveRequest, Void> createConsumerReceiveInstrumenter(Iterable<AttributesExtractor<KafkaReceiveRequest, Void>> extractors) {
        KafkaReceiveAttributesGetter getter = KafkaReceiveAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.RECEIVE;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).addAttributesExtractor((AttributesExtractor)KafkaReceiveAttributesExtractor.INSTANCE).addAttributesExtractors(extractors).setErrorCauseExtractor(this.errorCauseExtractor).setEnabled(this.messagingReceiveInstrumentationEnabled).buildInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    public Instrumenter<KafkaProcessRequest, Void> createConsumerProcessInstrumenter() {
        return this.createConsumerProcessInstrumenter(Collections.emptyList());
    }

    public Instrumenter<KafkaProcessRequest, Void> createConsumerProcessInstrumenter(Iterable<AttributesExtractor<KafkaProcessRequest, Void>> extractors) {
        KafkaConsumerAttributesGetter getter = KafkaConsumerAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.PROCESS;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).addAttributesExtractor((AttributesExtractor)new KafkaConsumerAttributesExtractor()).addAttributesExtractors(extractors).setErrorCauseExtractor(this.errorCauseExtractor);
        if (this.captureExperimentalSpanAttributes) {
            builder.addAttributesExtractor((AttributesExtractor)new KafkaConsumerExperimentalAttributesExtractor());
        }
        if (this.messagingReceiveInstrumentationEnabled) {
            builder.addSpanLinksExtractor((SpanLinksExtractor)new PropagatorBasedSpanLinksExtractor(this.openTelemetry.getPropagators().getTextMapPropagator(), (TextMapGetter)KafkaConsumerRecordGetter.INSTANCE));
            return builder.buildInstrumenter(SpanKindExtractor.alwaysConsumer());
        }
        return builder.buildConsumerInstrumenter((TextMapGetter)KafkaConsumerRecordGetter.INSTANCE);
    }

    public Instrumenter<KafkaReceiveRequest, Void> createBatchProcessInstrumenter() {
        KafkaReceiveAttributesGetter getter = KafkaReceiveAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.PROCESS;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).addAttributesExtractor((AttributesExtractor)KafkaReceiveAttributesExtractor.INSTANCE).addSpanLinksExtractor((SpanLinksExtractor)new KafkaBatchProcessSpanLinksExtractor(this.openTelemetry.getPropagators().getTextMapPropagator())).setErrorCauseExtractor(this.errorCauseExtractor).buildInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    private static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> buildMessagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation, List<String> capturedHeaders) {
        return MessagingAttributesExtractor.builder(getter, (MessageOperation)operation).setCapturedHeaders(capturedHeaders).build();
    }
}

