/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryInjector;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.MapConverter;
import io.opentelemetry.instrumentation.spring.autoconfigure.properties.OtelResourceProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.properties.OtlpExporterProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.properties.PropagationProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.properties.SpringConfigProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.resources.DistroVersionResourceProvider;
import io.opentelemetry.instrumentation.spring.autoconfigure.resources.SpringResourceProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.internal.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={OtlpExporterProperties.class, OtelResourceProperties.class, PropagationProperties.class})
public class OpenTelemetryAutoConfiguration {

    public static class OpenTelemetrySdkComponentLoader
    implements ComponentLoader {
        private final ApplicationContext applicationContext;
        private final SpiHelper spiHelper = SpiHelper.create((ClassLoader)OpenTelemetrySdkComponentLoader.class.getClassLoader());

        public OpenTelemetrySdkComponentLoader(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public <T> Iterable<T> load(Class<T> spiClass) {
            List spi = this.spiHelper.load(spiClass);
            List beans = this.applicationContext.getBeanProvider(spiClass).orderedStream().collect(Collectors.toList());
            spi.addAll(beans);
            return spi;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    @ConditionalOnProperty(name={"otel.sdk.disabled"}, havingValue="true")
    public static class DisabledOpenTelemetrySdkConfig {
        @Bean
        public OpenTelemetry openTelemetry() {
            return OpenTelemetry.noop();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    @ConditionalOnProperty(name={"otel.sdk.disabled"}, havingValue="false", matchIfMissing=true)
    public static class OpenTelemetrySdkConfig {
        @Bean
        @ConfigurationPropertiesBinding
        public MapConverter mapConverter() {
            return new MapConverter();
        }

        @Bean
        public OpenTelemetrySdkComponentLoader openTelemetrySdkComponentLoader(ApplicationContext applicationContext) {
            return new OpenTelemetrySdkComponentLoader(applicationContext);
        }

        @Bean
        public ResourceProvider otelSpringResourceProvider(Optional<BuildProperties> buildProperties) {
            return new SpringResourceProvider(buildProperties);
        }

        @Bean
        public ResourceProvider otelDistroVersionResourceProvider() {
            return new DistroVersionResourceProvider();
        }

        @Bean
        public OpenTelemetry openTelemetry(Environment env, OtlpExporterProperties otlpExporterProperties, OtelResourceProperties resourceProperties, PropagationProperties propagationProperties, OpenTelemetrySdkComponentLoader componentLoader, ObjectProvider<OpenTelemetryInjector> openTelemetryConsumerProvider) {
            OpenTelemetrySdk openTelemetry = AutoConfigureUtil.setComponentLoader((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfigureUtil.setConfigPropertiesCustomizer((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder(), c -> SpringConfigProperties.create(env, otlpExporterProperties, resourceProperties, propagationProperties, c)), (ComponentLoader)componentLoader).build().getOpenTelemetrySdk();
            openTelemetryConsumerProvider.forEach(arg_0 -> OpenTelemetrySdkConfig.lambda$openTelemetry$1((OpenTelemetry)openTelemetry, arg_0));
            return openTelemetry;
        }

        private static /* synthetic */ void lambda$openTelemetry$1(OpenTelemetry openTelemetry, OpenTelemetryInjector consumer) {
            consumer.accept(openTelemetry);
        }
    }
}

