/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.annotations;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.annotations.InstrumentationWithSpanAspect;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.SdkEnabled;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

@ConditionalOnBean(value={OpenTelemetry.class})
@ConditionalOnClass(value={Aspect.class})
@ConditionalOnProperty(name={"otel.instrumentation.annotations.enabled"}, matchIfMissing=true)
@Conditional(value={SdkEnabled.class})
@Configuration
public class InstrumentationAnnotationsAutoConfiguration {
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    @Bean
    @ConditionalOnClass(value={WithSpan.class})
    InstrumentationWithSpanAspect otelInstrumentationWithSpanAspect(OpenTelemetry openTelemetry) {
        return new InstrumentationWithSpanAspect(openTelemetry, this.parameterNameDiscoverer);
    }
}

