/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.logging;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.SdkEnabled;
import org.apache.logging.log4j.core.LoggerContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@ConditionalOnBean(value={OpenTelemetry.class})
@Configuration
@Conditional(value={SdkEnabled.class})
public class OpenTelemetryAppenderAutoConfiguration {

    @ConditionalOnClass(value={ch.qos.logback.classic.LoggerContext.class})
    @ConditionalOnProperty(name={"otel.instrumentation.logback-appender.enabled"}, matchIfMissing=true)
    @Configuration
    static class LogbackAppenderConfig {
        LogbackAppenderConfig() {
        }

        @Bean
        ApplicationListener<ApplicationReadyEvent> logbackOtelAppenderInitializer(OpenTelemetry openTelemetry) {
            return event -> OpenTelemetryAppender.install((OpenTelemetry)openTelemetry);
        }
    }

    @ConditionalOnClass(value={LoggerContext.class})
    @ConditionalOnProperty(name={"otel.instrumentation.log4j-appender.enabled"}, matchIfMissing=true)
    @Configuration
    static class Log4jAppenderConfig {
        Log4jAppenderConfig() {
        }

        @Bean
        ApplicationListener<ApplicationReadyEvent> log4jOtelAppenderInitializer(OpenTelemetry openTelemetry) {
            return event -> io.opentelemetry.instrumentation.log4j.appender.v2_17.OpenTelemetryAppender.install((OpenTelemetry)openTelemetry);
        }
    }
}

