/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.kafka.v2_7;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerContextUtil;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.State;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.RecordInterceptor;

final class InstrumentedRecordInterceptor<K, V>
implements RecordInterceptor<K, V> {
    private static final VirtualField<ConsumerRecord<?, ?>, State<KafkaProcessRequest>> stateField = VirtualField.find(ConsumerRecord.class, State.class);
    private final Instrumenter<KafkaProcessRequest, Void> processInstrumenter;
    @Nullable
    private final RecordInterceptor<K, V> decorated;

    InstrumentedRecordInterceptor(Instrumenter<KafkaProcessRequest, Void> processInstrumenter, @Nullable RecordInterceptor<K, V> decorated) {
        this.processInstrumenter = processInstrumenter;
        this.decorated = decorated;
    }

    @NoMuzzle
    public ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record) {
        this.start(record, null);
        return this.decorated == null ? record : this.decorated.intercept(record);
    }

    public ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.start(record, consumer);
        return this.decorated == null ? record : this.decorated.intercept(record, consumer);
    }

    private void start(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        KafkaProcessRequest request;
        Context parentContext = InstrumentedRecordInterceptor.getParentContext(record);
        if (this.processInstrumenter.shouldStart(parentContext, (Object)(request = KafkaProcessRequest.create(record, consumer)))) {
            Context context = this.processInstrumenter.start(parentContext, (Object)request);
            Scope scope = context.makeCurrent();
            stateField.set(record, State.create(request, context, scope));
        }
    }

    private static Context getParentContext(ConsumerRecord<?, ?> record) {
        KafkaConsumerContext consumerContext = KafkaConsumerContextUtil.get(record);
        Context receiveContext = consumerContext.getContext();
        return receiveContext != null ? receiveContext : Context.current();
    }

    public void success(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.end(record, null);
        if (this.decorated != null) {
            this.decorated.success(record, consumer);
        }
    }

    public void failure(ConsumerRecord<K, V> record, Exception exception, Consumer<K, V> consumer) {
        this.end(record, exception);
        if (this.decorated != null) {
            this.decorated.failure(record, exception, consumer);
        }
    }

    private void end(ConsumerRecord<K, V> record, @Nullable Throwable error) {
        State state = (State)stateField.get(record);
        stateField.set(record, null);
        if (state != null) {
            KafkaProcessRequest request = (KafkaProcessRequest)state.request();
            state.scope().close();
            this.processInstrumenter.end(state.context(), (Object)request, null, error);
        }
    }

    @NoMuzzle
    public void afterRecord(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        if (this.decorated != null) {
            this.decorated.afterRecord(record, consumer);
        }
    }

    @NoMuzzle
    public void setupThreadState(Consumer<?, ?> consumer) {
        if (this.decorated != null) {
            this.decorated.setupThreadState(consumer);
        }
    }

    @NoMuzzle
    public void clearThreadState(Consumer<?, ?> consumer) {
        if (this.decorated != null) {
            this.decorated.clearThreadState(consumer);
        }
    }
}

