/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.MutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoirFactory;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class LongSumAggregator
extends AbstractSumAggregator<LongPointData, LongExemplarData> {
    private final ExemplarReservoirFactory reservoirFactory;
    private final MemoryMode memoryMode;

    public LongSumAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarReservoirFactory reservoirFactory, MemoryMode memoryMode) {
        super(instrumentDescriptor);
        this.reservoirFactory = reservoirFactory;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<LongPointData> createHandle() {
        return new Handle(this.reservoirFactory, this.memoryMode);
    }

    @Override
    public LongPointData diff(LongPointData previousPoint, LongPointData currentPoint) {
        return ImmutableLongPointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public void diffInPlace(LongPointData previousReusablePoint, LongPointData currentPoint) {
        ((MutableLongPointData)previousReusablePoint).set(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousReusablePoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public LongPointData createReusablePoint() {
        return new MutableLongPointData();
    }

    @Override
    public void copyPoint(LongPointData point, LongPointData toReusablePoint) {
        ((MutableLongPointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData> {
        private final LongAdder current = AdderUtil.createLongAdder();
        @Nullable
        private final MutableLongPointData reusablePointData;

        Handle(ExemplarReservoirFactory reservoirFactory, MemoryMode memoryMode) {
            super(reservoirFactory, false);
            this.reusablePointData = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableLongPointData() : null;
        }

        @Override
        protected LongPointData doAggregateThenMaybeResetLongs(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            long value;
            long l = value = reset ? this.current.sumThenReset() : this.current.sum();
            if (this.reusablePointData != null) {
                this.reusablePointData.set(startEpochNanos, epochNanos, attributes, value, exemplars);
                return this.reusablePointData;
            }
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

