/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.error.ShouldContainKeys;
import org.assertj.core.error.ShouldNotContainKeys;

public final class AttributesAssert
extends AbstractAssert<AttributesAssert, Attributes> {
    AttributesAssert(@Nullable Attributes actual) {
        super((Object)actual, AttributesAssert.class);
    }

    public <T> AttributesAssert containsEntry(AttributeKey<T> key, T value) {
        this.isNotNull();
        this.containsKey(key);
        Object actualValue = ((Attributes)this.actual).get(key);
        if (!Objects.equals(actualValue, value)) {
            this.failWithActualExpectedAndMessage(actualValue, value, "Expected attributes to have key <%s> with value <%s> but was value <%s>", new Object[]{key, value, actualValue});
        }
        return this;
    }

    public AttributesAssert containsEntry(AttributeKey<Long> key, int value) {
        return this.containsEntry(key, Long.valueOf(value));
    }

    public AttributesAssert containsEntry(String key, String value) {
        return this.containsEntry(AttributeKey.stringKey((String)key), value);
    }

    public AttributesAssert containsEntry(String key, boolean value) {
        return this.containsEntry(AttributeKey.booleanKey((String)key), Boolean.valueOf(value));
    }

    public AttributesAssert containsEntry(String key, long value) {
        return this.containsEntry(AttributeKey.longKey((String)key), Long.valueOf(value));
    }

    public AttributesAssert containsEntry(String key, double value) {
        return this.containsEntry(AttributeKey.doubleKey((String)key), Double.valueOf(value));
    }

    public AttributesAssert containsEntry(String key, String ... value) {
        return this.containsEntry(AttributeKey.stringArrayKey((String)key), Arrays.asList(value));
    }

    public AttributesAssert containsEntry(String key, Boolean ... value) {
        return this.containsEntry(AttributeKey.booleanArrayKey((String)key), Arrays.asList(value));
    }

    public AttributesAssert containsEntry(String key, Long ... value) {
        return this.containsEntry(AttributeKey.longArrayKey((String)key), Arrays.asList(value));
    }

    public AttributesAssert containsEntry(String key, Double ... value) {
        return this.containsEntry(AttributeKey.doubleArrayKey((String)key), Arrays.asList(value));
    }

    public AttributesAssert containsEntryWithStringValuesOf(String key, Iterable<String> value) {
        this.isNotNull();
        this.containsKey(key);
        List actualValue = (List)((Attributes)this.actual).get(AttributeKey.stringArrayKey((String)key));
        ((ListAssert)Assertions.assertThat((List)actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public AttributesAssert containsEntryWithBooleanValuesOf(String key, Iterable<Boolean> value) {
        this.isNotNull();
        this.containsKey(key);
        List actualValue = (List)((Attributes)this.actual).get(AttributeKey.booleanArrayKey((String)key));
        ((ListAssert)Assertions.assertThat((List)actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public AttributesAssert containsEntryWithLongValuesOf(String key, Iterable<Long> value) {
        this.isNotNull();
        this.containsKey(key);
        List actualValue = (List)((Attributes)this.actual).get(AttributeKey.longArrayKey((String)key));
        ((ListAssert)Assertions.assertThat((List)actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public AttributesAssert containsEntryWithDoubleValuesOf(String key, Iterable<Double> value) {
        this.isNotNull();
        this.containsKey(key);
        List actualValue = (List)((Attributes)this.actual).get(AttributeKey.doubleArrayKey((String)key));
        ((ListAssert)Assertions.assertThat((List)actualValue).withFailMessage("Expected attributes to have key <%s> with value <%s> but was <%s>", new Object[]{key, value, actualValue})).containsExactlyElementsOf(value);
        return this;
    }

    public <T> AttributesAssert hasEntrySatisfying(AttributeKey<T> key, Consumer<T> valueCondition) {
        this.isNotNull();
        this.containsKey(key);
        ((ObjectAssert)Assertions.assertThat((Object)((Attributes)this.actual).get(key)).as("value", new Object[0])).satisfies(new Consumer[]{valueCondition});
        return this;
    }

    @SafeVarargs
    public final AttributesAssert containsOnly(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        this.isNotNull();
        Assertions.assertThat((Map)((Attributes)this.actual).asMap()).containsOnly((Map.Entry[])entries);
        return this;
    }

    public AttributesAssert containsKey(AttributeKey<?> key) {
        if (((Attributes)this.actual).get(key) == null) {
            this.failWithMessage(ShouldContainKeys.shouldContainKeys((Object)this.actual, Collections.singleton(key)).create(this.info.description(), this.info.representation()), new Object[0]);
        }
        return this;
    }

    public AttributesAssert containsKey(String key) {
        Optional<AttributeKey> resolved = ((Attributes)this.actual).asMap().keySet().stream().filter(attributeKey -> attributeKey.getKey().equals(key)).findFirst();
        if (!resolved.isPresent()) {
            this.failWithMessage(ShouldContainKeys.shouldContainKeys((Object)this.actual, Collections.singleton(key)).create(this.info.description(), this.info.representation()), new Object[0]);
        }
        return this;
    }

    public AttributesAssert doesNotContainKey(AttributeKey<?> key) {
        if (((Attributes)this.actual).get(key) != null) {
            this.failWithMessage(ShouldNotContainKeys.shouldNotContainKeys((Object)this.actual, Collections.singleton(key)).create(this.info.description(), this.info.representation()), new Object[0]);
        }
        return this;
    }

    public AttributesAssert doesNotContainKey(String key) {
        boolean containsKey = ((Attributes)this.actual).asMap().keySet().stream().anyMatch(attributeKey -> attributeKey.getKey().equals(key));
        if (containsKey) {
            this.failWithMessage(ShouldNotContainKeys.shouldNotContainKeys((Object)this.actual, Collections.singleton(key)).create(this.info.description(), this.info.representation()), new Object[0]);
        }
        return this;
    }

    public AttributesAssert isEmpty() {
        return (AttributesAssert)this.isEqualTo(Attributes.empty());
    }

    public AttributesAssert hasSize(int numberOfEntries) {
        int size = ((Attributes)this.actual).size();
        if (size != numberOfEntries) {
            this.failWithActualExpectedAndMessage(size, numberOfEntries, "Expected attributes to have <%s> entries but actually has <%s>", new Object[]{numberOfEntries, size});
        }
        return this;
    }
}

