/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.metrics;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.metrics.TestMetricData;

final class AutoValue_TestMetricData
extends TestMetricData {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final String name;
    private final String description;
    private final String unit;
    private final MetricDataType type;
    private final Data<?> data;

    private AutoValue_TestMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, MetricDataType type, Data<?> data) {
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.type = type;
        this.data = data;
    }

    public Resource getResource() {
        return this.resource;
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public MetricDataType getType() {
        return this.type;
    }

    public Data<?> getData() {
        return this.data;
    }

    public String toString() {
        return "TestMetricData{resource=" + this.resource + ", instrumentationScopeInfo=" + this.instrumentationScopeInfo + ", name=" + this.name + ", description=" + this.description + ", unit=" + this.unit + ", type=" + this.type + ", data=" + this.data + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TestMetricData) {
            TestMetricData that = (TestMetricData)o;
            return this.resource.equals(that.getResource()) && this.instrumentationScopeInfo.equals(that.getInstrumentationScopeInfo()) && this.name.equals(that.getName()) && this.description.equals(that.getDescription()) && this.unit.equals(that.getUnit()) && this.type.equals((Object)that.getType()) && this.data.equals((Object)that.getData());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resource.hashCode();
        h$ *= 1000003;
        h$ ^= this.instrumentationScopeInfo.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.unit.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        return h$ ^= this.data.hashCode();
    }

    static final class Builder
    extends TestMetricData.Builder {
        private Resource resource;
        private InstrumentationScopeInfo instrumentationScopeInfo;
        private String name;
        private String description;
        private String unit;
        private MetricDataType type;
        private Data<?> data;

        Builder() {
        }

        @Override
        public TestMetricData.Builder setResource(Resource resource) {
            if (resource == null) {
                throw new NullPointerException("Null resource");
            }
            this.resource = resource;
            return this;
        }

        @Override
        public TestMetricData.Builder setInstrumentationScopeInfo(InstrumentationScopeInfo instrumentationScopeInfo) {
            if (instrumentationScopeInfo == null) {
                throw new NullPointerException("Null instrumentationScopeInfo");
            }
            this.instrumentationScopeInfo = instrumentationScopeInfo;
            return this;
        }

        @Override
        public TestMetricData.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public TestMetricData.Builder setDescription(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public TestMetricData.Builder setUnit(String unit) {
            if (unit == null) {
                throw new NullPointerException("Null unit");
            }
            this.unit = unit;
            return this;
        }

        @Override
        TestMetricData.Builder setType(MetricDataType type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        TestMetricData.Builder setData(Data<?> data) {
            if (data == null) {
                throw new NullPointerException("Null data");
            }
            this.data = data;
            return this;
        }

        @Override
        TestMetricData autoBuild() {
            if (this.resource == null || this.instrumentationScopeInfo == null || this.name == null || this.description == null || this.unit == null || this.type == null || this.data == null) {
                StringBuilder missing = new StringBuilder();
                if (this.resource == null) {
                    missing.append(" resource");
                }
                if (this.instrumentationScopeInfo == null) {
                    missing.append(" instrumentationScopeInfo");
                }
                if (this.name == null) {
                    missing.append(" name");
                }
                if (this.description == null) {
                    missing.append(" description");
                }
                if (this.unit == null) {
                    missing.append(" unit");
                }
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.data == null) {
                    missing.append(" data");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TestMetricData(this.resource, this.instrumentationScopeInfo, this.name, this.description, this.unit, this.type, this.data);
        }
    }
}

