/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.opentracing.BraveScope;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanContext;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.LinkedHashMap;
import java.util.Map;

public class BraveSpanBuilder
implements Tracer.SpanBuilder {
    final Tracer tracer;
    final CurrentTraceContext currentTraceContext;
    final Map<String, String> tags = new LinkedHashMap<String, String>();
    String operationName;
    long timestamp;
    int remotePort;
    BraveSpanContext reference;
    boolean ignoreActiveSpan = false;

    BraveSpanBuilder(Tracing tracing, String operationName) {
        this.tracer = tracing.tracer();
        this.currentTraceContext = tracing.currentTraceContext();
        this.operationName = operationName;
    }

    public BraveSpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public BraveSpanBuilder asChildOf(io.opentracing.Span parent) {
        return this.asChildOf(parent != null ? parent.context() : null);
    }

    public BraveSpanBuilder addReference(String type, SpanContext context) {
        if (this.reference != null || context == null) {
            return this;
        }
        if ("child_of".equals(type) || "follows_from".equals(type)) {
            this.reference = (BraveSpanContext)context;
        }
        return this;
    }

    public BraveSpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public BraveSpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key) && !value) {
            return this;
        }
        return this.withTag(key, Boolean.toString(value));
    }

    public BraveSpanBuilder withTag(String key, Number value) {
        if (Tags.PEER_PORT.getKey().equals(key)) {
            this.remotePort = value.intValue();
            return this;
        }
        return this.withTag(key, value.toString());
    }

    public <T> BraveSpanBuilder withTag(Tag<T> tag, T value) {
        if (tag == null) {
            throw new NullPointerException("tag == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (value instanceof String) {
            return this.withTag(tag.getKey(), (String)value);
        }
        if (value instanceof Number) {
            return this.withTag(tag.getKey(), (Number)value);
        }
        if (value instanceof Boolean) {
            return this.withTag(tag.getKey(), (Boolean)value);
        }
        throw new IllegalArgumentException("tag value not a string, number or boolean: " + value);
    }

    public BraveSpanBuilder withStartTimestamp(long microseconds) {
        this.timestamp = microseconds;
        return this;
    }

    public BraveSpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BraveSpan start() {
        Span span;
        boolean server = "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        CurrentTraceContext.Scope scope = this.ignoreActiveSpan ? this.currentTraceContext.newScope(null) : CurrentTraceContext.Scope.NOOP;
        try {
            TraceContext context;
            Span parent;
            if (this.reference == null && (parent = this.tracer.currentSpan()) != null) {
                this.asChildOf(BraveSpanContext.create(parent.context()));
            }
            span = this.reference == null ? this.tracer.nextSpan(BraveSpanBuilder.flagsFromSamplingPriority(this.tags.get(Tags.SAMPLING_PRIORITY.getKey()))) : ((context = this.reference.unwrap()) != null ? (server ? this.tracer.joinSpan(context) : this.tracer.newChild(context)) : this.tracer.nextSpan(((BraveSpanContext.Incomplete)this.reference).extractionResult()));
        }
        finally {
            scope.close();
        }
        if (this.operationName != null) {
            span.name(this.operationName);
        }
        BraveSpan result = new BraveSpan(this.tracer, span);
        result.remotePort = this.remotePort;
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            result.setTag(tag.getKey(), tag.getValue());
        }
        if (this.timestamp != 0L) {
            span.start(this.timestamp);
        } else {
            span.start();
        }
        return result;
    }

    @Deprecated
    public BraveSpan startManual() {
        throw new UnsupportedOperationException("Not supported in OpenTracing 0.33+");
    }

    @Deprecated
    public BraveScope startActive(boolean finishSpanOnClose) {
        throw new UnsupportedOperationException("Not supported in OpenTracing 0.33+");
    }

    static TraceContextOrSamplingFlags flagsFromSamplingPriority(String samplingPriorityString) {
        if (samplingPriorityString == null) {
            return TraceContextOrSamplingFlags.EMPTY;
        }
        try {
            int samplingPriority = Integer.parseInt(samplingPriorityString);
            if (samplingPriority == 0) {
                return TraceContextOrSamplingFlags.NOT_SAMPLED;
            }
            if (samplingPriority > 0) {
                return TraceContextOrSamplingFlags.SAMPLED;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return TraceContextOrSamplingFlags.EMPTY;
    }
}

