/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.traces.LowAllocationTraceRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.data.SpanData;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.BiFunction;

public class SpanReusableDataMarshaler {
    private final Deque<LowAllocationTraceRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationTraceRequestMarshaler>();
    private final MemoryMode memoryMode;
    private final BiFunction<Marshaler, Integer, CompletableResultCode> doExport;

    public SpanReusableDataMarshaler(MemoryMode memoryMode, BiFunction<Marshaler, Integer, CompletableResultCode> doExport) {
        this.memoryMode = memoryMode;
        this.doExport = doExport;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationTraceRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationTraceRequestMarshaler();
            }
            LowAllocationTraceRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(spans);
            return this.doExport.apply(exportMarshaler, spans.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.doExport.apply(request, spans.size());
    }
}

