/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.incubator.builder.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.OpenTelemetry;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.context.propagation.TextMapGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.incubator.config.internal.CommonConfig;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.incubator.semconv.http.HttpServerExperimentalMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.instrumenter.AttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.instrumenter.Instrumenter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.instrumenter.SpanKindExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.instrumenter.SpanNameExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesExtractorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpServerMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpServerRoute;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpServerRouteBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> {
    private final String instrumentationName;
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> additionalExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    private Function<SpanStatusExtractor<? super REQUEST, ? super RESPONSE>, ? extends SpanStatusExtractor<? super REQUEST, ? super RESPONSE>> statusExtractorTransformer = Function.identity();
    private final HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> httpAttributesExtractorBuilder;
    private final HttpSpanNameExtractorBuilder<REQUEST> httpSpanNameExtractorBuilder;
    @Nullable
    private final TextMapGetter<REQUEST> headerGetter;
    private Function<SpanNameExtractor<? super REQUEST>, ? extends SpanNameExtractor<? super REQUEST>> spanNameExtractorTransformer = Function.identity();
    private final HttpServerRouteBuilder<REQUEST> httpServerRouteBuilder;
    private final HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private boolean emitExperimentalHttpServerMetrics = false;
    private Consumer<InstrumenterBuilder<REQUEST, RESPONSE>> builderCustomizer = b -> {};

    private DefaultHttpServerInstrumenterBuilder(String instrumentationName, OpenTelemetry openTelemetry, HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, TextMapGetter<REQUEST> headerGetter) {
        this.instrumentationName = Objects.requireNonNull(instrumentationName, "instrumentationName");
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry");
        this.attributesGetter = Objects.requireNonNull(attributesGetter, "attributesGetter");
        this.httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder(attributesGetter);
        this.httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder(attributesGetter);
        this.httpServerRouteBuilder = HttpServerRoute.builder(attributesGetter);
        this.headerGetter = headerGetter;
    }

    public static <REQUEST, RESPONSE> DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> create(String instrumentationName, OpenTelemetry openTelemetry, HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        return new DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE>(instrumentationName, openTelemetry, attributesGetter, null);
    }

    public static <REQUEST, RESPONSE> DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> create(String instrumentationName, OpenTelemetry openTelemetry, HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, TextMapGetter<REQUEST> headerGetter) {
        return new DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE>(instrumentationName, openTelemetry, attributesGetter, Objects.requireNonNull(headerGetter, "headerGetter"));
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setStatusExtractor(Function<SpanStatusExtractor<? super REQUEST, ? super RESPONSE>, ? extends SpanStatusExtractor<? super REQUEST, ? super RESPONSE>> statusExtractor) {
        this.statusExtractorTransformer = statusExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setKnownMethods(Collection<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        this.httpServerRouteBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.emitExperimentalHttpServerMetrics = emitExperimentalHttpServerMetrics;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setSpanNameExtractor(Function<SpanNameExtractor<? super REQUEST>, ? extends SpanNameExtractor<? super REQUEST>> spanNameExtractorTransformer) {
        this.spanNameExtractorTransformer = spanNameExtractorTransformer;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setBuilderCustomizer(Consumer<InstrumenterBuilder<REQUEST, RESPONSE>> builderCustomizer) {
        this.builderCustomizer = builderCustomizer;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> build() {
        InstrumenterBuilder builder = this.instrumenterBuilder();
        if (this.headerGetter != null) {
            return builder.buildServerInstrumenter(this.headerGetter);
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysServer());
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> instrumenterBuilder() {
        SpanNameExtractor<? super REQUEST> spanNameExtractor = this.spanNameExtractorTransformer.apply(this.httpSpanNameExtractorBuilder.build());
        InstrumenterBuilder<REQUEST, RESPONSE> builder = Instrumenter.builder(this.openTelemetry, this.instrumentationName, spanNameExtractor).setSpanStatusExtractor(this.statusExtractorTransformer.apply(HttpSpanStatusExtractor.create(this.attributesGetter))).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addContextCustomizer(this.httpServerRouteBuilder.build()).addOperationMetrics(HttpServerMetrics.get());
        if (this.emitExperimentalHttpServerMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create(this.attributesGetter)).addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        this.builderCustomizer.accept(builder);
        return builder;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> configure(CommonConfig config) {
        DefaultHttpServerInstrumenterBuilder.set(config::getKnownHttpRequestMethods, this::setKnownMethods);
        DefaultHttpServerInstrumenterBuilder.set(config::getServerRequestHeaders, this::setCapturedRequestHeaders);
        DefaultHttpServerInstrumenterBuilder.set(config::getServerResponseHeaders, this::setCapturedResponseHeaders);
        DefaultHttpServerInstrumenterBuilder.set(config::shouldEmitExperimentalHttpServerTelemetry, this::setEmitExperimentalHttpServerMetrics);
        return this;
    }

    private static <T> void set(Supplier<T> supplier, Consumer<T> consumer) {
        T t = supplier.get();
        if (t != null) {
            consumer.accept(t);
        }
    }
}

