/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.incubator.semconv.db;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.instrumenter.AttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.internal.AttributesExtractorUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.internal.SemconvStability;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.internal.SpanKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.internal.SpanKeyProvider;
import javax.annotation.Nullable;

abstract class DbClientCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends DbClientCommonAttributesGetter<REQUEST>>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_NAME = AttributeKey.stringKey("db.name");
    static final AttributeKey<String> DB_NAMESPACE = AttributeKey.stringKey("db.namespace");
    static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey("db.system");
    private static final AttributeKey<String> DB_USER = AttributeKey.stringKey("db.user");
    private static final AttributeKey<String> DB_CONNECTION_STRING = AttributeKey.stringKey("db.connection_string");
    final GETTER getter;

    DbClientCommonAttributesExtractor(GETTER getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, DB_SYSTEM, this.getter.getDbSystem(request));
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DB_NAMESPACE, this.getter.getDbNamespace(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DB_USER, this.getter.getUser(request));
            AttributesExtractorUtil.internalSet(attributes, DB_NAME, this.getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet(attributes, DB_CONNECTION_STRING, this.getter.getConnectionString(request));
        }
    }

    @Override
    public final void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

