/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.internal.JavaVersionSpecific;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SystemClock
implements Clock {
    private static final SystemClock INSTANCE = new SystemClock();

    private SystemClock() {
    }

    static Clock getInstance() {
        return INSTANCE;
    }

    @Override
    public long now() {
        return this.now(true);
    }

    @Override
    public long now(boolean highPrecision) {
        if (highPrecision) {
            return JavaVersionSpecific.get().currentTimeNanos();
        }
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    public String toString() {
        return "SystemClock{}";
    }
}

