/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.incubator.trace.ExtendedTracer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.trace.SpanBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.trace.Tracer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.trace.TracerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.SdkSpanBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.TracerSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.internal.TracerConfig;

final class SdkTracer
implements ExtendedTracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private static final Tracer NOOP_TRACER = TracerProvider.noop().get("noop");
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private boolean tracerEnabled;

    SdkTracer(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, TracerConfig tracerConfig) {
        this.sharedState = sharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerEnabled = tracerConfig.isEnabled();
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (!this.tracerEnabled) {
            return NOOP_TRACER.spanBuilder(spanName);
        }
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationScopeInfo.getName());
            return tracer.spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public boolean isEnabled() {
        return this.tracerEnabled;
    }
}

