/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.http.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.export.LogRecordExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpLogRecordExporter
implements LogRecordExporter {
    private final HttpExporterBuilder<LogsRequestMarshaler> builder;
    private final HttpExporter<LogsRequestMarshaler> delegate;

    OtlpHttpLogRecordExporter(HttpExporterBuilder<LogsRequestMarshaler> builder, HttpExporter<LogsRequestMarshaler> delegate) {
        this.builder = builder;
        this.delegate = delegate;
    }

    public static OtlpHttpLogRecordExporter getDefault() {
        return OtlpHttpLogRecordExporter.builder().build();
    }

    public static OtlpHttpLogRecordExporterBuilder builder() {
        return new OtlpHttpLogRecordExporterBuilder();
    }

    public OtlpHttpLogRecordExporterBuilder toBuilder() {
        return new OtlpHttpLogRecordExporterBuilder(this.builder.copy());
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        LogsRequestMarshaler exportRequest = LogsRequestMarshaler.create(logs);
        return this.delegate.export(exportRequest, logs.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpHttpLogRecordExporter{" + this.builder.toString(false) + "}";
    }
}

