/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.LogLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.LogRecordProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.logs.SdkLoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class SdkLoggerProviderBuilder {
    private final List<LogRecordProcessor> logRecordProcessors = new ArrayList<LogRecordProcessor>();
    private Resource resource = Resource.getDefault();
    private Supplier<LogLimits> logLimitsSupplier = LogLimits::getDefault;
    private Clock clock = Clock.getDefault();

    SdkLoggerProviderBuilder() {
    }

    public SdkLoggerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkLoggerProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    public SdkLoggerProviderBuilder setLogLimits(Supplier<LogLimits> logLimitsSupplier) {
        Objects.requireNonNull(logLimitsSupplier, "logLimitsSupplier");
        this.logLimitsSupplier = logLimitsSupplier;
        return this;
    }

    public SdkLoggerProviderBuilder addLogRecordProcessor(LogRecordProcessor processor) {
        Objects.requireNonNull(processor, "processor");
        this.logRecordProcessors.add(processor);
        return this;
    }

    public SdkLoggerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkLoggerProvider build() {
        return new SdkLoggerProvider(this.resource, this.logLimitsSupplier, this.logRecordProcessors, this.clock);
    }
}

