/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.view;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.PointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.aggregator.Aggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(ExemplarReservoir::longNoSamples, memoryMode);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(ExemplarReservoir::doubleNoSamples, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return instrumentDescriptor.getType() == InstrumentType.OBSERVABLE_GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

